package ca.tecreations.apps.engine;

import ca.tecreations.File;
import ca.tecreations.StringTool;
import ca.tecreations.TextFile;
import ca.tecreations.misc.Time;
import ca.tecreations.net.TLS_TSPS;


import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
/**
 *
 * @author Tim
 */ 
public class WebSnapshot {
    String tecWebRoot = "/var/www/tecreations.ca/html/ca/tecreations/";
    public static String RESET = Engine.RESET;
    public static String RESET_SANS_SCRIPTURES = Engine.RESET_SANS_SCRIPTURES;
    public static String USER_INITIATED_SNAPSHOT = Engine.USER_INITIATED_SNAPSHOT;
    public static String USER_INITIATED_SNAPSHOT_COUNTRY = Engine.USER_INITIATED_SNAPSHOT_COUNTRY;
    
    TLS_TSPS tsps;
    
    public WebSnapshot(TLS_TSPS tsps, String type) {
        this.tsps = tsps;
        if (type.equals(RESET)) doReset();
        else if (type.equals(USER_INITIATED_SNAPSHOT)) doUserInitiatedSnapshot();
//        else if (type.equals(USER_INITIATED_SNAPSHOT_COUNTRY)) doCountryInitiatedSnapshot();
    }
     
    public void doReset() {
        String outDir = StringTool.getUnwrapped(getTodaysSnapshotDir());
        String path;
        Time time = new Time();
        int hours = time.getHours();
        String hms = time.getHMS24(".");
        if (time.getSegment().toLowerCase().equals("am")) {
            path = outDir + "Morning - " + hms + "/";
        } else {
            path = outDir + "Evening - " + hms + "/";
        }
        log("Reset: Dir: " + path);
          
        // record
        new File(path).mkdirs(true);
        new File(tecWebRoot + "index.php").copyToDir(path, null,true); 
        new File(tecWebRoot + "library_en.php").copyToDir(path,null);
        new File(tecWebRoot + "library_fr.php").copyToDir(path,null);
        new File(tecWebRoot + "page_content.php").copyToDir(path,null);
        new File(tecWebRoot + "todays_documentation.php").copyToDir(path,null);
        new File(tecWebRoot + "tims_today.php").copyToDir(path,null);
//        new File(tecWebRoot + "tims_today_scriptures.php").copyToDir(path,null);
        writeTodaysChat(path);
        writeTimsTodayScriptures(path);

        // reset
        File.copyFileToFile(tecWebRoot + "index_default.php",tecWebRoot + "index.php");
        File.copyFileToFile(tecWebRoot + "page_content_default.php",tecWebRoot + "page_content.php");
        File.copyFileToFile(tecWebRoot + "todays_documentation_default.php",tecWebRoot + "todays_documentation.php");
        File.copyFileToFile(tecWebRoot + "tims_today_default.php",tecWebRoot + "tims_today.php");
        File.copyFileToFile(tecWebRoot + "tims_today_scriptures_default.php",tecWebRoot + "tims_today_scriptures.php");
        resetTodaysChat();
    } 
     
    public void doUserInitiatedSnapshot() {
        String outDir = StringTool.getUnwrapped(getTodaysSnapshotDir());
        String path = outDir + new Time().getHMS24(".") + " - User Initiated/";
        log("Users Snapshot: Dir: " + path);
        new File(path).mkdirs();
        System.out.println("\n\nCopying index.php\n\n");
        
        new File(tecWebRoot + "index.php").copyToDir(path, null,true); 
        System.out.println("\n\n");
        new File(tecWebRoot + "library_en.php").copyToDir(path,null);
        new File(tecWebRoot + "library_fr.php").copyToDir(path,null);
        new File(tecWebRoot + "page_content.php").copyToDir(path,null);
        new File(tecWebRoot + "todays_documentation.php").copyToDir(path,null);
        new File(tecWebRoot + "tims_today.php").copyToDir(path,null);
        
//        new File(tecWebRoot + "tims_today_scriptures.php").copyToDir(path,null);
        writeTodaysChat(path);
    }

    public int getSnapshotDayOfMonth() {
        Time time = new Time();
        if (time.isPM()) {
            return time.getDay();
        } else {
            int day = time.getDay() - 1;
            if (day == 0) {
                int month = time.getMonth();
                switch (month) {
                    case 1: return 31; // december
                    case 2: return 31; // january
                    case 3: if (time.isLeapYear()) return 29; else return 28; // february
                    case 4: return 31; // march
                    case 5: return 30; // april
                    case 6: return 31; // may
                    case 7: return 30; // june
                    case 8: return 31; // july
                    case 9: return 31; // august
                    case 10: return 30; // september
                    case 11: return 31; // october
                    default: return 31; // november
                }
            } else {
                return day;
            }
        }
    }
    
    public static String getTecWebRoot() {
        return "/var/www/tecreations.ca/html/ca/tecreations/";
    }
    
    public String getTodaysSnapshotDir() {
        Time time = new Time(); 
        int year = time.getYear();
        int month = time.getMonth();
        int dom = getSnapshotDayOfMonth();
        String path = getTecWebRoot() + "snapshots/" + year + "/" + month + "/" + dom + "/";
        return path;
    }
    
    public void log(String s) {
        System.out.println(s);
        if (tsps != null) tsps.send(s);
    }

    public void resetTodaysChat() {
        Engine.getMySQL().issue("DROP TABLE todays_chat");
    }
    
    public void writeTodaysChat(String outDir) {
        URL url = null;
        try {
            url = new URL("https://tecreations.ca/ca/tecreations/todays_chat.php?reset");
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection) url.openConnection();
                try {
                    connection.setRequestMethod("GET");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    String line;
                    try {
                        while ((line = reader.readLine()) != null) {
                            response.append(line);
                        }
                        reader.close();
                        String textResponse = response.toString();
                        TextFile out = new TextFile(outDir + "todays_chat.php");
                        out.setText(textResponse);
                        out.write();
                        connection.disconnect();
                    } catch (IOException ioe) {
                        log("writeTodaysChat: " + ioe);
                    }
                } catch (ProtocolException pe) {
                    log("writeTodaysChat: " + pe);
                }
            } catch (IOException ioe) {
                log("writeTodaysChat: Unable to open connection: " + ioe);
            }
        } catch (MalformedURLException murle) {
            log("writeTodaysChat: " + murle);
        }
    }
    
    public void writeTimsTodayScriptures(String outDir) {
        URL url = null;
        try {
            url = new URL("https://tecreations.ca/");
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection) url.openConnection();
                try {
                    connection.setRequestMethod("GET");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    String line;
                    try {
                        while ((line = reader.readLine()) != null) {
                            response.append(line);
                        }
                        reader.close();
                        String textResponse = response.toString();
                        TextFile out = new TextFile(outDir + "tims_today_scriptures.php");
                        out.setText(textResponse);
                        out.write();
                        connection.disconnect();
                    } catch (IOException ioe) {
                        log("writeTimsTodayScriptures: " + ioe);
                    }
                } catch (ProtocolException pe) {
                    log("writeTimsTodayScriptures: " + pe);
                }
            } catch (IOException ioe) {
                log("writeTimsTodayScriptures: Unable to open connection: " + ioe);
            }
        } catch (MalformedURLException murle) {
            log("writeTimsTodayScriptures: " + murle);
        }
    }
} 
    