package ca.tecreations.apps.engine;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.net.NoTLSConnectionException;
import ca.tecreations.net.PKIData;
import ca.tecreations.net.ServerOps;
import ca.tecreations.net.TLSClient_TVS12;
/**
 *
 * @author Tim
 */
public class Engine_Shutdown_Local {
    Properties properties = new Properties(ProjectPath.getTecPropsPath() + 
            Engine.class.getSimpleName() + File.separator +
            "properties" + File.separator +
            "localhost_client.properties"
    );
    
    
    public Engine_Shutdown_Local() {
        TLSClient_TVS12 client = null;
        try {
            client = new TLSClient_TVS12(properties,
                    properties.get(PKIData.REMOTE_KEYSTORE_PASSWORD).toCharArray(),
                    false
            );
            client.process(ServerOps.SHUTDOWN);
        } catch (NoTLSConnectionException e) {
            System.err.println("Engine_Shutdown_Local(): no TLS connection: " + e);
        }
        System.exit(0);
    }
 
    public static void main(String[] args) {
        new Engine_Shutdown_Local();
    }
     
}
