package ca.tecreations.apps.engine;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.net.*;

/**
 *
 * @author Tim 
 */  
public class EngineTLS_LocalServer_Shutdown {
    public static String wanIp = Internet.getWanIP(); 
    public static String propsPath = ProjectPath.getTecPropsPath() + 
                              "NetworkConfig" + File.separator +
                              "EngineTLS_local_client.properties";
    
    public static Properties props = new Properties(propsPath);
    
    public static TLSClient_TVS12 client;
        
    public EngineTLS_LocalServer_Shutdown() {
        if (Internet.getLanIP().equals("192.168.1.103")) {
            props.set(PKIData.REMOTE_PORT,61024);
        } else {
            props.set(PKIData.REMOTE_PORT, 61025);
        }
        try {
            client = new TLSClient_TVS12(props,null,false);
            if (client.getStatus().toLowerCase().equals("up")) {
                client.process(ServerOps.SHUTDOWN);
            }
        } catch (NoTLSConnectionException e) {
            System.err.println("EngineTLS_LocalServer_Shutdown(): no TLS connection: " + e);
        }
        System.exit(0);
    }

    public static void launch() {
        new EngineTLS_LocalServer_Shutdown();
    }
    
    public static void main(String[] args) {
        launch();
    }
    
} 
