package ca.tecreations.apps.engine;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.net.*;

/**
 *
 * @author Tim 
 */ 
public class EngineTLS_LocalServer {
    public static final String WAN_IP = Internet.getWanIP(); 

    public static String propsPath = ProjectPath.getTecPropsPath() + 
                              "NetworkConfig" + File.separator +
                              "EngineTLS_local_client.properties";

    public static Properties serverProps = new Properties(propsPath);

    public static TLSServerWithTSPS server;
        
    boolean doneConnecting = false;
    boolean connected = false;

    public EngineTLS_LocalServer() {
        server = new TLSServerWithTSPS(serverProps,null);
        server.start();
    }
    
    public EngineTLS_LocalServer(Properties serverProps,int serverPort) {
        this.serverProps = serverProps;
        server = new TLSServerWithTSPS(serverProps,null);
        server.setPort(serverPort);
        server.start();
    }
      
    public static TLSServerWithTSPS getServer() { return server; }
    
    public boolean isConnected() { return connected; }
    
    public boolean doneConnecting() { return doneConnecting; }
    
    public static void main(String[] args) {
        new EngineTLS_LocalServer();
        
    }
} 
