package ca.tecreations.apps.engine;

import ca.tecreations.*;
import ca.tecreations.net.*;

/**
 *
 * @author Tim
 */ 
public class EngineTLS {
    public static boolean debug = false;
    public static boolean attemptBackup = false;
    public static String homeIp = "162.248.156.38";
    public static String tecIp = "134.122.41.0";
    
    public static String propsPath = ProjectPath.getTecPropsPath() + "NetworkConfig" + File.separator;
    
    public static Properties serverProps = new Properties(propsPath + "EngineTLS_tecreations.ca_server.properties");
    TLSServerWithTSPS server;
    int port;
    
    public static Properties clientProps = new Properties(propsPath + "EngineTLS_tecreations.ca_client.properties");
    TLSClient_TVS12 backupClient = null;
    
    boolean doneConnecting = false;
    
    public EngineTLS() { 
        server = new TLSServerWithTSPS(serverProps,null); 
        server.start();
        TecData.tsps = server.getTSPS();
        if (attemptBackup) {
            System.out.println("Attempting to connect to home lan...");
            System.out.println("Trying OFFICE...");
            backupClient = getHomeClient(homeIp,61024);
            if (backupClient == null | 
                (backupClient != null && !backupClient.isConnected())
            ) {
                System.out.println("Couldn't connect to OFFICE...");
                System.out.println("Trying LIVING ROOM...");
                backupClient = getHomeClient(homeIp,61025);
                if (backupClient == null | 
                    (backupClient != null && !backupClient.isConnected())
                ) {
                    System.err.println("Couldn't connect to LIVING ROOM.");
                }
            }
        }
        doneConnecting = true;
        // log( daysSinceLastBackup );
    }

    public boolean doneConnecting() { return doneConnecting; }
    
    public TLSClient_TVS12 getBackupClient() { return backupClient; }
    
    public TLSClient_TVS12 getHomeClient(String hostname, int port) {
        TLSClient_TVS12 client = null;
        Properties properties = new Properties(propsPath + homeIp + "_client.properties");
        try {
            client = new TLSClient_TVS12(properties,null,debug);
            if (client.isConnected()) {
                System.out.println(EngineTLS.class.getSimpleName() + ".getHomeClient: Connected: " + client.getHostName() + " : " + client.getStatus());
            }
        } catch (NoTLSConnectionException e) {
            System.err.println(EngineTLS.class.getSimpleName() + ".getHomeClient: no TLS connection: " + e.getPropertiesFilename());
        }
        return client;
    }
    
    public TLSClient_TVS12 getTecClient() {
        TLSClient_TVS12 client = null;
        try {
            client = new TLSClient_TVS12(clientProps,null,debug);
            if (client.isConnected()) {
                System.out.println(EngineTLS.class.getSimpleName() + ".getTecClient: Connected: " + client.getHostName() + " : " + client.getStatus());
            }
        } catch (NoTLSConnectionException e) {
            System.err.println(EngineTLS.class.getSimpleName() + ".getTecClient: no TLS connection: " + e);
        }
        return client;
    }
    
    public boolean isBackupConnected() {
        return backupClient != null && backupClient.isConnected();
    }
} 
