//X[Mq5_r6D_na=cW8
package ca.tecreations.apps.engine;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TypeToType;
import ca.tecreations.components.ProgressDialog;
import ca.tecreations.db.mysql.MySQL; 
import ca.tecreations.misc.Time;
import ca.tecreations.net.TLSClient_TVS12;

import java.awt.event.*;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class Engine implements ActionListener, Runnable {
    public static Engine instance = new Engine();
    public static boolean debug = true;
    public static final String CREATE_ENGINE_TABLE = 
            "CREATE TABLE engine (" +
                "eid INT(11) AUTO_INCREMENT NOT NULL PRIMARY KEY," + 
                "entry VARCHAR(255) NOT NULL," + 
                "params VARCHAR(32768) NOT NULL DEFAULT ''," + 
                "added VARCHAR(36) NOT NULL," + 
                "started VARCHAR(36) NOT NULL DEFAULT ''," + 
                "status VARCHAR(64) NOT NULL DEFAULT ''," + 
                "pid INT(10) NOT NULL DEFAULT '-1'" +
            ")";
    public static final String DROP_ENGINE_TABLE = "DROP TABLE engine";
    
    public static Properties properties = new Properties(ProjectPath.getTecPropsPath() + "Engine.properties");

    private static char[] pass = properties.get("mysql_pass").toCharArray();
    private static MySQL mysql = new MySQL("tecreations.ca",3306,"sitesec_dev","sitesec_user",pass);

    int seconds;
     
    public boolean running = false;
    
    public static final int EID = 0;
    public static final int ENTRY = 1;
    public static final int ADDED = 2;
    public static final int STARTED = 3;
    public static final int STATUS = 4;
    public static final int PID = 5;
    
    public static final String DONE = "DONE";
    public static final String FREEZE = "FREEZE";
    public static final String NOT_STARTED = "NOT_STARTED";
    public static final String PROCESSING = "PROCESSING";
    public static final String UNSTARTED = "UNSTARTED";
    
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String RESET = "RESET";
    public static final String RESET_SANS_SCRIPTURES = "RESET_SANS_SCRIPTURES";
    public static final String USER_INITIATED_SNAPSHOT = "USER_INITIATED_SNAPSHOT";
    public static final String USER_INITIATED_SNAPSHOT_COUNTRY = "USER_INITIATED_SNAPSHOT_COUNTRY";
    public static final String WEB_SNAPSHOT = "WEB_SNAPSHOT";
    
    public static int runIndex = 0;
    
//    public Timer engineRunTimer;
    public static boolean runTest = false;
    
    public Timer testTimer;
    public Timer siteResetTimer;
    public Timer midnightResetTimer;
    
    public static final EngineTLS tls = new EngineTLS();
    
    public Engine() {}
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == testTimer) {
            testTimer.stop();
            testTimer = null;
            doTest();
        } else if (e.getSource() == midnightResetTimer) {
            
        } else if (e.getSource() == siteResetTimer) {
            siteResetTimer = null;
            doReset();
            Platform.sleep(5000);
            int secsToEpoch;
            Time time = new Time();
            if (time.getHours() < 12) {
                secsToEpoch = Time.getSecondsToNoon();
            } else {
                secsToEpoch = Time.getSecondsToMidnight();
            }
            siteResetTimer = new Timer(secsToEpoch * 1000,this);
            //siteResetTimer = new Timer((Time.getSecondsToNextMinute() - 1) * 1000,this);
            siteResetTimer.start();
            midnightResetTimer = new Timer(((secsToEpoch * 1000) + 1000),this);
            midnightResetTimer.start();
        } else {
            if (e.getSource() == midnightResetTimer) {
                this.doReset();
            } 
        }
        
    }  
    
    public void clear() {
        mysql.issue("DELETE FROM engine");
    }
    
    public void clearAllProcessing() {
        mysql.issue("UPDATE engine SET status='' WHERE status='" + PROCESSING + "'");
    }

    public void clearAllStartedTimes() {
        mysql.issue("UPDATE engine SET started='' WHERE NOT started=''");
    }

    public void createTable() {
        mysql.issue(CREATE_ENGINE_TABLE);
    }
    
    public void deleteDone() {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        mysql.issue("DELETE FROM engine WHERE status='" + DONE + "'");
        mysql.debug = oldDebug;
    }
    
    public void deleteShutdown() {
        mysql.issue("DELETE FROM engine WHERE entry='" + SHUTDOWN + "'");
    }
      
    public void doReset() {
        log();
        log();
        new WebSnapshot(TecData.tsps,WebSnapshot.RESET);
        log();
        log(); 
    } 
       
    public void doResetSansScriptures() {
        log();
        log();
        new WebSnapshot(TecData.tsps,WebSnapshot.RESET_SANS_SCRIPTURES);
        log(); 
        log(); 
    } 
      
    public void doTest() {
        log();
        log();
        log("Ran Test at: " + Time.getTimsTime());
        //setWebSnapshotAddedTime();
        String t1 = Time.getTimsTime();
        String t2 = getWebSnapshot_ADDED();
        String timsTimeDiff = Time.getTimsTimeDiff(t1,t2);
        log();
        log("TimsTimeDiff:(local,WEB_SNAPSHOT): " + timsTimeDiff);
        log();
        log();
        freeze("F:\\security\\private");
        freeze("D:\\home\\tim\\security\\private");
        freeze("/home/tim/security/private");
    }
     
    public void doUserInitiatedSnapshot() {
        log();
        log();
        new WebSnapshot(TecData.tsps,WebSnapshot.USER_INITIATED_SNAPSHOT);
        log();
        log();
    }
 
    public void dropTable() {
        mysql.issue(DROP_ENGINE_TABLE);
    }
    
    public void freeze(String path) {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        mysql.issue("INSERT INTO engine (entry,params,added,status) VALUES('" + FREEZE + "','" + StringTool.replaceAll(path,"\\","\\\\") + "','" + Time.getTimsTime() + "','" + NOT_STARTED + "')");
        mysql.debug = oldDebug;
        log();
        log();
        log("Freeze: " + path);
        log();
        log();
    }
    
    public synchronized List<String> getEntry(int eid) {
        boolean oldDebug = mysql.debug;
        mysql.debug = oldDebug;
        List<List<String>> rows = mysql.getRows("SELECT * FROM engine WHERE eid='" + eid + "'", false);
        mysql.debug = oldDebug;
        if (rows.size() == 1) {
            return rows.get(0);
        }
        return null;
    }
    
    public static MySQL getMysql() { return mysql; }
    public static MySQL getMySQL() { return mysql; }
    
    public synchronized int getNextUnstarted() {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        List<List<String>> rows = mysql.getRows("SELECT * FROM engine WHERE started='' OR status='" + UNSTARTED + "' LIMIT 1", true);
        mysql.debug = oldDebug;
        List<String> rowItems;
        for(int i = 0; i < rows.size();i++) {
            rowItems = rows.get(i);
            log(TypeToType.toString(rowItems));
        }
        log("getNextUnstarted: sleeping: 2000");
        Platform.sleep(2000);
        if (rows.size() > 1) {
            return Integer.parseInt(rows.get(1).get(0));
        }
        return -1;
    }
    
    public String getTecSec_Nix() {
        return "/home/tim/security/";
    }
    
    public String getTecSec_Win() {
        return "D:\\home\\tim\\security\\";
    }
    
    public String getTecWebRoot_Nix() {
        return "/var/www/tecreations.ca/html/ca/tecreations/";
    }
    
    public String getTecWebRootSnapshots_Win() {
        return "D:\\website.snapshots\\"; // allow read access, format for tecreations
    }
    
    // eid, entry, params, added, started, status, pid
    
    public String getWebSnapshot_ADDED() {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        List<List<String>> rows = mysql.getRows("SELECT added FROM engine WHERE entry='" + WEB_SNAPSHOT + "'", false);
        mysql.debug = oldDebug;
        if (rows.size() > 0) {
            List<String> row = rows.get(0);
            return row.get(3);
        }
        return Time.getTimsTime();
    }
    
    public synchronized boolean hasUnstarted() {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        String entriesCount = mysql.getValue("SELECT COUNT(*) FROM engine WHERE started='' OR status='" + UNSTARTED + "'");
        mysql.debug = oldDebug;
        if (entriesCount != null && entriesCount.length() > 0) {
            int entries = Integer.parseInt(entriesCount);
            if (entries > 0) return true;
        }
        return false;
    } 
    
    public void insertUserSnapshot() {
       mysql.issue("INSERT INTO engine (entry,added,status) VALUES('" + USER_INITIATED_SNAPSHOT + "','" + Time.getTimsTime() + "','" + NOT_STARTED + "')");
    }
    
    public void insertWebSnapshot() {
       mysql.issue("INSERT INTO engine (entry,added,status) VALUES('" + WEB_SNAPSHOT + "','" + Time.getTimsTime() + "','" + NOT_STARTED + "')");
    }
    
    public void log() {
        if (TecData.tsps != null) TecData.tsps.send();
        System.out.println();
    }
    
    public void log(String s) {
        if (TecData.tsps != null) TecData.tsps.send(s);
        System.out.println(s);
    }
     
    public static void main(String[] args) {
        //int entriesCount = Integer.parseInt(mysql.getValue("SELECT COUNT(*) FROM engine"));
        //System.out.println("Entries: " + entriesCount);
        //Engine.dropTable();
        //Engine.createTable();
//        Engine.clearAllStarted();
        Engine engine = new Engine();
        engine.updateDBSchema(); 
        engine.runWith(3);
        Platform.sleep(15000);
        engine.report();
        Platform.sleep(15000);
        engine.report();
        Platform.sleep(15000);
        engine.report();
        
//        engine.clear();
        //mysql.issue("INSERT INTO engine (entry) VALUES ('upgrade: tec8')");
        //mysql.issue("INSERT INTO engine (entry) VALUES ('restart: ca.tecreations.apps.filetool.FileTool')");
        
        //162.248.156.3
        
        
        
        
//        engine.setEngineRunDuration(30);
//        engine.setTestTimer(3);
        //printEntries(mysql);
        //engine.start();
    }
    
    public synchronized void printEntries() {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        List<List<String>> rows = mysql.getRows("SELECT * FROM engine", true);
        List<String> rowItems;
        for(int i = 0; i < rows.size();i++) {
            rowItems = rows.get(i);
            log(TypeToType.toString(rowItems));
        }
        mysql.debug = oldDebug;
    }
    
    public void process(int eid) {
        List<String> entry = getEntry(eid);
        log();
        log(TypeToType.toString(entry));
        log();
        startOp(eid);
        if (entry != null) {
            if (entry.get(1).equals(FREEZE)) {
                log("run: process: FREEZE: " + entry.get(2));
            } else if (entry.get(1).equals(SHUTDOWN)) {
                shutdown();
            } else if (entry.get(1).equals(RESET)) {
                doReset();
                
                
                //Deprecate. List now by segment(am/pm) for appropriate day/time/locale/
                // country, Tim.
            //} else if (entry.get(1).equals(RESET_SANS_SCRIPTURES)) {
            //    doResetSansScriptures();
            } else if (entry.get(1).equals(USER_INITIATED_SNAPSHOT)) {
                doUserInitiatedSnapshot();
            } else if (entry.get(1).equals(WEB_SNAPSHOT)) {
                snapshotWeb();
            }
        }
    }
    
    public void report() {
        int count = mysql.countRows("SELECT COUNT(*) FROM engine");
        log("Count: rows: " + count);
    }
    
    
    public void resetAllProcessing() {
        mysql.issue("UPDATE engine SET status='" + UNSTARTED + "'");
    }
    
    public void run() {
        List<String> current;
        int runCount = 0;
        while (running) {
            while (hasUnstarted()) {
                log("run: hasUnstarted: processing...");
                int next = getNextUnstarted();
                if (running && next != -1) { 
                    process(next);
                } 
            }   
            ++runCount;
            Time time = new Time();
            int secsToEpoch;
            if (time.getHours() > 11) {
                secsToEpoch = time.getSecondsToMidnight();
            } else {
                secsToEpoch = time.getSecondsToNoon();
            }
            String ttr = Time.getFormatted24FromSeconds(secsToEpoch);
            log("run(" + (runIndex++) + "): Nothing to do: Sleeping: " + (seconds) + " duration: " + Time.getDurationHMS((seconds * runCount),":") + " TTR: " + ttr);
            
            if (running && runCount == 1) {
                if (tls.doneConnecting() && tls.getBackupClient() != null) {
                    snapshotWeb();
                }
            }
            
            if (running) Platform.sleep(seconds * 1000);
            deleteDone();
        }
    }
     
    public void runWith(int seconds) {
        this.seconds = seconds;
        int secsToEpoch;
        Time time = new Time();
        if (time.getHours() > 11) {
            secsToEpoch = Time.getSecondsToMidnight();
        } else {
            secsToEpoch = Time.getSecondsToNoon();
        }
        siteResetTimer = new Timer(secsToEpoch * 1000,this);
        siteResetTimer.start();
        System.out.println("Time To Site Reset: " + Time.getFormatted24FromSeconds(secsToEpoch));
        if (runTest) {
            testTimer = new Timer(15 * 1000,this);
            testTimer.start();
            System.out.println("Running test in 15 seconds ...");
        }
        start();
    }   
     
    public void setWebSnapshotAddedTime() {
        mysql.issue("UPDATE engine SET added='" + Time.getTimsTime() + "' WHERE entry='" + WEB_SNAPSHOT + "'");
    }
    
    public void setTestTimer(int seconds) {
        testTimer = new Timer(1000 * seconds,this);
        testTimer.start();
    }
    
    public void snapshotWeb() { 
        if (tls.doneConnecting()) {
            if (tls.isBackupConnected()) {
                String tecSecRoot = "/var/www/tecreations.ca/";
                String now = Time.getTodaysShortDateTimeForDirName();
                String outPath = "D:\\website.snapshots\\tecreations.ca\\" + now + "\\";
                log();
                log();
                log("Snapshot: Web: Today: To: " + now);
                TLSClient_TVS12 backupClient = tls.getBackupClient();
                TLSClient_TVS12 tecClient = tls.getTecClient();
                
                String dstSep = backupClient.getFileSeparator();
                boolean debug = true;
                
                ProgressDialog dialog = null;
                // engine should be headless, but if running local, you could....
                if (!Platform.isHeadless()) dialog = new ProgressDialog(null);
                // runit.
                List<String> entries = tecClient.getAll(tecSecRoot);
                for(int i = 0;i < entries.size();i++) {
                    String entry = entries.get(i);
                    String path = entry.substring(0,entry.indexOf(","));
                    String unwrappedPath = StringTool.getUnwrapped(path);
                    String subPath = unwrappedPath.substring(tecSecRoot.length());
                    String dstSubPath = StringTool.replaceAll(subPath,tecClient.getFileSeparator(),backupClient.getFileSeparator());
                    String wrappedDst = StringTool.getDoubleQuoted(outPath+dstSubPath);
                    if (subPath.endsWith(tecClient.getFileSeparator())) {
                        // tecreations web-root
                        if (!unwrappedPath.toLowerCase().contains("snapshots")) {
                            log("putDirectory: " + path + " " + wrappedDst);
                            TLSClient_TVS12.putDirectory(tecClient, path, backupClient,wrappedDst,debug);
                        } 
                    } else {
                        log("putFile: " + path + " : " + wrappedDst);
                        backupClient.debug = debug;
                        backupClient.putFile(path,wrappedDst);
                    } 
                }
            } else {
                log("Not connected to: BACKUP_SERVER.\nSkipping backup.\n\n");
            }
        }
    } 
    
    public void start() {
        running = true;
        run();
    }
    
    public void startOp(int eid) {
        boolean oldDebug = mysql.debug;
        mysql.debug = false;
        mysql.issue("UPDATE engine SET started='" + Time.getTimsTime() + "' WHERE eid='" + eid + "'");
        mysql.issue("UPDATE engine SET status='" + PROCESSING + "' WHERE eid='" + eid + "'");
        mysql.debug = oldDebug;
    }

    public void shutdown() {
        deleteShutdown();
        log("\nShutting down.");
        if (testTimer != null && testTimer.isRunning()) testTimer.stop();
        if (siteResetTimer !=null && siteResetTimer.isRunning()) siteResetTimer.stop();
        running = false;
        System.exit(0);
    }
    
    public final void updateDBSchema() {
        mysql.issue(DROP_ENGINE_TABLE);
        mysql.issue(CREATE_ENGINE_TABLE);
    }
    

}
