package ca.tecreations.apps.engine;

import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.TecData;
import ca.tecreations.TypeToType;
import ca.tecreations.apps.deploy.Deploy;
import ca.tecreations.net.Internet;
import ca.tecreations.net.NameService;
/**
 *
 * @author Tim
 */
public class DeployEngine {
 
    public static void main(String[] args) {
        Deploy deploy = Deploy.launch(ProjectPath.instance);
        String enginePath = ProjectPath.getTecPropsPath() + "Engine.properties";
        deploy.setPropertiesPath(enginePath);
         
        deploy.setMakeSecure(false);
        
        String prjsHome = ProjectPath.getProjectsHome();
        if (prjsHome == null) {
            System.err.println("ProjectsHome is not set... Validator...");
        } else {
            String prjPath = ProjectPath.getProjectsHome() + TecData.TEC_VERSION + File.separator;
            deploy.construct(prjPath);
        }
        deploy.setIncludeSources(true);
        deploy.setIncludeClasses(true);
        deploy.setIncludeJars(false);
        deploy.setFilenamePrefix("Engine");
        deploy.setAppendDate(false);
        deploy.setAppendTime(false);
        deploy.setMainClass("None");
        deploy.setRemoteActive(true);
        deploy.setRemoteHost("tecreations.ca");
        deploy.setRemotePort("52820");
        deploy.setRemoteKeyStorePass("storepass".toCharArray());
        String lanIP = Internet.getLanIP();
        System.out.println("Lan IP: " + lanIP);
        if (NameService.instance.getByName("Living Room").equals(lanIP)) {
            deploy.setRemoteKeyStore("D:\\security\\client_keystore");
            deploy.setRemoteTrustStore("D:\\security\\client_truststore");
        } else if (NameService.instance.getByName("Office").equals(lanIP)) {
            deploy.setRemoteKeyStore("F:\\security\\client_keystore");
            deploy.setRemoteTrustStore("F:\\security\\client_truststore");
        } else {
            System.out.println("Using lanIP: " + lanIP + " livingRoom: " + NameService.getInstance().getByName("Living Room"));
            
            System.exit(0);
            deploy.setRemoteKeyStore("DeployEngine.main: Invalid keystore");
            deploy.setRemoteTrustStore("DeployEngine.main: Invalid truststore");
        }
        deploy.setRemoteServerPath("/home/tim/");
        deploy.setProperties();
        boolean commit = true;
        if (commit) {
            deploy.commitRemote();
            System.exit(0);
        }
    }
    
}
