package ca.tecreations.apps.editors;

import ca.tecreations.Color;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.TextFile;
import ca.tecreations.TextToken;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TextStatus;
import ca.tecreations.components.TFrame;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.text.LineOfTextTokenPainter;
import ca.tecreations.text.TextTokenPainter;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;

/**
 *
 * @author tim
 */
public class TextEdit extends TFrame implements ActionListener, AdjustmentListener,
        MouseListener, 
        MouseMotionListener, ProgressListener, Runnable {
    JPanel sizer = new JPanel();
    Color PAINTER_COLOR = Color.TEC_LIGHT_GREEN;
    
    static TextEdit instance;
    LineLocator lineLocator;
    LineNumbers lineNumbers;
    JScrollPane scroller;
    TextEditPanel panel;
    TextStatus status = new TextStatus();
    boolean dragged = false;
    boolean firstRun = true;

    public JScrollBar hsb;
    public JScrollBar vsb;
    
    public TextEdit() {
        super(ProjectPath.getTecPropsPath() + TextEdit.class.getSimpleName() + ".properties", TextEdit.class.getSimpleName());
        setVisible(true);
        panel = new TextEditPanel(this);
        lineNumbers = new LineNumbers(panel);
        lineLocator = new LineLocator(panel);
        panel = new TextEditPanel(this);
        setupGUI();
        hsb.addAdjustmentListener(this);
        vsb.addAdjustmentListener(this);
        setExitOnClose(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == status) {
            System.out.println("Command: " + status.getCommand());
        }
    }
    
    public void add(String s) {
        LineOfTextTokenPainter painter = new LineOfTextTokenPainter(panel.getPoints());
        TextTokenPainter ttp = new TextTokenPainter(TextEditPanel.points,new TextToken(s),PAINTER_COLOR);
        painter.addPainter(ttp);
        panel.addLine(painter);
    }

    public void addItem(String s) {
        add(s);
    }

    public void addJob(String s) {
        add(s);
    }

    public void adjustScroller() {
        scroller.setSize(sizer.getSize().width - (lineNumbers.getSize().width + lineLocator.getSize().width),scroller.getSize().height);
        scroller.setLocation(lineNumbers.getSize().width,0);
        revalidate();
    }
    
    public void adjustmentValueChanged(AdjustmentEvent ae) {
        repaint();
    }
    
    public void componentResized(ComponentEvent e) {
    }
    
    public void computeScrollerValues() {
        double hPercent;
        double hVisible;
        double hOnePercent;
        double hScrollerOnePercent;
        
        double vPercent;
        double vVisible;
        double vOnePercent;
        double vScrollerOnePercent;
        
        vOnePercent = (double) panel.getSize().height / (double) 100;
        vScrollerOnePercent = (double) vsb.getSize().height / (double) 100;
        vVisible = (double) vsb.getSize().height / vOnePercent;

        hOnePercent = (double) panel.getSize().width / (double) 100;
        hScrollerOnePercent = (double) hsb.getSize().width / (double) 100;
        hVisible = (double) hsb.getSize().width / vOnePercent;

        if (hVisible > 100.0) hVisible = 100.0;
        if (vVisible > 100.0) vVisible = 100.0;
        
        System.out.println("hVisible: " + hVisible + " vVisible: " + vVisible);                    
        hsb.setValues(hsb.getValue(),(int)hVisible,0,100 - (int)hVisible);
        vsb.setValues(vsb.getValue(),(int)vVisible,0,100 - (int)vVisible);
    }
    
    public static void createAndShowGUI() {
        instance = new TextEdit();
    }

    public void doLogAction(String s) {
        add(s);
        System.out.println(s);
    }

    public void doTest() {
        panel.doTest();
    }
    
    public LineLocator getLineLocator() { return lineLocator; }
    
    public LineNumbers getLineNumbers() { return lineNumbers; }
    
    public TextEditPanel getPanel() { return panel; }
    
    public JScrollPane getScroller() {
        return scroller;
    }
    
    public TextStatus getStatus() { return status; }
    
    public void goEnd() {
        int x;
        if (panel.getCursorX() < hsb.getSize().width) x = 0;
        else {
            x = -(panel.getCursorX() - (hsb.getSize().width / 2));
        }
        int y = Math.min(-(panel.getSize().height - vsb.getSize().height),0);
        panel.setLocation(x,y);
        scroller.revalidate();
    }
    
    public void goHome() {
        panel.setLocation(0,0);
        scroller.revalidate();
    }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
        while (instance == null) {
            Platform.sleep(250);
        }
        while (!instance.isVisible()) {
            Platform.sleep(500);
        }
        instance.open(ProjectPath.getProjectPath() + "ca\\tecreations\\apps\\editors\\TextEdit.java");
    }

    public static void main(String[] args) {
        //new File(ProjectPath.getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar").delete(true);
        //new File(ProjectPath.getTecreationsPath() + "images" + File.separator + "tec_brand.png").delete(true);
        launch();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == panel) {
            panel.requestFocus();
        } else if (e.getSource() == status.getCommand()) {
            status.getCommand().requestFocus();
        }
    }

    public void mouseReleased(MouseEvent e) {
        computeScrollerValues();
    }

    public void open(String path) {
        if (!new File(path).exists()) {
            System.err.println("Path does not exist: " + path);
            return;
        }
        TextFile file = new TextFile(path);
        List<String> lines = file.getLines();
        panel.setLines(new ArrayList<LineOfTextTokenPainter>());
        for(int i = 0; i < lines.size();i++) {
            //System.out.println("Lines[" + (i+1) + "]: " + lines.get(i));
            tokenizeAndAdd(lines.get(i));
        }
        panel.conformPanelSize();
        //panel.goTo(1,0);
        tec_redoLayout();
        computeScrollerValues();
        repaint();
    }
    
    @Override
    public void paint(Graphics g) {
        if (firstRun) {
            hsb = scroller.getHorizontalScrollBar();
            vsb = scroller.getVerticalScrollBar();
            panel.setSize(hsb.getSize().width,vsb.getSize().height);
            panel.hsbWidth = hsb.getSize().width;
            panel.vsbHeight = vsb.getSize().height;
            firstRun = false;
        }
        super.paint(g);
    }

    public void run() {
    }

    public void setItem(String s) {
        add(s);
    }

    public void setJob(String s) {
        add(s);
    }
    
    public void setupGUI() {
        setLayout(new BorderLayout());
        add(sizer,BorderLayout.CENTER);
        validate();
        java.awt.Dimension content = sizer.getSize();
        scroller = new JScrollPane(panel, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        hsb = scroller.getHorizontalScrollBar();
        vsb = scroller.getVerticalScrollBar();
        hsb.setUnitIncrement(5 * TextEditPanel.points.getFontSize());
        vsb.setUnitIncrement(5 * TextEditPanel.points.getFontSize());
        panel.setScroller(scroller);

        lineNumbers = new LineNumbers(panel);
        lineLocator = new LineLocator(panel);
        
        SizedPanel holder = new SizedPanel(content.getSize().width,content.height - status.getSize().height);
        holder.setLayout(new BorderLayout());
        holder.add(lineNumbers,BorderLayout.WEST);
        lineNumbers.setSize(32, holder.getSize().height);
        holder.add(scroller,BorderLayout.CENTER);
        int widthSub = lineNumbers.getSize().width + lineLocator.getSize().width;
        int scrollWidth = content.width - widthSub;
        scroller.setSize(scrollWidth,content.height);
        scroller.setLocation(lineNumbers.getSize().width,0);
        holder.add(lineLocator,BorderLayout.EAST);
        lineLocator.setSize(lineLocator.getSize().width,content.height);
        lineLocator.setLocation(scroller.getLocation().x + scroller.getSize().width,0);
        sizer.setLayout(new BorderLayout());
        sizer.add(holder,BorderLayout.CENTER);
        sizer.add(status,BorderLayout.SOUTH);
        status.getCommand().addActionListener(this);
        status.getCommand().addMouseListener(this);
        validate();
        panel.addMouseListener(this);
        panel.addMouseMotionListener(this);
        addComponentListener(this);
    }

    public void start() {
        run();
    }

    public void setLastLine(String s) {
        LineOfTextTokenPainter painter = new LineOfTextTokenPainter(panel.getPoints());
        painter.addPainter(new TextTokenPainter(TextEditPanel.points,new 
                                            TextToken(s),Color.yellow));
        panel.setLastLine(painter);
    }
    
    public void tec_redoLayout() {
        int scrollWidth = sizer.getSize().width - (lineNumbers.getSize().width + lineLocator.getSize().width);
        int scrollHeight = scroller.getSize().height;
        scroller.setSize(scrollWidth,scrollHeight);
        scroller.setLocation(lineNumbers.getSize().width,0);
    }
    
    public void tokenizeAndAdd(String s) {
        LineOfTextTokenPainter painter = new LineOfTextTokenPainter(panel.getPoints());
        TextToken token = new TextToken();
        for(int i = 0;i < s.length();i++) {
            if (s.charAt(i) == ' ') {
                if (token.length() > 0) {
                    painter.addPainter(new TextTokenPainter(TextEditPanel.points,token,panel.getForeground()));
                    token = new TextToken();
                }
                painter.addPainter(new TextTokenPainter(TextEditPanel.points, new TextToken(" "),panel.getForeground()));
            } else {
                token.add(s.charAt(i));
            }
        }
        if (token.length() > 0) {
            painter.addPainter(new TextTokenPainter(TextEditPanel.points,token,panel.getForeground()));
        }
        painter.setBackground(panel.getBackground());
        panel.addLine(painter);
    }
    
    public void update(int job, int item) {
        setLastLine("Downloaded: " + job + "% -- " + item + "%");
    }

    public void updateItem(int item) {
        setLastLine("Downloaded: " + item + "%");
    }

    public void updateJob(int job) {
        setLastLine("Downloaded: " + job + "%");
    }

}
