package ca.tecreations.apps.editors;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.misc.Time;


/**
 *
 * @author Tim
 */
public class MinuteTimer {
    int count;
    int elapsed = 0;
    int seconds = 60; 
    
    public MinuteTimer(int count) {
        this.count = count;
        System.out.println("Started at: " + Time.longToHMS(System.currentTimeMillis()));
        boolean isNetBeans = ProjectPath.getRuntimePath(MinuteTimer.class.getProtectionDomain()).contains("NetBeans");
        if (isNetBeans) {
            System.out.println("Elapsed: " + elapsed + " mins -- Remaining: " + count + ":00");
        } else {
            System.out.print("\rElapsed: " + elapsed + " mins -- Remaining: " + count + ":00");
        }
        seconds = 55;
        Platform.sleep(5 * 1000);
        String msg;
        for(int i = 0; i < count * 12 - 1;i++) {
                if (seconds == 60) {
                    msg = "Elapsed: " + elapsed + " mins -- Remaining: " + (count - elapsed) + ":00";
                } else if (seconds == 5) {
                    msg = "Elapsed: " + elapsed + " mins -- Remaining: " + (count - elapsed - 1) + ":05";
                } else {
                    msg = "Elapsed: " + elapsed + " mins -- Remaining: " + (count - elapsed - 1) + ":" + seconds;
                }
            if (isNetBeans) {
                System.out.println(msg);
            } else {
                System.out.print("\r" + msg);
            }
            seconds -= 5;
            if (seconds == 00) {
                seconds = 60;
                elapsed++;
            }
            Platform.sleep(5 * 1000);
        } 
        if (isNetBeans) {
            System.out.println("Elapsed: " + count + " mins -- Remaining: 0:00");
        } else {
            System.out.print("\rElapsed: " + count + " mins -- Remaining: 0:00");
        }
        System.out.println("\nSounding Alarm");
        soundAlarm();
    }
    
    public static void main(String[] args) {
        new MinuteTimer(45);
    }
    
    public void soundAlarm() {
        // do it
        Platform.message(null,"The " + count + " minute alarm has gone off.");
    }
}
