package ca.tecreations.apps.editors;

import ca.tecreations.Color;
import ca.tecreations.TextToken;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.TextTokenPainter;

import java.awt.Graphics;

/**
 *
 * @author Tim
 */
public class LineNumbers extends SizedPanel {
    static TextEditPanel panel;
    static TextPoints lnPoints;
    
    public static int INITIAL_NUMS_POINTS_SIZE;
    static TextTokenPainter numsPainter;
    
    public LineNumbers(TextEditPanel panel) {
        super(10,1);
        this.panel = panel;
        lnPoints = panel.getPoints().getPlain();
        lnPoints.setMonospaced(true);
        INITIAL_NUMS_POINTS_SIZE = lnPoints.getFontSize();
        numsPainter = new TextTokenPainter(lnPoints,new TextToken(),Color.black);
        numsPainter.setBackground(Color.DEFAULT_SWING_BG);
    }
    
    public void fontSizeDown() {
        TextPoints points = panel.getPoints();
        //System.out.println("LineNumbers.fontSizeDown: points: " + points.getSize());
        int newSize = points.getSize();
        if (newSize <= INITIAL_NUMS_POINTS_SIZE) {
            lnPoints = lnPoints.getSized(newSize);
            numsPainter.setPoints(lnPoints);
            //System.out.println("LineNumbers.fontSizeDown: numsPainter.points: " + numsPainter.getPoints().getSize());
        } else {
            lnPoints = lnPoints.getSized(INITIAL_NUMS_POINTS_SIZE);
            numsPainter.setPoints(lnPoints);
        }
        repaint();
    }
    
    public void fontSizeUp() {
        int newSize = panel.getPoints().getSize();
        //System.out.println("LineNumbers.fontSizeUp: newSize: " + newSize);
        if (newSize >= INITIAL_NUMS_POINTS_SIZE) {
            lnPoints = lnPoints.getSized(INITIAL_NUMS_POINTS_SIZE);
            numsPainter.setPoints(lnPoints);
        } else {
            lnPoints = lnPoints.getSized(newSize);
            numsPainter.setPoints(lnPoints);
        }
        repaint();
    }
    
    public int getLength(int i) {
        if (i < 10) return 1;
        if (i < 100) return 2;
        if (i < 1000) return 3;
        if (i < 10000) return 4;
        if (i < 100000) return 5;
        if (i < 1000000) return 6;
        if (i < 10000000) return 7;
        if (i < 100000000) return 8;
        if (i < 1000000000) return 9;
        return 10;
    }
    
    public int getLineNumberLength(int num) {
        if (num < 10) return 1;
        if (num < 100) return 2;
        if (num < 1000) return 3;
        if (num < 10000) return 4;
        if (num < 100000) return 5;
        if (num < 1000000) return 6;
        if (num < 10000000) return 7;
        if (num < 100000000) return 8;
        if (num < 1000000000) return 9;
        return 10;
    }

    public int getNumsWidth() {
        int width = 0;
        for(int i = 0; i < panel.getLinesSize();i++) {
            numsPainter.setText("" + (i + 1));
            width = Math.max(width, numsPainter.getTextWidth());
        }
        return width + 10;

    }

    public TextToken getPaddedToken(int i) {
        String text = getPadding(getLineNumberLength(i + 1) - getLength(i)) + (i + 1) + ": ";
        return new TextToken(text);
    }
    
    public String getPadding(int count) {
        String s = "";
        for(int i = 0; i < count;i++) s += ' ';
        return s;
    }
    
    public static void main(String[] args) {
        TextEdit.launch();
    }
    
    public void paint(Graphics g) {
        doPainting(g,panel.getYOffset(),panel.getLineHeight());
    }
    
    public void doPainting(Graphics g, int yOffset, int lineHeight) {
        g.setColor(numsPainter.getBackground());
        g.fillRect(0,0,getSize().width,getSize().height);
        int linesSize = panel.getLinesSize();
        TextPoints points = panel.getPoints();
        int absY = Math.abs(panel.getLocation().y);
        int minY = absY - lineHeight;
        int maxY = absY + panel.getVerticalScrollBar().getSize().height + (points.getFontSize() * 2);
        double numsPad = (((double)points.getFontSize() + (double)points.getMaxDescent() - (double)lnPoints.getFontSize()) / 2.0);
        int lineY = 0;
        int lineIndex = 0;
        if (minY == -lineHeight) minY = 0;
        
        int y = 0; // determine the starting Y for the line numbers
        for(int i = 0; i < linesSize; i++) {
            if (y >= minY && y <= maxY) {
                lineY = absY - y;
                i = linesSize;
            }
            y += lineHeight;
        }
        //System.out.println("lineY: " + lineY + " minY: " + minY + " y: " + y);
        if (lineY > 0) lineY -= lineHeight;
        lineY += 1;
        y = 0;
        for(int i = 0; i < linesSize;i++) {
            numsPainter.setText("" + (i + 1));
            if (y >= minY && y <= maxY) {
                int textWidth = numsPainter.getTextWidth();
                int lineX = ((getSize().width - textWidth) / 2);
                numsPainter.paintAt(g,lineX,lineY);
                //Color oldColor = new Color(g.getColor());
                //g.setColor(Color.green);
                //g.drawLine(0,lineY,getSize().width,lineY);
                lineY += lineHeight;
                //g.setColor(Color.red);
                //g.drawLine(0,lineY - 1,getSize().width,lineY - 1);
                //g.setColor(oldColor);
            }
            y += lineHeight;
        }
    }
}
