package ca.tecreations.apps.editors;

import ca.tecreations.Color;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import static ca.tecreations.apps.editors.TextEditPanel.points;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.text.LineOfTextTokenPainter;
import ca.tecreations.text.TextTokenPainter;

import java.awt.Graphics;
import java.awt.event.*;
import javax.swing.*;
/**
 *
 * @author Tim
 */
public class LineLocator extends SizedPanel implements KeyListener, 
        MouseListener, MouseMotionListener {
    TextEditPanel panel;
    boolean isCtrl = false;
    TextTokenPainter painter = new TextTokenPainter(TecData.CODE_POINTS,new TextToken(),Color.black);
    
    int pressNum = 0;
    

    public LineLocator(TextEditPanel panel) {
        super(14,1);
        this.panel = panel;
        addKeyListener(this);
        addMouseListener(this);
        addMouseMotionListener(this);
    }
    
    public void keyPressed(KeyEvent e) {
        isCtrl = e.isControlDown();
//        e.consume();
        pressNum++;
        if (pressNum == 1) repaint();
    }
    
    public void keyReleased(KeyEvent e) {
        isCtrl = e.isControlDown();
        e.consume();
        pressNum = 0;
        repaint();
    }

    public void keyTyped(KeyEvent e) {
        if (hasFocus()) e.consume();
    }
    
    
    public static void main(String[] args) {
        TextEdit.launch();
    }
    
    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            System.out.println("LineLocator: GotoSection");
        } else {
            System.out.println("LineLocator: GotoPercentage");
            JScrollBar vsb = panel.getTextEdit().vsb;
            double height = (double)getSize().height;
            double llOnePercent = height / (double)100;
            double percentage = (double)e.getY() / llOnePercent;
            if (percentage > 100) percentage = 100;
            double panelOnePercent = (double)panel.getSize().height / (double)100; 
            double visiblePercent = vsb.getVisibleAmount() / panelOnePercent;
            double value;
            if (percentage + visiblePercent >= 100) {
                value = 100 - visiblePercent;
            } else if (percentage < 5) value = 0;
            else value = percentage;
            System.out.println("h: " + height + " Percentage: " + percentage + " llOne: " + llOnePercent + " panelOne: " + panelOnePercent + " visPercent: " + visiblePercent + " Value: " + value);
            panel.selectLineWithY((int)(value * panelOnePercent));
        }
        e.consume();
        isCtrl = e.isControlDown();
        repaint();
    }
    
    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        requestFocus();
        isCtrl = e.isControlDown();
        e.consume();
        repaint();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void paint(Graphics g) {
        if (getSize().height > panel.getScroller().getVerticalScrollBar().getSize().height) {
            setSize(getSize().width,panel.getScroller().getVerticalScrollBar().getSize().height);
        }
        painter.setPoints(painter.getPoints().getSized((getSize().height / 29) - 1));
        g.setColor(Color.SWING_DEFAULT_BG);
        g.fillRect(0,0,getSize().width,getSize().height - 1);
        int height = getSize().height;
        int padding = (int)Math.floor((double)height - ((double)painter.getFontSize() * (double)29));
        if (isCtrl) {
            char ch;
            int x;
            int w = getSize().width;
            int paddingY = 0;
            double one29Th = ((double)padding / (double)26);
            int y = 0;
            painter.setText('i');
            x = (w - painter.getTextWidth()) / 2;
            y = (int)Math.floor(one29Th);
            painter.paintAt(g,x,y);
            
            painter.setText('D');
            x = (w - painter.getTextWidth()) / 2;
            paddingY = (int)Math.floor(one29Th);
            y = (painter.getFontSize()) + paddingY;
            painter.paintAt(g,x,y);
            
            painter.setText("()");
            x = (w - painter.getTextWidth()) / 2;
            paddingY = (int)Math.floor(one29Th * (double)(2));
            y = (2 * painter.getFontSize()) + paddingY;
            painter.paintAt(g,x,y);
            for(int i = 0; i < 26;i++) {
                ch = (char)('A' + i);
                painter.setText(ch);
                x = (w - painter.getTextWidth()) / 2;
                paddingY = (int)Math.floor(one29Th * (double)(i+3));
                y = (3 * (painter.getFontSize() - 1)) + (i * painter.getFontSize()) + paddingY;
                painter.paintAt(g,x,y);
            }
        } else {
            
        }
    }
    
}
