package ca.tecreations.apps.draw;

import ca.tecreations.Color;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class StringProcessor {
    String src;
    int index = 0;
    String remainder;
    public String last = null;
    
    public StringProcessor(String src) {
        this.src = src;
        remainder = src;
    }
    
    public int getIndex() { return index; }
    
    public String getLast() { return last; }
    
    public String getNextDoubleQuoted() {
        last = "";
        String newSrc = remainder;
        int firstIndex = newSrc.indexOf("\"");
        if (firstIndex == - 1) return null; // not found
        String newOut = remainder.substring(firstIndex,(remainder.indexOf("\"",firstIndex + 1) + 1));
        index += firstIndex + newOut.length();
        remainder = remainder.substring(firstIndex + newOut.length());
        last = newOut;
        return newOut;
    }

    public String getRemainder() { return remainder; }
    
    public String getSrc() { return src; }
    
    public static void main(String[] args) {
        StringProcessor sp = new StringProcessor("\"Color[255,102,102,102]\",\"Color[255,50,175,255]\"");
        System.out.println("getNextDoubleQuoted() : " + sp.getNextDoubleQuoted());
        System.out.println("index                 : " + sp.getIndex());
        System.out.println("Remainder             : " + sp.getRemainder());
        System.out.println("-------------------------------------------");
        System.out.println("Color?: " + Color.fromExternal(sp.last));
        System.out.println("-------------------------------------------");
        System.out.println("getNextDoubleQuoted() : " + sp.getNextDoubleQuoted());
        System.out.println("index                 : " + sp.getIndex());
        System.out.println("Remainder             : " + sp.getRemainder());
        System.out.println("-------------------------------------------");
        System.out.println("Color?: " + Color.fromExternal(sp.last));
        System.out.println("-------------------------------------------");
        System.out.println("getNextDoubleQuoted() : " + sp.getNextDoubleQuoted());
        System.out.println("index                 : " + sp.getIndex());
        System.out.println("Remainder             : " + sp.getRemainder());
        System.out.println("-------------------------------------------");
        System.out.println("Color?: " + Color.fromExternal(sp.last));
        System.out.println("-------------------------------------------");
    }
}
