package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.Font;
import ca.tecreations.TecData;
import ca.tecreations.UnicodeToken;
import ca.tecreations.components.Button;
import ca.tecreations.graphics.GraphicsUtil;
import ca.tecreations.text.TextPoints;

import java.awt.Graphics;
/**
 *
 * @author Tim
 */
public class ShowDefined extends Button {
    boolean centeredText = false;
    boolean expanded = true;

    static UnicodeToken tokenLeftArrowBar = new UnicodeToken("29D6");
    static UnicodeToken tokenRightArrowBar = new UnicodeToken("29D7");
    static UnicodeToken tokenBothTogether = new UnicodeToken("11D4");
    
    public ShowDefined() {
//        setImage(hideImage);
        super();
        TextPoints lgCode = TecData.LG_CODE_POINTS;
        
        setBackground(Color.TEC_LIGHT_GREEN);
        
    }
    
    public void doPainting(Graphics g) {
        GraphicsUtil.fill(g,getBackground(),this);
        int x = ((getSize().width - textPainter.getTextWidth()) / 2);
        int y = ((getSize().height - textPainter.getFontSize()) / 2);
        g.setColor(getForeground());
        if (expanded) {
            g.setFont(new Font("Dialog","plain",18).getJavaFont());
            System.out.println("tokenCollapse: " + tokenLeftArrowBar.getFirst());
            g.drawString(tokenLeftArrowBar.getText(),x,y);
        } else {
            g.drawString(tokenRightArrowBar.getText(),x,y);
        }
        GraphicsUtil.drawRaised(g,this);
    }
    
    public boolean isExpanded() { return expanded; }

    public static void main(String[] args) {
        Driver.launch();
    }
    
    public void paint(Graphics g) {
        System.out.println("ShowDefined.paint()");
        doPainting(g);
    }
    
    public void paintComponent(Graphics g) {
        System.out.println("ShowDefined.paintComponent()");
        doPainting(g);
    }
    
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (textPainter != null) textPainter.setFillColor(bg);
    }
    
    public void setCenterText(boolean center) {
        centeredText = center;
    }
    
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        
        
// process 2
//        if (expanded) {
//            textPainter.setText(tokenCollapse.getText());
//        } else {
//            textPainter.setText(tokenExpand.getText());
//        }

// process 1
  //      if (expanded) setImage(hideImage);
  //      else setImage(showImage);
        repaint();
    }
    
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (textPainter != null) textPainter.setLineColor(fg);
    }
    
    public void toggleExpanded() {
        setExpanded(!isExpanded());
    }
    
}
