package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.Pixel;
import ca.tecreations.Point;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class Scribble extends TFrame implements ActionListener {

    Driver driver;
    JPanel holder = new JPanel();
    AreaRep areaRep;

    static DrawPanel current = null;

    boolean firstRun = true;

    JMenuBar menubar = new JMenuBar();
    JMenu panels = new JMenu("Panels");
    JMenuItem setSize = new JMenuItem("Set Initial Size...");
    
    public Scribble(Driver driver, AreaRep areaRep) {
        this(driver.getProperties(), areaRep);
        this.driver = driver;
        setTitle("Scribble: " + driver.getProperties());
        addComponentListener(this);
    }

    public Scribble(Properties props, AreaRep areaRep) {
        super(props, "Scribble");
        setExitOnClose(true);
        setVisible(true);
        this.areaRep = areaRep;
        current = areaRep.getPanel(0, 0);
        setupGUI();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == setSize) {
            
        }
    }
    
    public void componentResized(ComponentEvent e) {
        // this doesn't work as I'd hoped. Maybe a 1 second timer? Something like
        // while (isAdjusting()) {} ??? .... do it once after windowResize is finished
//        reset();

    }

    public AreaRep getAreaRep() {
        return areaRep;
    }

    public DrawPanel getCurrentDrawPanel() {
        return DrawPanel.current;
    }

    public JPanel getHolder() { return holder; }
    
    public int getHolderWidth() {
        return holder.getSize().width;
    }

    public int getHolderHeight() {
        return holder.getSize().height;
    }

    public int getPanelWidth() {
        return current.getSize().width;
    }

    public int getPanelHeight() {
        return current.getSize().height;
    }

    public List<Pixel> getPixels(int xIndex, int yIndex) {
        return null;
    }

    public void guiSetNewAreaPanels() {
        holder.removeAll();
        List<List<DrawPanel>> panels = areaRep.getPanels();
        List<DrawPanel> strip;
        DrawPanel target = null;
        for (int i = 0; i < panels.size(); i++) {
            strip = panels.get(i);
            for (int j = 0; j < strip.size(); j++) {
                holder.add(strip.get(j));
            }
        }
        holder.validate();
        relayoutFrom(0,0);
    }
    
    public static void main(String[] args) {
        boolean working = true;
        if (working) {
            Driver.launch();
        } else {
            Properties props = new Properties(ProjectPath.getTecPropsPath() + "Scribble.properties");
            DrawPanel initial = new DrawPanel(null, 32, 32);
            AreaRep areaRep = new AreaRep(null, initial);

            SwingUtilities.invokeLater(() -> {
                Scribble app = new Scribble(props, areaRep);
                app.setVisible(true);
            });
        }
    }

    public void paint(Graphics g) {
        Dimension size = holder.getSize();
        System.out.println("Scribble: Size: " + size + " AreaSize: " + areaRep.getUnscaledSize());
        if (firstRun
                && (!(holder.getSize().width == 0 && holder.getSize().height == 0))) {

        }
        super.paint(g);
        Graphics hg = holder.getGraphics();
        hg.setColor(Color.TEC_DARK_GREY);
        hg.drawRect(0, 0, getSize().width, getSize().height); // right? because the outline
        hg.drawLine(0, 0, getSize().width, getSize().height); // top right to bottom left
        hg.drawLine(0, getSize().height, getSize().width, 0); // bottom left to top right
    }

    public void relayoutFrom(int startX, int y) {
        List<List<DrawPanel>> panels = areaRep.getPanels();
        List<DrawPanel> strip;
        int holderX;
        int w = current.getSize().width;
        int h = current.getSize().height;
        for (int i = 0; i < panels.size(); i++) {
            strip = panels.get(i);
            holderX = startX;
            for (int j = 0; j < strip.size(); j++) {
                strip.get(j).setLocation(holderX, y);
                holderX += w;
            }
            y += h;
        }
    }

    public void setAreaRep(AreaRep rep) {
        areaRep = rep;
        guiSetNewAreaPanels();
    }

    public void setupGUI() {
        setLayout(new BorderLayout());
        add(holder, BorderLayout.CENTER);
        holder.setLayout(null);
        holder.add(current);
        validate();
        menubar.add(panels);
        panels.add(setSize);
        setSize.addActionListener(this);
    }

}
