package ca.tecreations.apps.draw;

import ca.tecreations.File;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import static ca.tecreations.StringTool.containsMatchedDoubleQuotes;
import java.util.ArrayList;

import java.util.List;
/**
 *
 * @author Tim
 */
public class PaletteProperties_Custom {
    
    public PaletteProperties_Custom(String propsFilename) {
        new File(propsFilename).delete(true);
    }

    public static void main(String[] args) {
        // get lastPallette from Colors.last.palette
        String lastPalette = new Properties(Colors.propertiesFilename).get("last.palette");
        System.out.println("lastPalette: " + lastPalette);
        
        System.out.println("Colors.lastPaletteFilename: " + Colors.lastPaletteFileName);
        PaletteProperties props = new PaletteProperties(Colors.palettesPath + Colors.lastPaletteFileName);
        String colors = props.get("colors");
        System.out.println("Colors: " + colors);
        List<String> parsed = StringTool.parseDoubleQuoted(colors);
        for(int i = 0; i < parsed.size();i++) {
            System.out.println("Parsed[" + i + "]: " + parsed.get(i));
        }
        System.exit(0);
    }

    public static List<String> parseDoubleQuoted(String s) {
        if (!containsMatchedDoubleQuotes(s)) {
            throw new IllegalArgumentException("StringTool.parseDoubleQuoted: malformed: " + s);
        }
        List<String> result = new ArrayList<>();
        String tmp;
        int index = 0;
        int count = 0;
        String remainder = s.substring(s.indexOf("\""));
        System.out.println("Remainder: " + remainder);
        
        while (index < s.length() && count != -1) {
            count = remainder.indexOf("\"");
            if (count == -1) {
                index = s.length();
            }
            if (count > 0) {
                String next = s.substring(count,s.indexOf("\"",count));
                result.add(next);
                index += count + next.length();
                remainder = s.substring(index);
                System.out.println("remainder: " + remainder);
            } else {
                if (count == 0) {
                    String next = s.substring(0,s.indexOf("\"",1));
                    result.add(next);
                    index += next.length();
                    remainder = s.substring(index);
                    System.out.println("remainder: " + remainder);
                }
            }
        }
        return result;
    }
    

}
