package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;

import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class PaletteProperties extends Properties {
    
    public PaletteProperties(String propsFilename) {
        super(propsFilename);
        if (!propsFilename.endsWith(".palette")) {
            String nameMinus = new File(propsFilename).getMinusExtension();
            // we could do new File(propsFilename).getMinusCommonExtension();
            setFilename(nameMinus + ".palette"); // will auto-reload
        }
        System.out.println("propsFilename: " + propsFilename);
    }

    public void addColor(java.awt.Color c) {
        String colors = get("colors");
        if (colors == null || colors.length() == 0) {
            String toSet = "\"Color[" + c.getAlpha() + "," + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]\"";
            set("colors",toSet);
        } else {
            String toAdd = ",\"Color[" + c.getAlpha() + "," + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]\"";
            set("colors",colors + toAdd);
        }
    }
    
    public void addColor(Color c) {
        addColor(c.getJava());
    }
    
    public void clear() {
        set("colors","");
    }
    
    public List<Color> getColors() { 
        List<Color> listColors = new ArrayList<>();
        String colors = get("colors");
        if (colors != null && !colors.equals("")) {
            System.err.println("PaletteProperties: colors: " + colors);
            List<String> parsed = StringTool.parseDoubleQuoted(colors);
            //System.err.println("parsed: " + parsed);
            if (colors != null) {
                for(int i = 0; i < parsed.size();i++) {
                    Color color = Color.fromExternal(StringTool.getUnwrapped(parsed.get(i)));
                    listColors.add(color);
                }
            }
        }
        return listColors;
    }
    
    public void removeColor(Color c) {
        
    }
    
}
