package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.Pixel;
import ca.tecreations.components.SizedPanel;

import ca.tecreations.ImageTool;
import ca.tecreations.Point;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author tim
 */
public class GlyphPanel extends SizedPanel implements ActionListener,
        MouseListener, MouseMotionListener,
        MouseWheelListener {
    GlyphEditor editor;
    int width;
    int height;
    public static int scale = 16;
    public Color background = null;
    public BufferedImage image = null;
    public List<Pixel> pixels = new ArrayList<>();
    
    public Color outline = null;
    public Color xColor = null;
    
    JPopupMenu menu = new JPopupMenu();
    boolean addedMenuItems = false;
    JMenuItem getColor = new JMenuItem("Get Color");
    
    public GlyphPanel(GlyphEditor editor,int w, int h) {
        super(w * scale,h * scale); // use to set size of SizedPanel, but in a 
        // JScrollPane, that doesn't really work well, so we want a holder with a 
        // null layout. And then we could look at a diagonal tracker, for example,
        // for dragging the component.
        this.editor = editor;
        this.width = w;
        this.height = h;
        
        pixels.add(new Pixel(Color.GREY_12,3,2));
        pixels.add(new Pixel(Color.black,0,0));
        pixels.add(new Pixel(Color.black,23,23));
        
        background = Color.TEC_LIGHT_GREEN;
        
        outline = Color.red;
        xColor = Color.blue;
        
        addMouseListener(this);
        addMouseMotionListener(this);
        addMouseWheelListener(this);
    }
    
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == getColor) {
            
        }
    }
    
    public void doPainting(Graphics g) {
        int actualWidth = width * scale;
        int actualHeight = height * scale;
        if (background != null) {
            g.setColor(background);
            g.fillRect(0,0,actualWidth,actualHeight);
        }
        if (image != null) {
            g.drawImage(image,0,0,this);
        }

        if (outline != null) {
            g.setColor(outline);
            for(int i = 0; i < width;i++) {
                g.fillRect(i * scale,0,scale,scale);
                g.fillRect(i * scale,(height - 1) * scale,scale,scale);
            }
            for(int i = 0; i < height;i++) {
                g.fillRect(0,i * scale,scale,scale);
                g.fillRect((width - 1) * scale,i * scale,scale,scale);
            }
            
        }
        if (xColor != null) {
            g.setColor(xColor);
            int y = scale; // same as pix[?,1] * scale
            for(int i = 1;i < width - 1;i++,y += scale) {
                g.fillRect(i * scale,y,scale,scale);
            }
            y = scale; 
            for(int i = width - 2;i >= 1;i--, y += scale) {
                g.fillRect(i * scale,y,scale,scale);
            }
        }
        
        
        int x;
        int y;
        Pixel pixel;
        for(int i = 0; i < pixels.size();i++) {
            pixel = pixels.get(i);
            x = pixel.x * scale;
            y = pixel.y * scale;
            g.setColor(pixel.getColor());
            g.fillRect(x, y, scale,scale);
        }
        System.out.println("doPainting(): Size: " + getSize() + " Glyph Size: " + width + "x" + height + " Scaled(" + scale + "): " + (width * scale) + "x" + (height * scale));
    }

    public Point getEventPoint(MouseEvent e) {
        int x = e.getX() / scale;
        int y = e.getY() / scale;
        return new Point(x,y);
    }
    
    public Pixel getPixelAt(Point p) {
        Pixel pixel;
        for(int i = 0; i < pixels.size();i++) {
            pixel = pixels.get(i);
            if (pixel.x == p.x && pixel.y == p.y) {
                return pixel;
            }
        }
        return null;
    }
    
    public BufferedImage getScaledImage(int scale) {
        int oldScale = this.scale;
        this.scale = scale;
        // get image at specified scale, might fail on values < 1
        BufferedImage image = ImageTool.getNewBufferedImage(width * scale,height * scale);
        doPainting(image.getGraphics());
        this.scale = oldScale;
        return image;
    }
    
    public static void main(String[] args) {
        Driver.launch();
    }
    
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            showMenu(e);
        }
    }
    
    public void mouseDragged(MouseEvent e) {
        Point eventPoint = getEventPoint(e);
        setPixel(e);
        repaint();
    }
    
    public void mouseEntered(MouseEvent e) {
        
    }
    
    public void mouseExited(MouseEvent e) {
        
    }
    
    public void mouseMoved(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
        setPixel(e);
        repaint();
    }
    
    public void mouseReleased(MouseEvent e) {
        
    }
    
    public void mouseWheelMoved(MouseWheelEvent e) {
        //System.out.println("Notches: " + e.getWheelRotation());
        setScale(scale + e.getWheelRotation());
    }
    
    public void paint(Graphics g) {
        System.out.println("GlyphPanel.paint()");
        super.paint(g);
        doPainting(g);
    }
    
    public void paintComponent(Graphics g) {
        System.out.println("GlyphPanel.paintComponent()");
        doPainting(g);
    }

    public void removePixel(Point event) {
        Point p;
        for(int i = 0;i < pixels.size();i++) {
            p = pixels.get(i);
            if (p.x == event.x && p.y == event.y) {
                pixels.remove(i);
                return;
            }
        }
    }
    
    public void setBackground(MouseEvent e) {
        Point eventPoint = getEventPoint(e);
        // set
        // point for stroke? Color = Colors.BACK_COLOR
    }
    
    public void setForeground(MouseEvent e) {
        Point eventPoint = getEventPoint(e);
        // set
        // point for stroke? Color = Colors.PEN_COLOR
    }
    
    public void setImage(BufferedImage img) {
        image = img;
        repaint();
    }
    
    public void setImage(Image img) {
        BufferedImage bi = ImageTool.getNewBufferedImage(img.getWidth(this),img.getHeight(this));
        Graphics g = bi.getGraphics();
        g.drawImage(img,0,0,this);
        image = bi;
        repaint();
    }
    
    public void setPixel(MouseEvent e) {
        Point event = getEventPoint(e);
        Pixel pixel = getPixelAt(event);
        if (pixel != null) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                pixel.setColor(Colors.PEN_COLOR);
            } else if (SwingUtilities.isRightMouseButton(e)) {
                pixel.setColor(Colors.BACK_COLOR);
            }
        } else {
            if (SwingUtilities.isLeftMouseButton(e)) {
                pixel = new Pixel(Colors.PEN_COLOR,event.x,event.y);
            } else if (SwingUtilities.isRightMouseButton(e)) {
                pixel = new Pixel(Colors.BACK_COLOR,event.x,event.y);
            }
            pixels.add(pixel);
        }
        editor.repaint();
    }
    
    public void setScale(int scale) {
        if (scale > 0) {
            this.scale = scale;
            setSize(width * scale,height * scale);
            repaint();
        }
    }
    
    public void showMenu(MouseEvent e) {
        menu = new JPopupMenu();
        if (!addedMenuItems) {
            menu.add(getColor);
            getColor.addActionListener(this);
            addedMenuItems = true;
        }
        menu.show(this,e.getX(),e.getY());
    }
}
