package ca.tecreations.apps.draw;

import ca.tecreations.Platform;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class GlyphEditor extends TFrame {
    Driver driver;

    int width = 24; // of glyph
    int height = 24; // of glyph
    
    JPanel glyphPanelHolder;
    GlyphPanel glyphPanel;
    JScrollPane scroller;
    
    public GlyphEditor(Driver driver) {
        super(driver.getProperties(),"GlyphEditor");
        this.driver = driver;
        setTitle("GlyphEditor: " + driver.getProperties());
        setVisible(true);
        setExitOnClose(true);
        setLayout(new BorderLayout());
        glyphPanelHolder = new JPanel(null,false);
        glyphPanel = new GlyphPanel(this,width,height);
        glyphPanelHolder.add(glyphPanel);
        scroller = new JScrollPane(glyphPanelHolder,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        add(scroller, BorderLayout.CENTER);
        validate();    
    }
    
    public Colors getColors() {
        return driver.getColors();
    }
    
    public static void main(String[] args) {
        Driver.launch();
    }
    
    public void paint(Graphics g) {
        System.out.println("GlyphEditor.paint()");
        super.paint(g);
        //Graphics g2 = glyphPanelHolder.getGraphics();
        BufferedImage img = glyphPanel.getScaledImage(1);
        if (Platform.isWin()) {
            g.drawImage(img, getSize().width - 8 - scroller.getVerticalScrollBar().getSize().width - img.getWidth(),32,this);
        }
    }
    
    public void paintComponent(Graphics g) {
        System.out.println("GlyphEditor.paintComponent()");
        super.paintComponents(g);
    }
}

