package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.components.TFrame;

import java.awt.event.*;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class Driver implements ActionListener {
    public static Driver instance;
    public Properties properties = new Properties(ProjectPath.getTecPropsPath() + "Draw.properties");;
    public static Actual actual;
    public static Scribble scribble;
    public static Colors colors;
    public static Brushes brushes;
    public static GlyphEditor glyphEditor;
    
    public static Timer activatingTimer = null;
    public static boolean activating = false;
    
    public Driver() {
        int initialWidth = 32;
        int initialHeight = 32;
        DrawPanel initial = new DrawPanel(this,initialWidth,initialHeight);
        initial.setOutlineX(Color.TEC_LIGHT_GREEN);
        initial.setIdentify(true);
        AreaRep areaRep = new AreaRep(this,initial);
        while (areaRep.getPanelCount() == 0) { 
            Platform.sleep(125);
        }
        actual = new Actual(this,areaRep);
        scribble = new Scribble(this,areaRep);
        colors = new Colors(ProjectPath.instance,this);
        brushes = new Brushes(this);
        glyphEditor = new GlyphEditor(this);

        if (brushes.getLocation().y <= colors.getLocation().y) {
            int y = colors.getLocation().y + colors.getSize().height;
            brushes.setLocation(0,y);
        }
        
        int minY = brushes.getLocation().y + brushes.getSize().height;
        if (actual.getLocation().y <= brushes.getLocation().y + brushes.getSize().height) {
            actual.setLocation(0,minY);
            actual.setSize(Platform.getDesktopSize().width / 2, Platform.getDesktopSize().height - minY);
        }
        if (scribble.getLocation().y <= brushes.getLocation().y + brushes.getSize().height) {
            scribble.setLocation(actual.getSize().width,minY);
            
            scribble.setSize(360, 360);
        }
        actual.resetArea();

    }

    public void actionPerformed(ActionEvent e) {
    }
    
    public static void createAndShowGUI() {
        instance = new Driver();
        while (
            !(actual.isVisible()
                //                        && 
//              scribble.isVisible() 
                //                        && 
//              brushes.isVisible() 
//                                        &&
//              glyphEditor.isVisible() 
//                                        &&
//              colors.isVisible() 
             )
        ) {
            Platform.sleep(125);
        }
    }
    
    public Properties getProperties() { return properties; }
    
    public Actual getActual() { return actual; }
    
    public Brushes getBrushes() { return brushes; }
    
    public Colors getColors() { return colors; }
    
    public Scribble getScribble() { return scribble; }
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
    }

}

