package ca.tecreations.apps.draw;

import ca.tecreations.*;
import ca.tecreations.apps._actions.RefreshButton;
import ca.tecreations.components.Button;
import ca.tecreations.components.Movable;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.TFrame;
import ca.tecreations.text.TextPoints;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author Tim
 */
public class Colors extends TFrame implements MouseListener, MouseMotionListener {

    public static String palettesPath = ProjectPath.instance.getProjectPath() + ProjectPath.getSubPath("ca.tecreations.apps.draw.palettes");
    public static String lastPaletteFileName = "LastPalette.palette";
    public static final String LAST_PALETTE_PATH = palettesPath + lastPaletteFileName;
    
    Driver driver;
    Properties properties;
    public static String propertiesFilename = ProjectPath.instance.getTecPropsPath() + "Colors.properties";
    JPanel holder = new JPanel(null, false);

    Button lastSelected;
    List<Button> tileButtons = new ArrayList<>();

    JPanel tilesHolder = new JPanel(new BorderLayout());
    SizedPanel assigned;
    Button pen = new Button();
    Button back = new Button();
    JPanel tilesPanelHolder = new JPanel(null, false);
    SizedPanel tilesPanel = new SizedPanel(24, 24); // you need to keep 
    // track of the buttons added... so far in colors, we have defined, 
    // the command buttons expand and reset
    // and the random tiles 0 -> 255; 
    static List<Button> defined = new ArrayList<>();
    ShowDefined showDefined = new ShowDefined();

    RefreshButton resetRandoms = new RefreshButton();
    List<Button> randomButtons = new ArrayList<>();

    SizedPanel tilesScroller;
    Button tilesLeft = new Button();
    SizedPanel tilesScrollerTrack;
    Button tilesRight = new Button();
    Movable tilesKnob = new Movable(Movable.HORIZONTAL);

    SizedPanel palette;
    SizedPanel paletteControls;
    SizedPanel paletteTilesHolder;

    // save lastPaletteFileName when the user saves and then keep it in Colors.properties
    PaletteProperties paletteProperties = new PaletteProperties(palettesPath + lastPaletteFileName);
    SizedPanel paletteTiles;
    List<Button> paletteButtons = new ArrayList<>();
    
    Button clear;
    Button last;
    Button open;
    Button saveAs;
    Button chooser;
    Button fillToRightEdge;
    int paletteControlsWidth; // gets set in setupGUI
    
    SizedPanel paletteTilesScroller;
    SizedPanel paletteScrollerTrack;
    Button paletteLeft = new Button();
    Button paletteRight = new Button();
    Movable paletteKnob = new Movable(Movable.HORIZONTAL);

    boolean firstRun = true;
    int paintNum = 0;
    
    public static Color BACK_COLOR;
    public static Color PEN_COLOR;

    double tilesVisible = 0.0;
    double tilesPercent = 0.0;
    double tilesOnePercent = 0.0;
    double tilesScrollerOnePercent = 0.0;

    double palettePercent;
    double paletteVisible;
    double paletteOnePercent;
    double paletteScrollerOnePercent;

    int maxWidth; // both initlally set in setupGUI
    int trackWidth;
    
    public Colors(ProjectPath pp, Driver driver) {
        super(new Properties(propertiesFilename), "Colors");
        this.driver = driver;

        // if the user has set the last palette file name, configure that
        properties = getProperties();
        String lastPalette = properties.get("last.palette");
        if (lastPalette != null && !lastPalette.equals("") && !lastPalette.equals("null")) {
            lastPaletteFileName = lastPalette;
        }

        setVisible(true);
        setExitOnClose(true);
        setSize(Platform.getDesktopSize().width, 39 + 96);
        setLocation(0, 0);
        setResizable(false);
        setupGUI();

        // this requires that the image have a transparency, but it doesn't
        resetRandoms.setBackground(Color.DARK_GREY);
        
        // start expanded for now

        // configure the last palette if need be
        setupPalette();

        loadFaves();
        // query load favourites (via Spring/PHP User?)

        setLastSelected(Color.TEC_PURPLE);
    }

    public Button addAndGetColorTile(Color c, List<Button> list) {
        Button tile = new Button();
        tile.setBackground(c);
        tile.setDrawRaised(true);
        tile.addMouseListener(this);
        tile.setSelectable(true);
        tile.setSelectedColor(Color.getReverse(c));
        list.add(tile);
        tilesPanel.add(tile);
        return tile;
    }

    public void collapse() {
        tilesPanel.setSize((2 + 256) * 24, 24);
        for (int i = 0; i < defined.size(); i++) {
            defined.get(i).setLocation(-defined.get(i).getSize().width, 0);
        }
        showDefined.setLocation(0, 0);
        resetRandoms.setLocation(showDefined.getSize().width, 0);
        int x = resetRandoms.getLocation().x + resetRandoms.getSize().width;
        for (int i = 0; i < randomButtons.size(); i++) {
            randomButtons.get(i).setLocation(x, 0);
            x += 24;
        }
    }

    public void constructHomeButtons() {
        addAndGetColorTile(Color.BLUE, defined);
        addAndGetColorTile(Color.GREEN, defined);
        addAndGetColorTile(Color.RED, defined);
        addAndGetColorTile(Color.CYAN, defined);
        addAndGetColorTile(Color.MAGENTA, defined);
        addAndGetColorTile(Color.YELLOW, defined);
        addAndGetColorTile(Color.ORANGE, defined);
        addAndGetColorTile(Color.PINK, defined);
        addAndGetColorTile(Color.TRANSLUCENT, defined);
        Button grey = addAndGetColorTile(Color.GREY, defined);
        grey.setSelectedColor(Color.white);
        defined.set(defined.size() - 1, grey);
        addAndGetColorTile(Color.LIGHT_GREY, defined);
        addAndGetColorTile(Color.DARK_GREY, defined);
        addAndGetColorTile(Color.TRANSPARENT, defined);
        addAndGetColorTile(Color.DEFAULT_SWING_BG, defined);
        addAndGetColorTile(Color.TEC_SELECTED, defined);
        addAndGetColorTile(Color.TEC_ORANGE, defined);
        addAndGetColorTile(Color.TEC_PURPLE, defined);
        addAndGetColorTile(Color.TEC_LIGHT_GREEN, defined);
        addAndGetColorTile(Color.TEC_DARK_GREEN, defined);
        addAndGetColorTile(Color.TEC_LIGHT_GREY, defined);
        addAndGetColorTile(Color.TEC_DARK_GREY, defined);
        addAndGetColorTile(Color.DIRTY, defined);
        addAndGetColorTile(Color.BROWN, defined);
//24        
        addAndGetColorTile(Color.WHITE, defined);
        addAndGetColorTile(Color.GREY_F, defined);
        addAndGetColorTile(Color.GREY_E, defined);
        addAndGetColorTile(Color.GREY_D, defined);
        addAndGetColorTile(Color.GREY_C, defined);
        addAndGetColorTile(Color.GREY_B, defined);
        addAndGetColorTile(Color.GREY_A, defined);
        addAndGetColorTile(Color.GREY_9, defined);
        addAndGetColorTile(Color.GREY_8, defined);
        addAndGetColorTile(Color.GREY_7, defined);
        addAndGetColorTile(Color.GREY_6, defined);
        addAndGetColorTile(Color.GREY_5, defined);
        addAndGetColorTile(Color.GREY_4, defined);
        addAndGetColorTile(Color.GREY_3, defined);
        addAndGetColorTile(Color.GREY_2, defined);
        addAndGetColorTile(Color.GREY_1, defined);
        addAndGetColorTile(Color.black, defined);
// 42

        addAndGetColorTile(Color.BRIGHT_RED, defined);
        addAndGetColorTile(Color.BRIGHT_GREEN, defined);
        addAndGetColorTile(Color.BRIGHT_YELLOW, defined);
        addAndGetColorTile(Color.BRIGHT_BLUE, defined);
        addAndGetColorTile(Color.BRIGHT_MAGENTA, defined);
        addAndGetColorTile(Color.BRIGHT_CYAN, defined);
// 48
        // construct tileButtons, starting with defined
        Button definedButton;
        for (int i = 0; i < defined.size(); i++) {
            definedButton = defined.get(i);
            tileButtons.add(definedButton);
            definedButton.setSelectedColor(Color.getReverse(definedButton.getBackground()));
        }
        // include command buttons
        showDefined.setBackground(Color.TEC_LIGHT_GREEN);
        showDefined.setPoints(showDefined.getPoints().getSized(18).getBold());
        showDefined.setForeground(Color.DARK_GREY);
        showDefined.setCenterText(true);
        showDefined.setExpanded(true);
        showDefined.setDrawRaised(true);
        showDefined.addMouseListener(this);
        tileButtons.add(showDefined);
        tilesPanel.add(showDefined);

        resetRandoms.setDrawRaised(true);
        resetRandoms.addMouseListener(this);
        tileButtons.add(resetRandoms);
        tilesPanel.add(resetRandoms);

        // and random color tiles.
        for (int i = 0; i < 256; i++) {
            Button tile = addAndGetColorTile(Color.getRandomColor(), randomButtons);
            tile.setSelectedColor(Color.getReverse(tile.getBackground()));
            tile.addMouseMotionListener(this);
            tileButtons.add(tile);
        }
        tilesPanel.validate();
        int w = 0;
        for (int i = 0; i < defined.size(); i++) {
            w += defined.get(i).getSize().width;
        }
        w += showDefined.getSize().width;
        w += resetRandoms.getSize().width;
        w += (256 * Button.SIZE);
        tilesPanel.setSize(w, 24);
        int x = 0;
        for (int i = 0; i < tileButtons.size(); i++) {
            tileButtons.get(i).setLocation(x, 0);
            x += tileButtons.get(i).getSize().width;
        }
    }

    public void doPaletteScrollerCalculations() {
        if (paletteTiles != null) {
            paletteOnePercent = (double) paletteTiles.getSize().width / (double) 100;
            paletteScrollerOnePercent = (double) paletteScrollerTrack.getSize().width / (double) 100;
            paletteVisible = (double) paletteScrollerTrack.getSize().width / paletteOnePercent;
            double knobWidth = paletteVisible * paletteScrollerOnePercent;
            paletteKnob.setSize((int) knobWidth, paletteKnob.getSize().height);
            palettePercent = (double) paletteKnob.getLocation().x / paletteScrollerOnePercent;
            System.out.println("PalettePercent: " + palettePercent + " Visible: " + paletteVisible);
            if (palettePercent + paletteVisible >= 100) {
                paletteTiles.setLocation(0 + paletteTilesHolder.getSize().width - paletteTiles.getSize().width, 0);
            } else {
                paletteTiles.setLocation(-(int) (palettePercent * paletteOnePercent), 0);
            }
        }
    }

    public void doTileScrollerCalculations() {
        tilesOnePercent = (double) tilesPanel.getSize().width / (double) 100;
        if (tilesScrollerTrack != null) {
            tilesScrollerOnePercent = (double) tilesScrollerTrack.getSize().width / (double) 100;
            tilesVisible = (double) tilesScrollerTrack.getSize().width / tilesOnePercent;
            double knobWidth = tilesVisible * tilesScrollerOnePercent;
            tilesKnob.setSize((int) knobWidth, tilesKnob.getSize().height);
            tilesPercent = (double) tilesKnob.getLocation().x / tilesScrollerOnePercent;
            System.out.println("TilesPercent: " + tilesPercent + " Visible: " + tilesVisible);
            if (tilesPercent + tilesVisible >= 100) {
                tilesPanel.setLocation(0 + tilesPanelHolder.getSize().width - tilesPanel.getSize().width, 0);
            } else {
                tilesPanel.setLocation(-(int) (tilesPercent * tilesOnePercent), 0);
            }
        }
    }

    public void expand() {
        int w = 0;
        for (int i = 0; i < defined.size(); i++) {
            w += defined.get(i).getSize().width;
        }
        w += showDefined.getSize().width;
        w += resetRandoms.getSize().width;
        for (int i = 0; i < randomButtons.size(); i++) {
            w += randomButtons.get(i).getSize().width;
        }
        tilesPanel.setSize(w, 24);
        int x = 0;
        for (int i = 0; i < defined.size(); i++) {
            defined.get(i).setLocation(x, 0);
            x += defined.get(i).getSize().width;
        }
        showDefined.setLocation(x, 0);
        x += showDefined.getSize().width;
        resetRandoms.setLocation(x, 0);
        x += resetRandoms.getSize().width;
        for (int i = 0; i < randomButtons.size(); i++) {
            randomButtons.get(i).setLocation(x, 0);
            x += randomButtons.get(i).getSize().width;
        }
    }

    public int getPaletteWidth() { // first do add/removes and then validate 
                                   // and then size and layout
        int minWidth = maxWidth - paletteControls.getSize().width;
        int paletteWidth = paletteButtons.size() * Button.SIZE;
        int width = Math.max(minWidth,paletteWidth);
        return width;
    }
    
    public Button getTile(Color c) {
        Button button;
        for (int i = 0; i < randomButtons.size(); i++) {
            button = randomButtons.get(i);
            if (c.equals(button.getBackground())) {
                return button;
            }
        }
        return null;
    }

    public boolean isDefined(Color c) {
        for (int i = 0; i < defined.size(); i++) {
            if (c.equals(defined.get(i).getBackground())) {
                return true;
            }
        }
        return false;
    }

    public boolean isRandom(Color c) {
        for (int i = 0; i < randomButtons.size(); i++) {
            if (c.equals(randomButtons.get(i).getBackground())) {
                return true;
            }
        }
        return false;
    }

    public void layoutPalette() {
        int x = 0;
        for (int i = 0; i < paletteButtons.size(); i++) {
            paletteButtons.get(i).setLocation(x, 0);
            x += paletteButtons.get(i).getSize().width;
        }
    }

    public void layoutTiles() {
        int x = 0;
        Button b;
        for (int i = 0; i < defined.size(); i++) {
            b = defined.get(i);
            if (showDefined.isExpanded()) {
                b.setLocation(x, 0);
                x += b.getSize().width;
            } else {
                b.setLocation(-defined.get(i).getSize().width, 0);
            }
        }
        showDefined.setLocation(x, 0);
        x += showDefined.getSize().width;
        resetRandoms.setLocation(x, 0);
        x += resetRandoms.getSize().width;
        for (int i = 0; i < randomButtons.size(); i++) {
            b = randomButtons.get(i);
            b.setLocation(x, 0);
            x += b.getSize().width;
        }
    }

    public void loadFaves() {

    }

    public static void main(String[] args) {
        Driver.launch();
        //Colors colors = new Colors(ProjectPath.instance, null);
        //colors.setVisible(true);

    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == showDefined) {
            if (showDefined.isExpanded()) {
                collapse();
            } else {
                expand();
            }
            showDefined.toggleExpanded();
        } else if (e.getSource() == resetRandoms) {
            reSetRandoms();
        } else if (e.getSource() == tilesLeft) {

        } else if (e.getSource() == tilesRight) {

        } else if (e.getSource() == tilesScroller) {

        } else if (e.getSource() == tilesKnob) {

        } else if (e.getSource() == paletteLeft) {

        } else if (e.getSource() == paletteRight) {

        } else if (e.getSource() == paletteTilesScroller) {

        } else if (e.getSource() == paletteKnob) {

        } else if (e.getSource() == clear) {
            paletteClear();
        } else if (e.getSource() == last) {
            paletteLast();
        } else if (e.getSource() == open) {

        } else if (e.getSource() == saveAs) {

        } else if (e.getSource() == chooser) {
            java.awt.Color c = JColorChooser.showDialog(this, "Select a Color", null);
            Button tile = new Button();
            tile.setBackground(c);
            tile.addMouseListener(this);
            paletteAdd(tile);
            paletteProperties.addColor(c);
            repaint();
        } else if (e.getSource() == fillToRightEdge) {
            // fill
            
        } else if (e.getSource() instanceof Button) {
            Button src = (Button) e.getSource();
            if (SwingUtilities.isLeftMouseButton(e) && src != pen) {
                PEN_COLOR = new Color(((Button) e.getSource()).getBackground());
                setPenColor(PEN_COLOR);
                lastSelected.setSelected(false);
                lastSelected = ((Button) e.getSource());
                lastSelected.setSelected(true);
                lastSelected.repaint();
            } else if (SwingUtilities.isRightMouseButton(e) && src != back) {
                BACK_COLOR = new Color(((Button) e.getSource()).getBackground());
                setBackColor(BACK_COLOR);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getSource() == tilesKnob) {
            doTileScrollerCalculations();
        } else if (e.getSource() == paletteKnob) {
            doPaletteScrollerCalculations();
        } else if (e.getSource() instanceof Button){
            Button button = (Button)e.getSource();
            if (inList_ByBackground(randomButtons,button)) {
                lastSelected.removeMouseMotionListener(this);
                paletteDoMove();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof Button) {
            lastSelected.setSelected(false);
            lastSelected = (Button)e.getSource();
            //lastSelected.setSelected(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public boolean inList_ByBackground(List<Button> tiles, Button tile) {
        for (int i = 0; i < tiles.size(); i++) {
            if (tiles.get(i).getBackground().equals(tile.getBackground())) {
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g) {
        paintNum++;
        if (paintNum >= 6) {
            System.out.println("Colors:                     : " + this);
            System.out.println("Colors: holder              : " + holder);
            System.out.println("Colors: assigned            : " + assigned);
            System.out.println("Colors: back                : " + back);
            System.out.println("Colors: pen                 : " + pen);
            System.out.println("Colors: tilesPanel          : " + tilesPanel);
            System.out.println("Colors: tilesPanelParent    : " + tilesPanel.getParent().equals(tilesHolder));
            System.out.println("Colors: tilesHolder         : " + tilesHolder);
            System.out.println("Colors: tilesScroller       : " + tilesScroller);
            System.out.println("Colors: tilesLeft           : " + tilesLeft);
            System.out.println("Colors: tilesScrollerTrack  : " + tilesScrollerTrack);
            System.out.println("Colors: tilesLeft           : " + tilesRight);
            System.out.println("Colors: palette             : " + palette);
            System.out.println("Colors: paletteTilesScroller: " + paletteTilesScroller);
            System.out.println("Colors: paletteLeft         : " + paletteLeft);
            System.out.println("Colors: paletteScrollerTrack: " + paletteScrollerTrack);
            System.out.println("Colors: paletteRight        : " + paletteRight);
            doTileScrollerCalculations();
            doPaletteScrollerCalculations();
        }
        super.paint(g);
    }


    public void paletteAdd(Button tile) {
        tilesPanel.remove(tile);
        paletteTiles.add(tile);
        paletteButtons.add(tile);
        validate();
        int width = Math.max(maxWidth - paletteControlsWidth,paletteButtons.size() * Button.SIZE);
        paletteTiles.setSize(getPaletteWidth(), paletteTiles.getSize().height);
        layoutPalette();
        doPaletteScrollerCalculations();
    }

    public void paletteClear() {
        paletteTiles.removeAll();
        paletteTiles.validate();
        paletteProperties.clear();
    }
    
    public void paletteDoMove() {
        if (
                !inList_ByBackground(defined, lastSelected)
//                && !inList_ByBackground(paletteButtons, lastSelected)
           ) 
        {
            tilesPanel.remove(lastSelected);
            randomButtons.remove(lastSelected);
            Button newTile = addAndGetColorTile(Color.getRandom(), tileButtons);
            newTile.addMouseMotionListener(this);
            tilesPanel.validate();
            layoutTiles();
            
            paletteButtons.add(lastSelected);
            paletteTiles.add(lastSelected);
            paletteTiles.setSize(getPaletteWidth(), paletteTiles.getSize().height);
            paletteTiles.validate();
            layoutPalette();

            //validate();
            
            // save the data
            paletteProperties.addColor(lastSelected.getBackground());
            
            doPaletteScrollerCalculations();
        }
    }

    public void paletteLast() {
        paletteProperties = new PaletteProperties(LAST_PALETTE_PATH);
        paletteTiles.removeAll();
        paletteButtons = new ArrayList<>();
        List<Color> colors = paletteProperties.getColors();
        for(int i = 0;i < colors.size();i++) {
            Button b = new Button();
            b.setBackground(colors.get(i));
            b.addMouseListener(this);
            b.setSelectedColor(Color.getReverse(colors.get(i)));
            b.setDrawRaised(true);
            paletteTiles.add(b);
            paletteButtons.add(b);
        }
    }
    
    public void reSetRandoms() {
        for (int i = randomButtons.size() - 1; i >= 0; i--) {
            tilesPanel.remove(randomButtons.get(i));
            randomButtons.remove(randomButtons.get(i));
        }
        int x = 0;
        if (showDefined.isExpanded()) {
            x = (defined.size() + 2) * Button.SIZE;
        } else {
            x = 48; // 2 * Button.SIZE
        }
        randomButtons = new ArrayList<>();
        for (int i = 0; i < 256; i++) {
            tilesPanel.add(addAndGetColorTile(Color.getRandom(), randomButtons));
            randomButtons.get(i).setLocation(x, 0);
            x += Button.SIZE; // ok, really, it should be on a per element basis
        }
        validate();

        repaint();
        System.out.println("Reset Randoms: tileButtons: " + tileButtons.size());
    }

    public void setBackColor(Color c) {
        back.setBackground(c);
        BACK_COLOR = c;
        repaint();
    }

    public void setLastSelected(Color c) {
        for (int i = 0; i < paletteButtons.size(); i++) {
            if (paletteButtons.get(i).getBackground().equals(c)) {
                lastSelected = paletteButtons.get(i);
                lastSelected.setSelected(true);
                return;
            }
        }
        for (int i = 0; i < tileButtons.size(); i++) {
            if (tileButtons.get(i).getBackground().equals(Color.TEC_PURPLE)) {
                lastSelected = tileButtons.get(i);
                lastSelected.setSelected(true);
                return;
            }
        }
    }

    public void setPenColor(Color c) {
        pen.setBackground(c);
        PEN_COLOR = c;
        repaint();
    }

    public void setupGUI() {
        maxWidth = Platform.getDesktopSize().width - 16;
        trackWidth = maxWidth - (tilesLeft.getSize().width + tilesRight.getSize().width);

        assigned = new SizedPanel(back.getSize().width + pen.getSize().width, pen.getSize().height);
        assigned.add(pen);
        assigned.add(back);
        if (driver != null) {
            pen.setBackground(driver.getScribble().getForeground());
            back.setBackground(driver.getScribble().getBackground());
        }
        pen.setDrawRaisedThin(true);
        back.setLocation(back.getSize().width, 0);
        back.setDrawRaisedThin(true);
        tilesHolder.add(assigned, BorderLayout.WEST);
        tilesHolder.add(tilesPanelHolder, BorderLayout.CENTER);
        tilesHolder.setSize(maxWidth, 24);
        tilesPanelHolder.add(tilesPanel);
        tilesPanelHolder.setSize(maxWidth - assigned.getSize().width, 24);
        constructHomeButtons();
        holder.add(tilesHolder); // complete the top line of the GUI

        tilesScroller = new SizedPanel(maxWidth, tilesLeft.getSize().height);
        tilesScroller.setLayout(null);
        tilesScroller.add(tilesLeft);
        tilesScrollerTrack = new SizedPanel(maxWidth - (tilesLeft.getSize().width + tilesRight.getSize().width), 24);
        tilesScrollerTrack.setLayout(null);
        tilesScroller.add(tilesScrollerTrack);
        tilesScrollerTrack.setSize(trackWidth, tilesLeft.getSize().height);
        tilesScrollerTrack.setLocation(tilesLeft.getSize().width, 0);
        tilesScrollerTrack.add(tilesKnob);
        tilesKnob.setSize(100, 24);
        tilesKnob.setLimitToParentBounds(true);
        tilesScroller.add(tilesRight);
        tilesRight.setLocation(maxWidth - tilesRight.getSize().width, 0);
        tilesLeft.setBackground(Color.DARK_GREY);
        tilesRight.setBackground(Color.DARK_GREY);
        tilesLeft.setForeground(Color.white);
        tilesRight.setForeground(Color.white);
        tilesLeft.setText("<");
        tilesRight.setText(">");
        tilesLeft.setPoints(tilesLeft.getPoints().getSized(18).getBold());
        tilesRight.setPoints(tilesLeft.getPoints());
        tilesLeft.setSize(24, 24);
        tilesRight.setSize(24, 24);
        tilesKnob.setBackground(Color.GREY);
        tilesLeft.setDrawRaised(true);
        tilesKnob.setDrawRaised(true);
        tilesRight.setDrawRaised(true);
        holder.add(tilesScroller);
        tilesScroller.setLocation(0, 24); // complete 2nd line of GUI

        palette = new SizedPanel(maxWidth, 24);
        palette.setLayout(new BorderLayout());

        TextPoints commandPoints = tilesLeft.getPoints().getSized(14).getPlain();
        clear = new Button();
        clear.setBackground(Color.GREY);
        clear.setForeground(Color.WHITE);
        clear.setPoints(commandPoints);
        clear.setText("Clear");
        paletteControlsWidth += clear.getTextWidth();

        last = new Button();
        last.setBackground(Color.GREY);
        last.setForeground(Color.WHITE);
        last.setPoints(commandPoints);
        last.setText("Last");
        paletteControlsWidth += last.getTextWidth();

        open = new Button();
        open.setBackground(Color.GREY);
        open.setForeground(Color.WHITE);
        open.setPoints(commandPoints);
        open.setText("Open");
        paletteControlsWidth += open.getTextWidth();

        saveAs = new Button();
        saveAs.setBackground(Color.GREY);
        saveAs.setForeground(Color.WHITE);
        saveAs.setPoints(commandPoints);
        saveAs.setText("Save...");
        paletteControlsWidth += saveAs.getTextWidth();

        chooser = new Button();
        chooser.setBackground(Color.GREY);
        chooser.setForeground(Color.WHITE);
        chooser.setPoints(commandPoints);
        chooser.setText(" ? ");
        paletteControlsWidth += chooser.getSize().width;

        paletteControls = new SizedPanel(paletteControlsWidth, 24);
        paletteControls.add(clear);
        paletteControls.add(last);
        paletteControls.add(open);
        paletteControls.add(saveAs);
        paletteControls.add(chooser);
        clear.addMouseListener(this);
        last.addMouseListener(this);
        open.addMouseListener(this);
        saveAs.addMouseListener(this);
        chooser.addMouseListener(this);

        // layout the controls, the first will be at x:0 and y:0, so just to the right
        last.setLocation(clear.getSize().width,0);
        open.setLocation(last.getLocation().x + last.getSize().width,0);
        saveAs.setLocation(open.getLocation().x + open.getSize().width, 0);
        chooser.setLocation(saveAs.getLocation().x + saveAs.getSize().width, 0);
        paletteControls.setSize(paletteControlsWidth, 24);
        paletteControls.setBackground(Color.TEC_LIGHT_GREEN);

        palette.add(paletteControls, BorderLayout.WEST);

        // add any palette tiles
        paletteTilesHolder = new SizedPanel(maxWidth - paletteControlsWidth, Button.SIZE);
        paletteTilesHolder.setLayout(null); // we want to scroll the tiles
        paletteTiles = new SizedPanel(paletteTilesHolder.getSize().width, Button.SIZE); // set to NO_PALETTE initially
        paletteTiles.setLayout(null);
        paletteTiles.setBackground(Color.TEC_DARK_GREEN);
        paletteTilesHolder.add(paletteTiles);

        paletteTilesHolder.setBackground(Color.yellow);
        paletteTiles.setBackground(Color.BRIGHT_BLUE);

        palette.add(paletteTilesHolder, BorderLayout.CENTER);
        holder.add(palette);
        palette.setLocation(0, 48);

        paletteTilesScroller = new SizedPanel(maxWidth, 24);
        paletteScrollerTrack = new SizedPanel(trackWidth, paletteRight.getSize().height);
        paletteScrollerTrack.setLayout(null);
        paletteScrollerTrack.setBackground(Color.PINK);
        paletteScrollerTrack.setLocation(paletteLeft.getSize().width, 0);
        paletteScrollerTrack.add(paletteKnob);
        paletteKnob.setSize(100, 24);
        paletteKnob.setLimitToParentBounds(true);
        paletteRight.setLocation(maxWidth - paletteRight.getSize().width, 0);
        paletteLeft.setBackground(Color.DARK_GREY);
        paletteRight.setBackground(Color.DARK_GREY);
        paletteLeft.setForeground(Color.white);
        paletteRight.setForeground(Color.white);
        paletteLeft.setText("<");
        paletteRight.setText(">");
        paletteLeft.setPoints(paletteLeft.getPoints().getSized(18).getBold());
        paletteRight.setPoints(paletteLeft.getPoints());
        paletteLeft.setSize(24, 24);
        paletteRight.setSize(24, 24);
        paletteKnob.setBackground(Color.GREY);

        paletteLeft.setDrawRaised(true);
        paletteKnob.setDrawRaised(true);
        paletteRight.setDrawRaised(true);
        paletteTilesScroller.add(paletteLeft);
        paletteTilesScroller.add(paletteScrollerTrack);
        paletteTilesScroller.add(paletteRight);
        paletteTilesScroller.setLocation(paletteLeft.getSize().width, 0);
        paletteRight.setLocation(maxWidth - paletteRight.getSize().width, 0);

        holder.add(paletteTilesScroller);
        paletteTilesScroller.setLocation(0, 72);
        add(holder, BorderLayout.CENTER);
        validate();

        setPenColor(Color.TEC_PURPLE);
        setLastSelected(Colors.PEN_COLOR);// test as you go
        setBackColor(Color.TEC_ORANGE);

        // by adding CommmandButton event listeners above, we can quickly identify if
        // our control's event listeners are complete or not
        tilesLeft.addMouseListener(this);
        tilesKnob.addMouseListener(this);
        tilesKnob.addMouseMotionListener(this);
        tilesRight.addMouseListener(this);
        tilesScrollerTrack.addMouseListener(this);

        paletteLeft.addMouseListener(this);
        paletteKnob.addMouseListener(this);
        paletteKnob.addMouseMotionListener(this);
        paletteRight.addMouseListener(this);
        paletteScrollerTrack.addMouseListener(this);
    }

    public void setupPalette() {
        List<Color> colors = paletteProperties.getColors();
        for (int i = 0; i < colors.size(); i++) {
            Button b = new Button();
            b.setBackground(colors.get(i));
            b.addMouseListener(this);
            b.setDrawRaised(true);
            paletteAdd(b);
        }
    }
}
