package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.Pixel;
import ca.tecreations.Point;
import ca.tecreations.components.Movable;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim -- we want to move on now, to the next thing. I don't. I want to stay 
 * here.
 */
public class AreaRep extends Movable {
    Driver driver;
    List<List<DrawPanel>> panels = new ArrayList<>();
    
    public Point locChange = new Point(0,0);
    
    public AreaRep(Driver driver, DrawPanel initialPanel) {
        super(Movable.NONE);
        this.driver = driver;
        setBackground(Color.YELLOW);
        setOutlineColor(Color.BLACK);
        setXColor(Color.BLACK);
        List<DrawPanel> firstRow = new ArrayList<>();
        firstRow.add(initialPanel);
        panels.add(firstRow);
    }
 
    public void addToStroke(int xCoord, int yCoord, int x,int y) {
        DrawPanel panel = getPanel(xCoord,yCoord);
        panel.addToMyStroke(x,y);
    }

    public Point create(String direction) {
        DrawPanel current = driver.getScribble().getCurrentDrawPanel();
        java.awt.Point tl = getTopLeft().getLocation();
        java.awt.Point lastLoc = current.getLocation();
        DrawPanel copy = current.getEmpty(); // create a template object
        List<List<DrawPanel>> newPanels = new ArrayList<>();
        List<DrawPanel> strip = null;
        Point loc = new Point(-10,-10);
        
        if (direction.equals("E")) {
            for(int i = 0; i < panels.size();i++) {
                strip = panels.get(i);
                strip.add(copy.getEmpty()); // construct new from template
                newPanels.add(strip);
            }
            loc = new Point(tl.x,tl.y);
        } else if (direction.equals("N")) {
            strip = panels.get(0);
            List<DrawPanel> newStrip = new ArrayList<>();
            for(int i = 0; i < strip.size();i++) {
                newStrip.add(copy.getEmpty());
            }
            newPanels.add(newStrip);
            for(int i = 0; i < panels.size();i++) {
                newPanels.add(panels.get(i));
            }
            loc = new Point(tl.x,tl.y - current.getSize().height);
        } else if (direction.equals("S")) {
            for(int i = 0; i < panels.size();i++) {
                newPanels.add(panels.get(i));
            }
            strip = panels.get(0);
            List<DrawPanel> newStrip = new ArrayList<>();
            for(int i = 0; i < strip.size();i++) {
                newStrip.add(copy.getEmpty());
            }
            newPanels.add(newStrip);
            loc = new Point(tl.x,tl.y);
        } else if (direction.equals("W")) {
            for(int i = 0; i < panels.size();i++) {
                strip = panels.get(i);
                List<DrawPanel> newStrip = new ArrayList<>();
                newStrip.add(copy.getEmpty()); // construct new from template
                for(int j = 0; j < strip.size();j++) {
                    newStrip.add(strip.get(j));
                }
                newPanels.add(newStrip);
            }
            loc = new Point(tl.x - current.getSize().width,tl.y);
        } else if (direction.equals("NW")) {
            strip = new ArrayList<>();
            
            // process the top line
            strip.add(copy.getEmpty());
            List<DrawPanel> tStrip = panels.get(0);
            for(int i = 0; i < tStrip.size();i++) {
                strip.add(copy.getEmpty());
            }
            newPanels.add(strip); // add to new set
            
            // process the left sides of existing lines
            for(int i = 0; i < panels.size();i++) {
                strip = panels.get(i);
                List<DrawPanel> newStrip = new ArrayList<>();
                newStrip.add(copy.getEmpty()); // add to the left
                for(int j = 0; j < strip.size();j++) {
                    newStrip.add(strip.get(j)); // and all existing
                }
                newPanels.add(newStrip); // add to new set
            }
            loc = new Point(tl.x - current.getSize().width,tl.y - current.getSize().height);
        } else if (direction.equals("NE")) {
            strip = new ArrayList<>();
            // process the top line
            List<DrawPanel> tStrip = panels.get(0);
            for(int i = 0; i <= tStrip.size();i++) {
                strip.add(copy.getEmpty());
            }
            newPanels.add(strip); // add to new set
            
            // process the right sides of existing lines
            for(int i = 0; i < panels.size();i++) {
                strip = panels.get(i);
                strip.add(copy.getEmpty());
                newPanels.add(strip); 
            }
            loc = new Point(tl.x,tl.y - current.getSize().height);
        } else if (direction.equals("SW")) {
            // process the left sides of existing lines
            List<DrawPanel> newStrip = new ArrayList<>();
            for(int i = 0; i < panels.size();i++) {
                strip = panels.get(i);
                newStrip = new ArrayList<>();
                newStrip.add(copy.getEmpty()); // add to the left
                for(int j = 0; j < strip.size();j++) {
                    newStrip.add(strip.get(j)); // and all existing
                }
                newPanels.add(newStrip); // add to new set
            }
            int count = newStrip.size();
            newStrip = new ArrayList<>();
            for(int i = 0; i < count;i++) {
                newStrip.add(copy.getEmpty());
            }
            newPanels.add(newStrip);
            loc = new Point(tl.x - current.getSize().width,tl.y);
        } else if (direction.equals("SE")) {
            strip = new ArrayList<>();
            
            // process the top line
            strip.add(copy.getEmpty());
            List<DrawPanel> tStrip = panels.get(0);
            for(int i = 0; i < tStrip.size();i++) {
                strip.add(copy.getEmpty());
            }
            newPanels.add(strip); // add to new set
            
            // process the left sides of existing lines
            for(int i = 0; i < panels.size();i++) {
                strip = panels.get(i);
                List<DrawPanel> newStrip = new ArrayList<>();
                newStrip.add(copy.getEmpty()); // add to the left
                for(int j = 0; j < strip.size();j++) {
                    newStrip.add(strip.get(j)); // and all existing
                }
                newPanels.add(newStrip); // add to new set
            }
            loc = new Point(tl.x,tl.y);
        }
        
        panels = newPanels;
        driver.getScribble().setAreaRep(this);
        return loc;
    }
    
    public void endStrokes() {
        List<DrawPanel> strip;
        for(int i = 0; i < panels.size();i++) {
            strip = panels.get(i);
            for(int j = 0; j < strip.size();j++) {
                strip.get(j).endStroke();
            }
        }
    }
    
    public Point getLocationChange() { return locChange; }
    
    public int getMaxX() { return panels.get(0).size(); }
    
    public int getMaxY() { return panels.size(); }
    
    public DrawPanel getPanel(int x, int y) {
        return panels.get(y).get(x);
    }

    public int getPanelCount() {
        int count = 0;
        List<DrawPanel> strip;
        for(int i = 0; i < panels.size();i++) {
            strip = panels.get(i);
            for(int j = 0; j < strip.size();j++) {
                count++;
            }
        }
        return count;
    }
    
    public int getPanelNum(DrawPanel panel) { 
        return panel.idNum; 
    }
    
    public List<List<DrawPanel>> getPanels() { return panels; }
    
    public Dimension getScaledSize() {
        int usw = panels.get(0).get(0).getSize().width;
        int ush = panels.get(0).get(0).getSize().height;
        int totalScaledWidth = (int)((double)driver.getActual().getScale() * (double)usw * (double)panels.get(0).size());
        int totalScaledHeight = (int)((double)driver.getActual().getScale() * (double)ush * (double)panels.size());
        return new Dimension(totalScaledWidth,totalScaledHeight);
    }
    
    public DrawPanel getTopLeft() { return panels.get(0).get(0); }
    
    public Dimension getUnscaledSize() {
        int usw = panels.get(0).get(0).getSize().width;
        int ush = panels.get(0).get(0).getSize().height;
        int totalUnscaledWidth = usw * panels.get(0).size();
        int totalUnscaledHeight = ush * panels.size();
        return new Dimension(totalUnscaledWidth,totalUnscaledHeight);
    }
    
    public static void main(String[] args) {
        Driver.launch();
    }
    
    public void recapture() {
        // query Scribble for current representation
    }
    
/*
    public void resetToScribble(Dimension size) {
        DrawPanel initial = new DrawPanel(driver,size.width,size.height);
        panels = new ArrayList<>();
        List<DrawPanel> strip = new ArrayList<>();
        strip.add(initial);
        panels.add(strip);
        int w = (int)((double)driver.getActual().getScale() * (double)driver.getScribble().getPanelWidth());
        int h = (int)((double)driver.getActual().getScale() * (double)driver.getScribble().getPanelHeight());
        setSize(w,h);
        driver.getScribble().setAreaRep(this);
    }
*/
    
    public void startStrokes() {
        List<DrawPanel> strip;
        for(int i = 0; i < panels.size();i++) {
            strip = panels.get(i);
            for(int j = 0; j < strip.size();j++) {
                List<Pixel> stroke = new ArrayList<>();
                strip.get(j).startStroke(stroke);
            }
        }
    }
    
}
