package ca.tecreations.apps.draw;

import ca.tecreations.Color;
import ca.tecreations.Point;
import ca.tecreations.components.Button;
import ca.tecreations.components.TFrame;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class Actual extends TFrame implements MouseListener {
    Driver driver;
    Scribble scribble;

    boolean firstRun = true;
    JPanel holder = new JPanel(null,true);
    
    Button addAreaButton = new Button();
    List<AreaRep> areas = new ArrayList<>();
    AreaRep currentArea;
    
    double scale = 0.25;
    
    
    public Actual(Driver driver, AreaRep areaRep) {
        super(driver.getProperties(),"Actual");
        this.driver = driver;
        setTitle("Actual: " + driver.getProperties());
        setExitOnClose(true);
        setVisible(true);
        currentArea = areaRep;
        areas.add(currentArea);
        setLayout(new BorderLayout());
        add(holder,BorderLayout.CENTER);
        holder.setLayout(null);
        holder.add(currentArea);
        validate();
    }

    public Point create(String direction) {
        Point p = currentArea.create(direction);
        List<List<DrawPanel>> panels = currentArea.getPanels();
        int panelNum = 0;
        for(int i = 0; i < panels.size();i++) {
            List<DrawPanel> strip = panels.get(i);
            for(int j = 0; j < strip.size();j++) {
                DrawPanel panel = strip.get(j);
                panel.setPanelNum(panelNum++);
                panel.setCoordinate(j,i);
            }
        }
        currentArea.setSize(currentArea.getScaledSize());
        return p;
    }

    public void addAddAreaButton() {
        holder.add(addAreaButton);
        holder.validate();
        addAreaButton.addMouseListener(this);
        addAreaButton.setText("Add Area");
        addAreaButton.setBackground(Color.GREY_12);
    }
    
    public void addNewArea() {
        DrawPanel areaInitial = new DrawPanel(driver,driver.getScribble().getPanelWidth(),driver.getScribble().getPanelHeight());
        AreaRep areaRep = new AreaRep(driver,areaInitial);
        currentArea = areaRep;
        driver.getScribble().setAreaRep(areaRep);
        areas.add(areaRep);
        holder.add(areaRep);
        holder.validate();
        repaint();
    }
    
    public AreaRep getCurrentArea() { return currentArea; }
    
    public double getScale() {
        return scale;
    }
    
//    public Pixel getTranslatedPixel(DrawPanel src, int srcX, int srcY) {
//        return new Pixel(Colors.PEN_COLOR, srcX,srcY);
//    }
    
    public static void main(String[] args) {
        Driver.launch();
    }
    
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == addAreaButton) {
            addNewArea();
        }
    }
    
    public void mouseEntered(MouseEvent e) {
        
    }
    
    public void mouseExited(MouseEvent e) {
        
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
        
    }
    
    public void paint(Graphics g) {
        if (firstRun && holder.getSize().width != 0) {
            addAddAreaButton();
//            addNewArea();
            addAreaButton.setLocation(holder.getSize().width - addAreaButton.getSize().width,0);
            firstRun = false;
        }
        super.paint(g);
        g = holder.getGraphics();
        for(int i = 0; i < areas.size();i++) {
            areas.get(i).repaint();
        }
        addAreaButton.repaint();
    }

    public void resetArea() {
        currentArea.setSize(currentArea.getScaledSize());
    }
    
}
