package ca.tecreations.apps.deploy;

import ca.tecreations.File;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import ca.tecreations.TextFile;
import ca.tecreations.components.SizedPanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
/**
 *
 * @author Tim de Vries
 */
public class ManifestDetail extends JPanel implements DocumentListener, ListSelectionListener {
    public static String LAUNCHER_CLASS = "ca.tecreations.Launcher";
    Deploy deployment;
    JLabel attributesLabel = new JLabel("Manifest Attributes:");
    JTextArea attributes = new JTextArea(4,40);
    JLabel mainClassLabel = new JLabel("Main Class:");
    DefaultListModel<String> mainClassModel = new DefaultListModel<>();
    JList<String> mainClassList = new JList<>(mainClassModel);
    String mainClass = "";
    ListSelectionModel listSelectionModel;
        
    public ManifestDetail(Deploy deployment) {
        super(new GridBagLayout());
        this.deployment = deployment;
        if (deployment.getProperties().wasCreated()) {
            doInitialSetup();
        } else {
            getProperties(deployment.getProperties());
        }
        setupGUI();
        populate();
        retrieveMainClass();
    }
    
    public void changedUpdate(DocumentEvent e) {
        deployment.getProperties().set(Data.MANIFEST_ATTRIBUTES, getAttributes());
    }
    
    public void disableComponent() {
        //setEnabled(false);
        attributesLabel.setEnabled(false);
        attributes.setEnabled(false);
        mainClassLabel.setEnabled(false);
        mainClassList.setEnabled(false);
    }
    
    public void doInitialSetup() {
        deployment.getProperties().set(Data.MANIFEST_ATTRIBUTES,"");
        attributes.setText("");
        populate();
        retrieveMainClass();
    }
    
    public void enableComponent() {
        // doesn't disable the tab. Look in deployment.
        //setEnabled(true);
        attributesLabel.setEnabled(true);
        attributes.setEnabled(true);
        mainClassLabel.setEnabled(true);
        mainClassList.setEnabled(true);
    }
    
    public String extractAttributes(String compact) {
        String text = "";
        StringBuffer buf = new StringBuffer();
        List<String> parts = new ArrayList<>();
        if (compact != null) {
            for(int i = 0; i < compact.length();i++) {
                if (compact.charAt(i) == ',') {
                    parts.add(buf.toString());
                    buf = new StringBuffer();
                } else buf.append(compact.charAt(i));
            }
        }
        parts.add(buf.toString());
        for(int i = 0; i < parts.size();i++) {
            text += splitWithSpace(parts.get(i)) + "\n";
        }
        return text;
    }
    
    public String getAttributes() {
        String attr = "";
        String text = attributes.getText();
        StringBuffer buf = new StringBuffer();
        char ch;
        for(int i = 0; i < text.length();i++) {
            ch = text.charAt(i);
            if (ch == '\n') {
                if (buf.toString().trim().length() > 0) {
                    attr += buf.toString().trim();
                    if (i < text.length() - 1) attr += ",";
                    buf = new StringBuffer();
                }
            } else {
                buf.append(ch);
            }
        }
        if (buf.length() > 0) {
            attr += buf.toString().trim();
        }
        return attr;
    }

    public String getMainClass() { return mainClass; }
    
    public void getMainClassesInPath(String classPath, String target) {
        //System.out.println("ManifestDetail: getMainClassesInPath: " + classPath + " Target: " + target);
        classPath = StringTool.getUnwrapped(classPath);
        target = StringTool.getUnwrapped(target);
        if (!classPath.endsWith(File.separator)) classPath += File.separator;
        if (target.startsWith("\"")) {
            target = target.substring(1,target.length() - 1);
        }
        File[] list = new File(target).listFiles();
        if (list != null) {
            for (File entry : list) {
                //System.out.println("File: " + list1.getAbsolutePath());
                if (entry.isFile() && entry.getExtension().equals("java")) {
                    //System.out.println("Class: " + clazz + " : " + hasMainMethod(clazz));
                    String name = entry.getUnwrapped();
                    if (hasMainMethod(name)) {
                        name = name.substring(classPath.length());  // drop classpath
                        name  = name.replace(File.separator.charAt(0),'.'); // convert from path parts to fqcn parts
                        name = name.substring(0,name.length() - 5); // drop .java
                        mainClassModel.addElement(name);
                    }
                }
            }
            for (File list1 : list) {
                if (list1.isDirectory()) {
                    getMainClassesInPath(classPath, list1.getAbsolutePath());
                }
            }
        }
    }
    
    public void getProperties(Properties properties) {
        properties.read(false);
        attributes.setText(extractAttributes(properties.get(Data.MANIFEST_ATTRIBUTES)));
        retrieveMainClass();
    }
    
    public boolean hasMainMethod(String path) {
        TextFile file = new TextFile(StringTool.getUnwrapped(path));
        if (file.hasMain()) return true;
        return false;
    }
 
    public void insertUpdate(DocumentEvent e) {
        deployment.getProperties().set(Data.MANIFEST_ATTRIBUTES, getAttributes());
    }

    public void newProject() {
        populate();
    }
    
    public void populate() { 
        mainClassModel.removeAllElements();
        mainClassModel.addElement("None");
        String path = ProjectPath.getProjectPath();
        getMainClassesInPath(path,path);
    }
    
    public void removeUpdate(DocumentEvent e) {
        deployment.getProperties().set(Data.MANIFEST_ATTRIBUTES, getAttributes());
    }
    
    public void retrieveMainClass() {
        mainClass = deployment.getProperties().get(Data.MAIN_CLASS);
        String mainClass = deployment.getProperties().get(Data.MAIN_CLASS);
        if (mainClass == null || mainClass.equals("null")) {
            if (mainClassModel.contains(LAUNCHER_CLASS)) {
                mainClass = LAUNCHER_CLASS;
            } else {
                mainClass = "None";
            }
        }
        mainClassList.setSelectedValue(mainClass,true);
        mainClassList.ensureIndexIsVisible(mainClassList.getSelectedIndex());
    }
    
    public void setMainClass(String fqcn) {
        mainClass = fqcn;
    }
    
    public void setProperties() {
        Properties properties = deployment.getProperties();
        properties.set(Data.MANIFEST_ATTRIBUTES, getAttributes());
        properties.set(Data.MAIN_CLASS,mainClassList.getSelectedValue());
    }
    
    public void setupGUI() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(attributesLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 4;
        c.fill = GridBagConstraints.HORIZONTAL;
        add(new JScrollPane(attributes, 
                            JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, 
                            JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS),c);
        attributes.setText(extractAttributes(deployment.getProperties().get(Data.MANIFEST_ATTRIBUTES)));
        attributes.getDocument().addDocumentListener(this);
        
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        add(new SizedPanel(20,20,getBackground()),c);
        
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.gridheight = 1;
        c.anchor = GridBagConstraints.LINE_START;
        add(mainClassLabel,c);
        
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.fill = GridBagConstraints.BOTH;
        c.weightx = 1.0;
        c.weighty = 1.0;
        add(new JScrollPane(mainClassList, 
                            JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, 
                            JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS),c);
        mainClassList.addListSelectionListener(this);
    }

    public String splitWithSpace(String token) {
        String s = "";
        for(int i = 0; i < token.length();i++) {
            if (token.charAt(i) == ':') {
                s += ": ";
            } else s += token.charAt(i);
        }
        return s;
    }
    
    public void valueChanged(ListSelectionEvent e) {
        deployment.getProperties().set(Data.MAIN_CLASS,mainClassList.getSelectedValue());
    }
}
