package ca.tecreations.apps.backup;

import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.apps.launcher.ConsolePanel;
import ca.tecreations.components.TFrame;
import ca.tecreations.text.TextPoints;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import ca.tecreations.interfaces.TextPainter;

/**
 *
 * @author Tim
 */
public class TextViewer extends TFrame {
    public static TextViewer instance;
    String absPath;
    
    JScrollPane scroller;
    ConsolePanel consolePanel = new ConsolePanel();
    
    public static int MAX_WIDTH = 256;
    public static int LINE_INDEX = 0;
    
    public TextViewer() {
        super(ProjectPath.instance.getTecPropsPath() + "TextViewer.properties","TextViewer");
        scroller = new JScrollPane(consolePanel,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        add(scroller,BorderLayout.CENTER);
    }

    public static void createAndShowGUI() {
        instance = new TextViewer();
        instance.setVisible(true);
    }
    
    public List<String> getLines(int index, int count) {
        TextScanner scanner = new TextScanner(absPath);
        return scanner.getLines(index,count);
    }
    
    
    public static void launch() {
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }
    
    public static void main(String[] args) {
        launch();
        List<String> testLines = new ArrayList<>();
        testLines.add(TextPoints.getDefaultString());
        testLines.add("Hello World!");
        while (instance == null) {
            Platform.sleep(500);
        }
        instance.setText(testLines);
        instance.setShowLineNumbers(true);
    }
    
    public void setFilename(String absPath) {
        this.absPath = absPath;
        consolePanel.setLineIndex(0);
        List<String> lines = getLines(0,consolePanel.getMaxLines());
        consolePanel.setText(lines);
    }
    
    public void setPainters(List<List<TextPainter>> painters) {
        consolePanel.setPainters(painters);
        consolePanel.setLineIndex(0);
    }
    
    public void setShowLineNumbers(boolean state) {
        consolePanel.setShowLineNumbers(state);
    }
    
    public void setText(List<String> txtLines) {
        consolePanel.setText(txtLines);
    }
    
}
