package ca.tecreations.apps.backup;

import ca.tecreations.StringTool;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Tim
 */
public class TextScanner {
    String absPath;
    
    public TextScanner(String absPath) {
        this.absPath = absPath;
    }
    
    public long getLineCount() {
        long count = 0;
        FileReader reader = null;
        LineNumberReader in = null;
        int skipped = 0;
        try {
            reader = new FileReader(StringTool.getUnwrapped(absPath));
        } catch (FileNotFoundException fnfe) {
            System.err.println("TextScanner.getLines: file not found: " + absPath);
            return -1L;
        }
        in = new LineNumberReader(reader);
        try {
            while (in.ready() && in.readLine() != null) count++;
        } catch (IOException ioe) {
            System.err.println("should be okay to delete this line...");
        }
        return count;
    }
    
    public List<String> getLines(int index, int count) {
        List<String> lines = new ArrayList<>();
        FileReader reader = null;
        LineNumberReader in = null;
        int skipped = 0;
        try {
            reader = new FileReader(StringTool.getUnwrapped(absPath));
        } catch (FileNotFoundException fnfe) {
            System.err.println("TextScanner.getLines: file not found: " + absPath);
            return null;
        }
        in = new LineNumberReader(reader);
        long position = 0;
        try {
            while (skipped < index) {
                String s = in.readLine();
                position += s.length();
                skipped++;
            }
        } catch (IOException ioe) {
            System.err.println("TextScanner.getLines: read error: position: " + position + " skipped: " + skipped);
        }
        try {
            for(int i = 0; i < count;i++) {
                lines.add(in.readLine());
            }
        } catch (IOException ioe) {
            System.err.println("TextScanner.getLines: read error: " + ioe);
        }
        try {
            in.close();
        } catch (IOException ioe) {
            System.err.println("TextScanner.getLines: unable to close: in: " + ioe);
        }
        return lines;
    }
    
    public void print(List<String> lines) {
        for(int i = 0; i < lines.size();i++) {
            System.out.println(lines.get(i));
        }
    }
    
    public static void main(String[] args) {
        //TextScanner scanner = new TextScanner("E:\\Burn_Candidate_1.tim");
        TextScanner scanner = new TextScanner("F:\\Burn_Candidate_1.tim");
        scanner.print(scanner.getLines(33892860,26));
        System.out.println("Lines: " + scanner.getLineCount());
    }
    
}
