package ca.tecreations.apps.backup;

import ca.tecreations.Color;
import ca.tecreations.Point;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.graphics.GraphicsUtil;
import ca.tecreations.graphics.Line;
import ca.tecreations.text.TextPoints;
import ca.tecreations.text.TextTokenPainter;

import java.awt.Graphics;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
/**
 *
 * @author Tim
 */
public class TabsController extends SizedPanel implements MouseListener {
    Backup backup;
    List<String> labels = new ArrayList<>();
    List<JPanel> panels = new ArrayList<>();
    List<List<Line>> lines = new ArrayList<>();
    List<TextTokenPainter> painters = new ArrayList<>();
    List<List<Point>> tabPoints = new ArrayList<>();
    
    TextPoints textPoints = TecData.ARIAL_P_12;
    int leftSpace = 5;
    int rightSpace = 5;
    int LABEL_INTERIORS = 2;
    int bottomY;
    int aboveTab;
    int tabY;
            
    String selected = null;
    int selectedIndex = 0;
    int scrolled = 0; // leftward offset
    
    public TabsController(Backup backup, int w, int h) {
        super(w,h);
        this.backup = backup;
        bottomY = getSize().height - 2;
        aboveTab = bottomY - (2 * LABEL_INTERIORS + textPoints.getFontSize());
        tabY = bottomY - aboveTab;
        addMouseListener(this);
    }
    
    public void addTab(String label, JPanel panel) {
        if (selected == null) {
            selected = label;
            selectedIndex = 0;
        }
        if (!hasLabel(label)) {
            labels.add(label);
            panels.add(panel);
            TextTokenPainter painter = new TextTokenPainter(textPoints,new TextToken(label),Color.BLACK);
            painter.setBackground(getBackground());
            painter.setBetween(2);
            painters.add(painter);

            int tabX = getTabX(label);
            
            List<Line> tLines = new ArrayList<>();
            Line left = new Line();
            left.setTranslation(tabX,bottomY);
            left.setEndPoint(leftSpace,-tabY);
            tLines.add(left);
            Line top = new Line();
            top.setTranslation(tabX + leftSpace,aboveTab);
            top.setEndPoint(painter.getTextWidth() + (2 * LABEL_INTERIORS),0);
            tLines.add(top);
            int p2x = tabX + leftSpace + painters.get(labels.size() - 1).getTextWidth() + rightSpace;
            Line right = new Line();
            right.setTranslation(p2x + (2 * LABEL_INTERIORS),bottomY);
            right.setEndPoint(-rightSpace,-tabY);
            tLines.add(right);
            lines.add(tLines);
            
            int leftMinY = left.getMinY();
            int rightMinY = right.getMinY();
            int leftMaxY = left.getMaxY();
            int rightMaxY = right.getMaxY();
            int minY = 0;
            int maxY = 0;
            List<Point> areaPoints = new ArrayList<>();
            List<Point> lPoints = Point.getSortedByY_ASCENDING(left.getTranslatedPoints());
            List<Point> tPoints = Point.getSortedByX_ASCENDING(top.getTranslatedPoints());
            List<Point> rPoints = Point.getSortedByY_ASCENDING(right.getTranslatedPoints());
            for(int i = 0;i < lPoints.size();i++) areaPoints.add(lPoints.get(i));
            for(int i = 0;i < tPoints.size();i++) areaPoints.add(tPoints.get(i));
            for(int i = 0;i < rPoints.size();i++) areaPoints.add(rPoints.get(i));
            System.out.println("Left(y) : min: " + Point.getMinY(lPoints) + " max: " + Point.getMaxY(lPoints) + " : " + lPoints);
            System.out.println("top: : " + tPoints);
            System.out.println("top : min: " + Point.getMinX(tPoints) + " max: " + Point.getMaxX(tPoints));
            System.out.println("Right: " + rPoints);
            System.out.println("_------------_");

     //       int minY = Math.min(Point.getMinY(lPoints),Point.getMinY(tPoints));
            
            int y;
            int endX;
            int index;
            for(int i = 0; i < lPoints.size();i++) {
                y = lPoints.get(i).y;
                index = lPoints.get(i).x + 1; // moving rightward
                endX = getXByY(y,rPoints);
                if (endX != -1) {
                    while (index < endX) {
                        areaPoints.add(new Point(index,y));
                        index++;
                    }
                }
            }
            tabPoints.add(areaPoints);
        }
    }
    
    public void drawTabs(Graphics g) {
        for(int i = 0; i < labels.size();i++) {
            drawTab(g,labels.get(i));
        }
    }
    
    public void drawTab(Graphics g, String text) {
        int tabIndex = getTabIndex(text);
        int tabX = getTabX(text);
        
        // do fill background :: from lines to minY and maxY, drawString and lines
        if (text.equals(selected)) {
            painters.get(tabIndex).setBackground(Color.TEC_SELECTED);
            g.setColor(Color.TEC_SELECTED);
        } else {
            painters.get(tabIndex).setBackground(getBackground());
            g.setColor(getBackground());
        }
        Point.drawPoints(g,0,0,tabPoints.get(tabIndex));
        painters.get(tabIndex).draw(g,tabX + leftSpace + LABEL_INTERIORS,bottomY - textPoints.getFontSize());
        List<Line> tLines = lines.get(tabIndex);
        for(int i = 0; i < tLines.size();i++) {
            tLines.get(i).draw(g);
        }
    }
    
    public int getTabIndex(int x, int y) {
        List<Point> forTab;
        Point p;
        for(int i = 0; i < tabPoints.size();i++) {
            forTab = tabPoints.get(i);
            for(int j = 0; j < forTab.size();j++) {
                p = forTab.get(j);
                if (p.x == x && p.y == y) {
                    return i;
                }
            }
        }
        return -1;
    }
    
    public int getTabIndex(String text) {
        for(int i = 0; i < labels.size();i++) {
            if (labels.get(i).equals(text)) return i;
        }
        return -1;
    }
    
    public int getTabWidth(int index) {
        int width = leftSpace + (2 * LABEL_INTERIORS) + rightSpace + painters.get(index).getTextWidth();
        return width;
    }
    
    public int getTabX(String label) {
        int x = 0;
        int index = 0;
        while (!labels.get(index).equals(label) && index < labels.size()) {
            x += getTabWidth(index);
            index++;
        }
        return x - scrolled;
    }
    
    public int getXByY(int y, List<Point> points) {
        for(int i = 0;i < points.size();i++) {
            if (points.get(i).y == y) return points.get(i).x;
        }
        return -1;
    }

    public boolean hasLabel(String label) {
        for(int i = 0; i < labels.size();i++) {
            if (labels.get(i).equals(label)) return true;
        }
        return false;
    }
    
    public static void main(String[] args) {
        Backup.launch();
    }

    public void mouseClicked(MouseEvent e) {
        int tabIndex = getTabIndex(e.getX(),e.getY());
        if (tabIndex != -1) {
            selected = labels.get(tabIndex);
            backup.setRightPanel(panels.get(tabIndex));
        }
    }
    
    public void mouseEntered(MouseEvent e) {
        
    }
    
    public void mouseExited(MouseEvent e) {
        
    }
    
    public void mousePressed(MouseEvent e) {
        
    }
    
    public void mouseReleased(MouseEvent e) {
        
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        int x = 0;
        for(int i = 0; i < labels.size();i++) {
            drawTabs(g);
        }
        GraphicsUtil.drawBottomHR(g, this);
    }
    
}
