package ca.tecreations.apps.backup;

import ca.tecreations.File;
import ca.tecreations.TypeToType;
import ca.tecreations.text.TextPoints;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
/**
 *
 * @author Tim
 */
public class GenerateMaxDVDSize {
    static long lineNum = 0;
    static long position = 0L;
    
    public GenerateMaxDVDSize() {
    }
    
    public static void generate(long sizeBytes,String absPath) {
        String s = "";
        for(int i = 0; i < 8;i++) {
            s += "0123456789ABCDEF";
        }
        FileOutputStream fos = null;
        BufferedOutputStream buf = null;
        try {
            fos = new FileOutputStream(absPath);
        } catch (FileNotFoundException fnfe) {
            System.err.println("File.generate: file not found: " + absPath);
        }
        buf = new BufferedOutputStream(fos);
        // determine if the next line will fit
        while (position < sizeBytes - (lineNum + 1 + ": " + s).length()) {
            lineNum++;
            byte[] bytes = TypeToType.toByteArray(lineNum + ": " + s + "\n");
            try {
                buf.write(bytes);
                position += bytes.length; // only increment on sucessful write
            } catch (IOException ioe) {
                System.err.println("File.generate: ioe: " + ioe);
            }
        }
        // do we have any space left up to the max?
        long remaining = sizeBytes - position;
        int tagLength = ": ".length();
        tagLength++; // < 10
        if (lineNum > 9) tagLength++; 
        if (lineNum > 99) tagLength++;
        if (lineNum > 999) tagLength++;
        if (lineNum > 9999) tagLength++;
        if (lineNum > 99999) tagLength++;
        if (lineNum > 999999) tagLength++;
        if (lineNum > 9999999) tagLength++;
        if (lineNum > 99999999) tagLength++;
        if (lineNum > 999999999) tagLength++;
        String lastLine = "";
        if (remaining > tagLength) {
            lastLine += lineNum + ": ";
            remaining -= lastLine.length();
            lastLine += s.substring(0,(int)remaining);
            try {
                buf.write(TypeToType.toByteArray(lastLine));
            } catch (IOException ioe) {
                System.err.println("generate: writing lastLine: " + ioe);
            }
        }
        try {
            buf.flush();
        } catch (IOException ioe){
            System.err.println("File.generate: Unable to flush: " + ioe);
        }
        try {
            buf.close();
        } catch (IOException ioe) {
            System.err.println("File.generate: Unable to close: buf: ioe: " + ioe);
        }
        try {
            if (fos != null) fos.close();
        } catch (IOException ioe) {
            System.err.println("File.generate: Unable to close: fos: ioe: " + ioe);
        }
    }
    
    public static void generateFast(long sizeMB,String absPath) {
        String _1KB = "";
        for(int i = 0; i < 64;i++) {
            _1KB += "0123456789ABCDEF";
        }
        String _1MB = "";
        for(int i = 0;i < 1024;i++) {
            _1MB += _1KB;
        }
        
        FileOutputStream fos = null;
        BufferedOutputStream buf = null;
        try {
            fos = new FileOutputStream(absPath);
        } catch (FileNotFoundException fnfe) {
            System.err.println("File.generate: file not found: " + absPath);
        }
        buf = new BufferedOutputStream(fos);
        // determine if the next line will fit
        byte[] bytes = TypeToType.toByteArray(_1MB);
        System.out.println("Writing: " + absPath);
        for(int i = 0; i < sizeMB;i++) {
            try {
                buf.write(bytes);
                buf.flush();
            } catch (IOException ioe) {
                System.err.println("File.generate: ioe: " + ioe);
            }
        }
        try {
            buf.close();
        } catch (IOException ioe) {
            System.err.println("File.generate: Unable to close: buf: ioe: " + ioe);
        }
        try {
            if (fos != null) fos.close();
        } catch (IOException ioe) {
            System.err.println("File.generate: Unable to close: fos: ioe: " + ioe);
        }
    }
    
    public static void main(String[] args) {
        File f = new File("F:\\");
        f.setName("Burn_Candidate_1.tim");
        f.delete(true);
        System.out.println("Generating in: " + f.getAbsolutePath());
        double bytes = 4.7 * Math.pow(10,9);
        generate((long)bytes,f.getAbsolutePath());
        System.out.println("f.size: " + f.getLength());
    }
}
