package ca.tecreations.apps.backup;

import ca.tecreations.File;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
/**
 *
 * @author Tim
 */
public class DriveFiller {
    String path;
    int gigaNum = 0;
    int megaNum = 0;
    boolean stillPerforming = true;
    
    public DriveFiller(String drive) {
        path = new File(drive).getUnwrapped() + "DriveFiller" + File.separator;
        File.prune(path,true);
        if (!new File(path).exists()) {
            new File(path).mkdirs();
        }
        doProcess();
    }

    public void doForGigabyte() {
        gigaNum++;
        String filename = path + "DriveFiller" + "_" + gigaNum + "GB.txt";
        GenerateMaxDVDSize.generateFast(1024,filename);
    }
    
    public void doForMegabyte() {
        megaNum++;
        String filename = path + "DriveFiller" + "_" + megaNum + "MB.txt";
        PrintWriter out = getPrintWriter(filename);
        GenerateMaxDVDSize.generateFast(1,filename);
    }
    
    public void doLast() {
        String filename = path + "DriveFiller_Last.txt";
        long usable = new File(path).getUsableSpace();
        GenerateMaxDVDSize.generate(usable,filename);
    }
    
    public void doProcess() {
        long space = new File(path).getUsableSpace();
        while (space > 0) {
            if (space > 1024 * 1024 * 1024) {
                doForGigabyte();
            } else if (space > 1024 * 1024) {
                doForMegabyte();
            } else doLast();
            space = new File(path).getUsableSpace();
        }
    }
    
    public PrintWriter getPrintWriter(String absPath) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(absPath);
        } catch (FileNotFoundException fnfe) {
            System.err.println("Programming error.");
        }
        return out;
    }
    
    public static void main(String[] args) {
        DriveFiller filler = new DriveFiller("H:");
    }
    
}
