package ca.tecreations.apps.backup;

import ca.tecreations.EnvData;
import ca.tecreations.File;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.Sort;
import ca.tecreations.StringTool;
import ca.tecreations.TecData;
import ca.tecreations.TextFile;
import ca.tecreations.apps.App;
import ca.tecreations.apps._data.FileListTransferable;
import ca.tecreations.apps._data.FileListTransferHandler;
import ca.tecreations.apps._gui.EntriesPanel;
import ca.tecreations.apps._gui.FileEntriesTable;
import ca.tecreations.components.CommandInput;
import ca.tecreations.components.JobProgressDialog;
import ca.tecreations.components.ProgressDialog;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.net.LocalTLSServer;
import ca.tecreations.net.NameService;
import ca.tecreations.net.TLSClient_TVS12;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.*;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.*;

/**
 *
 * @author tim
 */
public class Backup extends App implements DropTargetListener {
    public static LocalTLSServer localTLSServer = null;
    public static String SIMPLE_NAME = Backup.class.getSimpleName();
    public static boolean isStandalone = false;
    public static boolean startQuiet = true;
    public static String oldEnvironment = EnvData.DEV;

    public static Backup instance;
    public static ProgressDialog itemProgress;
    public static JobProgressDialog jobProgress;
    public static ProgressListener pl;
    Properties properties;
    static JSplitPane split;

    EntriesPanel left;
    TLSClient_TVS12 lClient;
    DragSource ds = new DragSource();
    //DropTarget rightDropTarget;
    //public EntriesPanel dragSrc = null;
    
    static JPanel right;
    static TabsController tabs;
    static JPanel rightHolder = new JPanel(new BorderLayout(),false);
    static JPanel rightPanel;
    
    static JPanel targetsPanel;
    static JScrollPane targetsScroller;
    static DefaultListModel<String> targetsModel = new DefaultListModel<>();
    static JList<String> targetsList = new JList<>(targetsModel);
    static JButton add = new JButton("Add");
    static JButton remove = new JButton("Remove");
    static SizedPanel spacer = new SizedPanel(10, 10);
    static JButton clear = new JButton("Clear");

    static JPanel packingListPanel = null;
    static JScrollPane packingListScroller;
    static DefaultListModel<String> packingListModel = new DefaultListModel<>();
    static JList packingListList = new JList<>(packingListModel);
    static JButton packingListExcludeName = new JButton("Exclude By Name");
    static JButton packingListExcludeExtension = new JButton("Exclude By Extension");

    static JPanel inclusionsPanel = null;
    static JScrollPane inclusionsScroller;
    static DefaultListModel<String> inclusionsModel = new DefaultListModel<>();
    static JList inclusionsList = new JList<>(inclusionsModel);
    static JButton includeName = new JButton("Name");
    static JButton includeExtension = new JButton("Extension");
    static JButton includeYear = new JButton("Year");
    static JButton includeMonth = new JButton("Month");
    static JButton includeDay = new JButton("Day");
    static JButton includeSizeGreater = new JButton("Size Greater");
    static JButton includeSizeEquals = new JButton("Size Equals");
    static JButton includeSizeLess = new JButton("Size Less");
    static JButton includeHasJVMPermissions = new JButton("JVM Permissions");
    static JButton includeHasDosAttributes = new JButton("DOS Attributes");
    static JButton includeHasPOSIXPermissions = new JButton("POSIX Permissions");
    static JButton includeHasPOSIXGroup = new JButton("POSIX Group");
    static JButton includeHasPOSIXOwner = new JButton("POSIX Owner");
    
    static JPanel exclusionsPanel = null;
    static JScrollPane exclusionsScroller;
    static DefaultListModel<String> exclusionsModel = new DefaultListModel<>();
    static JList exclusionsList = new JList<>(exclusionsModel);
    static JButton excludeName = new JButton("Name");
    static JButton excludeExtension = new JButton("Extension");
    static JButton excludeYear = new JButton("Year");
    static JButton excludeMonth = new JButton("Month");
    static JButton excludeDay = new JButton("Day");
    static JButton excludeSizeGreater = new JButton("Size Greater");
    static JButton excludeSizeEquals = new JButton("Size Equals");
    static JButton excludeSizeLess = new JButton("Size Less");
    static JButton excludeHasJVMPermissions = new JButton("JVM Permissions");
    static JButton excludeHasDosAttributes = new JButton("DOS Attributes");
    static JButton excludeHasPOSIXPermissions = new JButton("POSIX Permissions");
    static JButton excludeHasPOSIXGroup = new JButton("POSIX Group");
    static JButton excludeHasPOSIXOwner = new JButton("POSIX Owner");
    
    public static CommandInput commandInput;

    public static Map<String, TLSClient_TVS12> clients = new HashMap<>();

    EntriesPanel lastDst = null;

    public static TextFile log = null;

    JMenuBar menu = new JMenuBar();
//    static JMenuItem remove = new JMenuItem("Remove From Backup");

    public Backup() {
        super(ProjectPath.getTecPropsPath() + SIMPLE_NAME + File.separator + SIMPLE_NAME + ".properties", SIMPLE_NAME);
        if (isStandalone) {
            setExitOnClose(true);
        }
        properties = getProperties();
        System.out.println(SIMPLE_NAME + ": using properties: " + properties.getPropertiesFilename());
        setupGUI();
        setJMenuBar(menu);
        if (properties.wasCreated()) {
            storeServer(left, "localhost");
            left.setServer("localhost");
            TLSClient_TVS12 localhost = clients.get("localhost");
            while (!localhost.canConnect()) {
                Platform.sleep(250);
            }

            List<String> roots = localhost.getRoots();
            char initRoot = roots.get(0).charAt(0);
            left.setRootsQuiet();
            storeRoot(left, initRoot);

            storePath(left, "");
            left.getEntries();
        } else {
            retrieveAndValidateServerSettings();
            left.getEntries();
        }
        left.addListeners();

        lastDst = left; // set to something so we don't get NPE
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == commandInput.getTextField()
                || e.getSource() == commandInput.getGoButton()) {
            String text = commandInput.getText();
            String lower = text.toLowerCase();
            TLSClient_TVS12 client = null;
            String command = "";
            List<String> lines;
            String remainder = "";
            if (lower.startsWith("left ")) {
                remainder = lower.substring("left ".length());
                System.out.println("Remainder: " + remainder);
                if (remainder.startsWith("cmd ")) {
                    command = text.substring("cmd ".length());
                    client = left.getClient();
                    lines = client.getOutputLines(command);
                    System.out.println("Got Lines: " + lines);
                    for (int i = 0; i < lines.size(); i++) {
                        System.out.println(i + ": " + lines.get(i));
                    }
                } else if (remainder.startsWith("print ")) {
                    String name = text.substring("left print ".length());
                    System.out.println("Name : " + name);
//                    FileEntry entry = left.getEntry(name);
//                    System.out.println("Entry: " + entry.toString());
                }
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        super.componentResized(e);
        split.setDividerLocation(getSize().width / 2);
    }

    public static void createAndShowGUI() {
        instance = new Backup();
        instance.setVisible(true);
        instance.toFront();
        itemProgress = new ProgressDialog(instance);
        jobProgress = new JobProgressDialog(instance);
        Dimension size = right.getSize();
        tabs = new TabsController(instance, size.width,24);
        right.add(rightHolder,BorderLayout.CENTER);
        rightHolder.add(tabs,BorderLayout.NORTH);
        rightHolder.add(getTargetsPanel(),BorderLayout.CENTER);
        right.validate();
        tabs.addTab("Targets", getTargetsPanel());
        tabs.addTab("Packing List", getPackingListPanel());
        tabs.addTab("Inclusions",getInclusionsPanel());
        tabs.addTab("Exclusions",getExclusionsPanel());
        setRightPanel(targetsPanel);
        System.out.println("---------------------------------");
        printDebug();
        setRightPanel(packingListPanel);
        printDebug();
        setRightPanel(exclusionsPanel);
        printDebug();
        setRightPanel(inclusionsPanel);
        printDebug();
        
    }

    public void doDrop(DropTargetDropEvent dtde, List<String> names) {
//        String logsPath = pp.getProjectPath() + "logs" + File.separator;
//        if (!new File(logsPath).exists()) {
//            File.mkdirs(logsPath);
//        }
//        log = new TextFile(File.getNextFileName(pp.getProjectPath() + "logs" + File.separator + SIMPLE_NAME + "_log.txt"), true);
//        System.out.println("Using log: " + log.getAbsolutePath());

        // names are sorted previously when getting the selection
//        EntriesPanel src = dragSrc;
//        lastDst = dst.getEntriesPanel();
//        TLSClient srcClient = src.getClient();
        //TLSClient dstClient = lastDst.getClient();
        int row = targetsList.locationToIndex(dtde.getLocation());

        if (row == -1) {
            row = 0;
        }

//        srcClient.log = log;
//        dstClient.log = log;
//        clients.get("localhost").log = log;
//        doLogAction("Row: " + row);
//        doLogAction(SIMPLE_NAME + ": doDrop: src: " + dragSrc.getId());
        if (dtde.getDropAction() == DnDConstants.ACTION_COPY
                || dtde.getDropAction() == DnDConstants.ACTION_MOVE) {
            String server = left.getServer();
            if (targetsModel.isEmpty()) {
                for (int i = 0; i < names.size(); i++) {
                    // if (!target.contains(names.get(i))
                    targetsModel.addElement(server + " : " + names.get(i));
                    System.out.println("added: " + (row + i) + ":: " + server + " : " + names.get(i));
                }

            } else {
                for (int i = 0; i < names.size(); i++) {
                    targetsModel.insertElementAt(server + " : " + names.get(i), row + i);
                    System.out.println("inserted: " + (row + i) + ":: " + server + " : " + names.get(i));
                }
                // check if (inserted path < stored path){remove stored path}
            }
        }
        Enumeration<String> elements = targetsModel.elements();
        while (elements.hasMoreElements()) {
            System.out.println("targets: " + elements.nextElement());
        }
    }

    public void doLogAction(String msg) {
        if (log != null) {
            log.add(msg);
        } else {
            System.out.println(msg);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    @SuppressWarnings("unchecked")
    public void drop(DropTargetDropEvent dtde) {
        boolean canDrop = true;
        Component dst = dtde.getDropTargetContext().getComponent();
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            if (dst instanceof FileEntriesTable) {
                ((FileEntriesTable) dst).getTable();
            }
            for (int i = 0; i < flavors.length; i++) {
                if (flavors[i].equals(FileListTransferable.getListFlavor())) {
                    List<String> list = (List<String>) tr.getTransferData(flavors[i]);
                    if (canDrop) {
                        dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
                        doDrop(dtde, list);
                        dtde.dropComplete(true);
                        return;
                    }
                }
            }
            dtde.rejectDrop();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static JPanel getExclusionsPanel() {
        if (exclusionsPanel == null) {
            exclusionsPanel = new JPanel(new BorderLayout(), false);
            exclusionsScroller = new JScrollPane(exclusionsList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            exclusionsPanel.add(exclusionsScroller, BorderLayout.CENTER);
            JPanel controlsHolder = new JPanel(new BorderLayout(), false);
            JPanel controls = new JPanel(new GridLayout(12, 1), false);
            controls.add(excludeName);
            controls.add(excludeExtension);
            controls.add(excludeYear);
            controls.add(excludeMonth);
            controls.add(excludeDay);
            controls.add(excludeSizeGreater);
            controls.add(excludeSizeEquals);
            controls.add(excludeSizeLess);
            controls.add(excludeHasJVMPermissions);
            controls.add(excludeHasDosAttributes);
            controls.add(excludeHasPOSIXPermissions);
            controls.add(excludeHasPOSIXGroup);
            controls.add(excludeHasPOSIXOwner);
            controlsHolder.add(controls, BorderLayout.NORTH);
            exclusionsPanel.add(controlsHolder, BorderLayout.EAST);

            excludeName.addActionListener(instance);
            excludeExtension.addActionListener(instance);
            excludeYear.addActionListener(instance);
            excludeMonth.addActionListener(instance);
            excludeDay.addActionListener(instance);
            excludeSizeGreater.addActionListener(instance);
            excludeSizeEquals.addActionListener(instance);
            excludeSizeLess.addActionListener(instance);
            excludeHasJVMPermissions.addActionListener(instance);
            excludeHasDosAttributes.addActionListener(instance);
            excludeHasPOSIXPermissions.addActionListener(instance);
            excludeHasPOSIXGroup.addActionListener(instance);
            excludeHasPOSIXOwner.addActionListener(instance);
        }
        return exclusionsPanel;
    }

    public void getFileList(List<String> sources, String path) {
        File f = new File(path);
        File[] list = f.listFiles();
        List<String> files = new ArrayList<>();
        List<String> dirs = new ArrayList<>();
        for (int i = 0; i < list.length; i++) {
            if (list[i].isFile()) {
                files.add(list[i].getAbsolutePath());
            } else {
                dirs.add(list[i].getAbsolutePath());
            }
        }
        files = Sort.sort(files);
        dirs = Sort.sort(dirs);
        for (int i = 0; i < files.size(); i++) {
            sources.add(files.get(i));
        }
        for (int i = 0; i < dirs.size(); i++) {
            getFileList(sources, dirs.get(i));
        }
    }

    public EntriesPanel getLeft() {
        return left;
    }

    public static JPanel getInclusionsPanel() {
        if (inclusionsPanel == null) {
            inclusionsPanel = new JPanel(new BorderLayout(), false);
            inclusionsScroller = new JScrollPane(inclusionsList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            inclusionsPanel.add(inclusionsScroller, BorderLayout.CENTER);
            JPanel controlsHolder = new JPanel(new BorderLayout(), false);
            JPanel controls = new JPanel(new GridLayout(12, 1), false);
            controls.add(includeName);
            controls.add(includeExtension);
            controls.add(includeYear);
            controls.add(includeMonth);
            controls.add(includeDay);
            controls.add(includeSizeGreater);
            controls.add(includeSizeEquals);
            controls.add(includeSizeLess);
            controls.add(includeHasJVMPermissions);
            controls.add(includeHasDosAttributes);
            controls.add(includeHasPOSIXPermissions);
            controls.add(includeHasPOSIXGroup);
            controls.add(includeHasPOSIXOwner);
            controlsHolder.add(controls, BorderLayout.NORTH);
            inclusionsPanel.add(controlsHolder, BorderLayout.EAST);
            
            includeName.addActionListener(instance);
            includeExtension.addActionListener(instance);
            includeYear.addActionListener(instance);
            includeMonth.addActionListener(instance);
            includeDay.addActionListener(instance);
            includeSizeGreater.addActionListener(instance);
            includeSizeEquals.addActionListener(instance);
            includeSizeLess.addActionListener(instance);
            includeHasJVMPermissions.addActionListener(instance);
            includeHasDosAttributes.addActionListener(instance);
            includeHasPOSIXPermissions.addActionListener(instance);
            includeHasPOSIXGroup.addActionListener(instance);
            includeHasPOSIXOwner.addActionListener(instance);
        }
        return inclusionsPanel;
    }

    public JobProgressDialog getJobProgressDialog() {
        return jobProgress;
    }

    public static JPanel getPackingListPanel() {
        if (packingListPanel == null) {
            packingListPanel = new JPanel(new BorderLayout(), false);
            packingListScroller = new JScrollPane(packingListList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            packingListPanel.add(packingListScroller, BorderLayout.CENTER);
            JPanel controlsHolder = new JPanel(new BorderLayout(), false);
            JPanel controls = new JPanel(new GridLayout(4, 1), false);
            controls.add(packingListExcludeName);
            controls.add(packingListExcludeExtension);
            controlsHolder.add(controls, BorderLayout.NORTH);
            packingListPanel.add(controlsHolder, BorderLayout.EAST);
        }
        return packingListPanel;
    }

    public ProgressDialog getProgressDialog() {
        return itemProgress;
    }

    public static Properties getPropertiesFor(String tag) {
        return new Properties(getPropertiesFilenameForClient(tag));
    }

    public static String getPropertiesFilenameForClient(String id) {
        return ProjectPath.getTecPropsPath() + "NetworkConfig" + File.separator + id + "_client.properties";
    }

    public String getRemoteHostFromPropertiesFilename() {
        String propsFilename = properties.getPropertiesFilename();
        String name = new File(propsFilename).getName();
        String host = name.substring(0, name.indexOf("_"));
        return host;
    }

    public static List<String> getServerLabels() {
        NameService ns = NameService.getInstance();
        List<String> labels = new ArrayList<>();
        String host = "localhost";
        labels.add(host); // add the local machines network connection

        String localhostIP = ns.getLocalhostIPAddress();
        if (localhostIP.equals("192.168.1.49")) {
            labels.add("Living Room");
        }
        if (localhostIP.equals("192.168.1.139")) {
            labels.add("Office");
        }

        labels.add("tecreations.ca");

        return labels;
    }

    public String getStoredPath(EntriesPanel side) {
        String stored = "getStoredPat: " + TecData.UNSET_S;
        Character rootChar = left.getRootChar();
        if (rootChar != null) {
            stored = properties.get(left.getServer() + ".l." + rootChar + ".path");
        }
        return stored;
    }

    public Character getStoredRoot(EntriesPanel side) {
        String stored = TecData.UNSET_S;
        if (side == left) {
            stored = properties.get(left.getServer() + ".l.root");
        }
        //System.err.println("GetStoredRoot: " + stored);
        if (stored == null) {
            // no data
            List<String> roots;
            if (side == left) {
                left.setRootsQuiet();
                stored = left.getRoot();
            }
            if (stored != null) {
                storeRoot(side, stored.charAt(0));
            }
        }
        return (stored == null ? null : stored.charAt(0));
    }

    public String getStoredServer(EntriesPanel side) {
        String storedServer = TecData.UNSET_S;
        if (side == left) {
            storedServer = properties.get("l.host");
        }
        if (storedServer == null) {
            storedServer = "localhost";
        }
        return storedServer;
    }

    public static JPanel getTargetsPanel() {
        if (targetsPanel == null) {
            targetsPanel = new JPanel(new BorderLayout(), false);
            targetsScroller = new JScrollPane(targetsList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            targetsPanel.add(targetsScroller, BorderLayout.CENTER);
            JPanel controlsHolder = new JPanel(new BorderLayout(), false);
            JPanel controls = new JPanel(new GridLayout(4, 1), false);
            controls.add(add);
            controls.add(remove);
            controls.add(spacer);
            controls.add(clear);
            controlsHolder.add(controls, BorderLayout.NORTH);
            targetsPanel.add(controlsHolder, BorderLayout.EAST);
        }
        return targetsPanel;
    }

    public String getTempDir(TLSClient_TVS12 localClient, long jobSize) {
        String tempDir = "";
        List<String> roots = localClient.getRoots();
        int i = 0;
        long usable = 0L;
        while (tempDir.equals("") && i < roots.size()) {
            String unwrappedRoot = StringTool.getUnwrapped(roots.get(i));
            usable = Long.parseLong(localClient.getUsableSpace(roots.get(i)));
            if (usable >= jobSize) {
                tempDir = unwrappedRoot + "temp" + localClient.getFileSeparator();
            }
            i++;
        }
        return tempDir;
    }

    public TLSClient_TVS12 getTLSClient(String host) {
        return clients.get(host);
    }

    public boolean inList(String target, List<String> items) {
        for (int i = 0; i < items.size(); i++) {
            if (items.get(i).equals(target)) {
                return true;
            }
        }
        return false;
    }

    public static void launch() {
        isStandalone = true;
        NameService ns = NameService.instance;
        startServer();
        if (ns.getProperties().wasCreated()) {

        }
        List<String> labels = getServerLabels();
        for (int i = 0; i < labels.size(); i++) {
            String tag = ns.getPropertiesTag(labels.get(i));
            //System.out.println("Label: " + labels.get(i) + " Tag: " + tag);
            TLSClient_TVS12 client = new TLSClient_TVS12(getPropertiesFor(tag));
            if (startQuiet) {
                client.setEnvironment(EnvData.PROD);
            }
            clients.put(labels.get(i), client);

        }
        SwingUtilities.invokeLater(() -> {
            createAndShowGUI();
        });
    }

    public static void main(String[] args) {
        launch();
    }

    public static void printDebug() {
        System.out.println("targets Parent     : " + (targetsPanel.getParent() == rightHolder));
        System.out.println("packingLists Parent: " + (packingListPanel.getParent() == rightHolder));
        System.out.println("inclusions Parent  : " + (inclusionsPanel.getParent() == rightHolder));
        System.out.println("exclusions Parent  : " + (exclusionsPanel.getParent() == rightHolder));
        System.out.println("Targets            : " + targetsPanel);
        System.out.println("PackingList        : " + packingListPanel);
        System.out.println("Inclusions         : " + inclusionsPanel);
        System.out.println("Exclusions         : " + exclusionsPanel);
    }
    
    public void refreshLast() {
        lastDst.getEntries();
    }

    public void retrieveAndValidateServerSettings() {
        String storedServer = getStoredServer(left);
        //System.out.println("FileTool.retrieveAndValidate... : storedServer: " + storedServer);

        // stores the server by name
        left.setServer(storedServer);

        lClient = left.getTLSClient();
        Character storedRoot = null;
        if (lClient.canConnect() != null && lClient.canConnect()) {
            left.setRootsQuiet();
            storedRoot = getStoredRoot(left);
            if (storedRoot != null) {
                left.setRoot(storedRoot);
                if (!left.hasRoot(storedRoot)) {
                    Character rootChar = left.getRootChar();
                    if (rootChar != null) {
                        storeRoot(left, rootChar);
                        storePath(left, "");
                    }
                } else {
                    left.setPath(getStoredPath(left));
                    if (!lClient.exists(left.getSelectedPath())) {
                        storePath(left, "");
                    }
                }
            }
        }

    }

    public void setDragSource(EntriesPanel panel) {
        dragSrc = panel;
    }

    public void setProgress(ProgressListener progress) {
        pl = progress;
    }

    public static void setRightPanel(JPanel panel) {
        if (rightPanel != null) rightHolder.remove(rightPanel);
        rightHolder.add(panel,BorderLayout.CENTER);
        rightHolder.validate();
        rightPanel = panel;
        instance.repaint();
    }
    
    public void setupDND() {
        // drag and drop
        FileEntriesTable lEntries = left.getTable();
        lEntries.setDragEnabled(true);

        lEntries.setTransferHandler(new FileListTransferHandler());

        ds.createDefaultDragGestureRecognizer(lEntries, DnDConstants.ACTION_COPY_OR_MOVE, new DragGestureListener() {
            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    List<String> selection = left.getSelection();
                    if (selection.size() > 0) {
                        ds.startDrag(dge, null, new FileListTransferable(selection), new DragSourceListener() {
                            @Override
                            public void dragEnter(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dragOver(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dropActionChanged(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dragExit(DragSourceEvent dse) {
                            }

                            @Override
                            public void dragDropEnd(DragSourceDropEvent dsde) {
                                setCursor(Cursor.getDefaultCursor());
                            }
                        });
                    }
                } catch (InvalidDnDOperationException idndoe) {
                    System.out.println(">>> Invalid drag state: already started. Ignoring.");
                }
            }
        });

        new DropTarget(targetsList, this);
        targetsList.setDropMode(DropMode.ON_OR_INSERT);

    }

    public void setupGUI() {
        setTitle(SIMPLE_NAME);
        split = new JSplitPane();
        List<String> serverLabels = getServerLabels();
        left = new EntriesPanel(this, "LEFT", 1, 1);
        left.setServerLabels(serverLabels);

        right = new JPanel(new BorderLayout(),false);
        split.setLeftComponent(left);
        split.setRightComponent(right);
        add(split, BorderLayout.CENTER);
        split.setDividerLocation(getSize().width / 2);
        //split.setDividerLocation((getSize().width / 2) - (split.getSize().width / 2));
        commandInput = new CommandInput(this);
        add(commandInput, BorderLayout.SOUTH);
        commandInput.getTextField().addActionListener(this);
        commandInput.getGoButton().addActionListener(this);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        validate();
        setupDND();
    }

    public static void startServer() {
        //Properties properties = new Properties(ProjectPath.getTecPropsPath() + "LocalTLSServer.properties");
        try {
            localTLSServer = new LocalTLSServer();
        } catch (Exception e) {
            System.out.println("Server already running...");
        }
    }

    public void storePath(EntriesPanel side, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (side == left) {
            properties.set(left.getServer() + ".l." + left.getRootChar() + ".path", path);
        }
    }

    public void storeRoot(EntriesPanel side, char root) {
        if (side == left) {
            properties.set(left.getServer() + ".l.root", root);
        }
    }

    public void storeServer(EntriesPanel side, String host) {
        if (side == left) {
            properties.set("l.host", host);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (pl != null) {
            pl.toFront();
        }
    }

}
