package ca.tecreations.apps._gui.renderer;

import ca.tecreations.Color;
import ca.tecreations.apps.launcher.Runtime;

import java.awt.Component;
import java.net.URL;

import javax.swing.*;
import javax.swing.table.*;

/**
 *
 * @author tim
 */
public class RHRenderer extends JLabel implements TableCellRenderer {

    static ImageIcon startIcon = null;
    static ImageIcon stopIcon = null;

    public RHRenderer() {
        setHorizontalAlignment(SwingConstants.RIGHT);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        Runtime runtime = (Runtime) value;
        if (runtime != null) {
            String text = "" + runtime.getPID();
            setText(text);
            if (runtime.isSelected()) {
                setOpaque(true);
                setBackground(Color.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
        }
        setForeground(Color.black);
        return this;
    }

}
