package ca.tecreations.apps._gui.renderer;

import ca.tecreations.Color;
import ca.tecreations.FileEntry;

import java.awt.Component;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author tim
 */
public class FileDateRenderer extends JLabel implements TableCellRenderer {
    
    public FileDateRenderer() {
        setHorizontalAlignment(SwingConstants.CENTER);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        FileEntry entry = (FileEntry) value;
        if (entry != null) {
            setText(entry.getLastModified());
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(Color.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
        }
        return this;
    }

}
