package ca.tecreations.apps._gui.renderer;

import ca.tecreations.Color;
import ca.tecreations.FileEntry;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

/** 
 *
 * @author tim
 */
public class FileAttributesRenderer extends JLabel implements TableCellRenderer {

    public FileAttributesRenderer() {
        setHorizontalAlignment(SwingConstants.CENTER);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
            boolean hasFocus, int row, int column) {
        FileEntry entry = (FileEntry) value;
        setForeground(Color.TEC_PURPLE);
        if (entry != null) {
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(Color.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
            setText(entry.getDOSAttributes());
        }
        return this;
    }

}
