package ca.tecreations.apps._gui.renderer;

import ca.tecreations.Color;
import ca.tecreations.FileEntry;

import java.awt.Component;

import javax.swing.*;
import javax.swing.table.*;

/**
 *
 * @author tim
 */
public class AppAccessRenderer extends JLabel implements TableCellRenderer {

    public AppAccessRenderer() {
        setHorizontalAlignment(SwingConstants.CENTER);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, 
            boolean isSelected, boolean hasFocus, int row, int column) {
        FileEntry entry = (FileEntry) value;
        if (entry != null) {
            setText(entry.getAppPermissions());
            if (entry.isSelected()) {
                setOpaque(true);
                setBackground(Color.TEC_SELECTED);
            } else {
                setOpaque(false);
                setBackground(table.getBackground());
            }
        }
        // so now JLabel doesn't allow multi-colored text, so this is another 
        // good candidate for TextTokenPainter where the token is the particular
        // access permission, red for not allowed, tec_light_green for allowable
        super.setForeground(Color.TEC_ORANGE);
        return this;
    }

}
