package ca.tecreations.apps._gui;

import ca.tecreations.FileEntry;
import ca.tecreations.apps._gui.renderer.*;

import java.util.List;
 
import javax.swing.*;
import javax.swing.table.*;

/**
 *
 * @author tim
 */
public class FileEntriesTable extends JTable {
    String side;
    EntriesPanel panel;
    
    JComboBox server;
    JComboBox root;
    JTextField path;
    
    static FileTypeRenderer fileTypeRenderer = new FileTypeRenderer();
    static FileSizeRenderer sizeRenderer = new FileSizeRenderer();
    static AppAccessRenderer appPermsRenderer = new AppAccessRenderer();
    static FileDateRenderer dateRenderer = new FileDateRenderer();
    
    static FileAttributesRenderer winPermsRenderer = new FileAttributesRenderer();
    
    static ModifiableTextRenderer defaultTextRenderer = new ModifiableTextRenderer();
    static FilePermissonsRenderer unixPermsRenderer = new FilePermissonsRenderer();
    
    int[] columnWidths;

    public FileEntriesTable(String side, EntriesPanel panel, JComboBox server, JComboBox root, JTextField path) {
        super(null);
        this.side = side;
        this.panel = panel;
        this.server = server;
        this.root = root;
        this.path = path;
    }
    
    public FileEntriesTableModel getBaseTableModel() {
        if (getModel() instanceof FileEntriesTableModel) {
            return (FileEntriesTableModel)getModel();
        }
        return null;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return fileTypeRenderer;
        } else if (column == 1) {
            return sizeRenderer;
        } else if (column == 2) {
            return appPermsRenderer;
        } else if (column == 3) {
            return dateRenderer;
        } else {
            boolean isNix = ((String)root.getSelectedItem()).contains("/");
            if (isNix) {
                if (column == 4) {
                    return defaultTextRenderer;
                } else if (column == 5) {
                    return defaultTextRenderer;
                } else {
                    return unixPermsRenderer;
                }
            } else {
                return winPermsRenderer;
            }
        }
    }

    public int getColumnWidth(int index) {
        return getColumnModel().getColumn(index).getWidth();
    }
    
    public int[] getColumnWidths() { return columnWidths; }
    
    public String getCurrentPath() {
        return (String) root.getSelectedItem() + path.getText();
    }

    public List<FileEntry> getEntries() {
        return getBaseTableModel().getEntries();
    }

    public EntriesPanel getEntriesPanel() { 
        return panel; 
    }
    
    public String getHost() {
        return (String) server.getSelectedItem();
    }

    public String getFileSeparator() {
        if (((String)root.getSelectedItem()).contains("/")) return "/";
        else return "\\";
    }
    
    public String getPathSeparator() {
        if (((String)root.getSelectedItem()).contains("/")) return ":";
        else return ";";
    }
    
    @Override
    public boolean getScrollableTracksViewportWidth() {
        return getRowCount() == 0 ? super.getScrollableTracksViewportWidth()
            : getPreferredSize().width < getParent().getWidth();
    }    
    
    public List<String> getSelection() {
        return getBaseTableModel().getSelection();
    }

    public List<String> getSelectedPaths() {
        return panel.getSelectedPaths();
    }
    
    public String getServer() { 
        return (String)server.getSelectedItem();
    }

    public String getSide() {
        return side; 
    }
    
    public int getStoredColumnWidth(int index) {
        return columnWidths[index];
    }
    
    public FileEntriesTable getTable() { return this; }

    public void setColumnWidth(int index, int width) {
        columnWidths[index] = width;
        getColumnModel().getColumn(index).setWidth(width);
        getColumnModel().getColumn(index).setPreferredWidth(width);
    }
    
    public void setColumnWidths(int[] widths) {
        TableColumnModel columnModel = getColumnModel();
        columnWidths = widths;
        for(int i = 0; i < widths.length;i++) {
            columnModel.getColumn(i).setWidth(widths[i]);
            columnModel.getColumn(i).setPreferredWidth(widths[i]);
            columnModel.getColumn(i).setMinWidth(widths[i]);
        }
    } 
    
    public void setSide(String side) {
        this.side = side;
    }
    
    public String toString() { return "Side: " + side + ", Server: " + getServer() + ", Path: " + getCurrentPath() + ", Java: " + super.toString(); }
    
}
