package ca.tecreations.apps._gui;

import ca.tecreations.EnvData;
import ca.tecreations.File;
import ca.tecreations.FileEntry;
import ca.tecreations.Pair;
import ca.tecreations.Platform;
import ca.tecreations.ProjectPath;
import ca.tecreations.Properties;
import ca.tecreations.StringTool;
import ca.tecreations.SystemTool;
import ca.tecreations.TecData;
import ca.tecreations.TextToken;
import ca.tecreations.apps.*;
import ca.tecreations.apps._actions.*;
import ca.tecreations.apps._data.*;
import ca.tecreations.apps.filetool.Cleaner;
import ca.tecreations.apps.filetool.FileTool;
import ca.tecreations.components.GetString;
import ca.tecreations.components.OutputWindow;
import ca.tecreations.components.SizedPanel;
import ca.tecreations.components.YesNoDialog;
import ca.tecreations.net.Internet;
import ca.tecreations.net.NameService;
import ca.tecreations.net.NoTLSConnectionException;
import ca.tecreations.net.PKIData;
import ca.tecreations.net.ServerOps;
import ca.tecreations.net.TLSClient_TVS12;
import ca.tecreations.text.SystemTokenPainter;
import ca.tecreations.text.TextPoints;

import java.awt.*;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;

/**
 *
 * @author tim
 */ 
public class EntriesPanel extends SizedPanel implements ActionListener, DataRetrievalListener,
        MouseListener, MouseMotionListener {
    public static final SystemTool systemTool = new SystemTool();
    public static List<EntriesPanel> panels = null;
    static {
        if (panels == null) {
            panels = new ArrayList<>();
        }
    }
    App app;
    String id;
    JScrollPane scroller;
    SizedPanel holder;
    FileEntriesTable table;
    FileEntriesTableModel model;

    DragSource ds = new DragSource();

    TLSClient_TVS12 client;
 
    JComboBox<String> servers = new JComboBox<>();
    JComboBox<String> roots = new JComboBox<>();
    JPanel pathLine = new JPanel(new BorderLayout(0, 0));
    JTextField path = new JTextField(64);
    JPanel buttons = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
    UpDirButton upDir;
    RefreshButton refresh;
    EnvButton env;
    ScreenshotButton screenshot;
    
    SizeGetterLauncher sizeGetter;

    boolean quiet = false;

    FileEntry entry = null; // for when using the popup menu on an item
    JMenuItem view = new JMenuItem("View");
    JMenuItem clean = new JMenuItem("Clean");
    JMenuItem compile = new JMenuItem("Compile");
    JMenuItem edit = new JMenuItem("Edit...");
    JMenuItem find = new JMenuItem("Find...");
    JMenuItem replace = new JMenuItem("Replace...");
    JMenuItem newFile = new JMenuItem("New File...");
    JMenuItem newFolder = new JMenuItem("New Folder...");
    JMenuItem rename = new JMenuItem("Rename...");
    JMenuItem delete = new JMenuItem("Delete");
    JMenuItem add = new JMenuItem("Add To Backup");
    JMenuItem remove = new JMenuItem("Remove From Backup");
    JMenuItem targets = new JMenuItem("Backup Targets...");
    List<String> backupTargets = new ArrayList<>();
    
    boolean controlDown = false;
    boolean shiftDown = false;
    
    JPopupMenu popup = new JPopupMenu();
 
    int firstIndex = -1;
    int lastIndex = -1;
    int lastSet = -1;
    int row = -1;
    int col = -1;
    
    boolean changing = false;
    
    public boolean firstRun = true;
    
    public boolean debugProcessing = false;
    public boolean debugGetSizes = true;
    
    String oldEnv = "PROD";
    boolean debug = true;
    
    public EntriesPanel() {
        super(1,1);
    }
    
    public EntriesPanel(App app, String id, int w, int h) {
        super(w, h);
        panels.add(this);
        this.app = app;
        this.id = id;
        upDir = new UpDirButton();
        refresh = new RefreshButton();
        screenshot = new ScreenshotButton();
        if (debug) {
            env = new EnvButton();
        }
        table = new FileEntriesTable(id, this, servers, roots, path);
        table.setSide(id);
        setupGUI();
        setupDND();
    }

    public EntriesPanel(App app, int w, int h) {
        super(w, h);
        panels.add(this);
        this.app = app;
        upDir = new UpDirButton();
        refresh = new RefreshButton();
        screenshot = new ScreenshotButton();
        if (debug) {
            env = new EnvButton();
        }
        table = new FileEntriesTable(id, this, servers, roots, path);
        table.setSide(id);
        setupGUI();
        setupDND();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == servers) {
            quiet = true;
            operateServers();
            quiet = false;
            changing = true;
        } else if (e.getSource() == roots) {
            if (!quiet) {
                operateRoots();
            }
            changing = true;
        } else if (e.getSource() == path) {
            setSubPath(path.getText());
            changing = true;
            getEntries();
        } else if (e.getSource() == clean) {
            System.err.println("EntriesPanel.actionPerformed: clean");
            List<String> cleanTypes = new ArrayList<>();
            cleanTypes.add("class");
            cleanTypes.add("o");
            if (entry != null) {
                if (entry.isDirectory()) {
                    new Cleaner(app,client,getSelectedPath() + entry.getName(),cleanTypes);
                } else {
                    new Cleaner(app,client,getSelectedPath(),cleanTypes);
                }
            } else {
                new Cleaner(app,client,getSelectedPath(),cleanTypes);
            }
        } else if (e.getSource() == compile) {
            System.err.println("EntriesPanel.actionPerformed: compile");
            String pkg = getPackageForCurrentDir();
            String subPath = "";
            System.err.println("Package: " + pkg);
            if (pkg.contains(".")) {
                subPath = StringTool.replaceAll(pkg + ".",".",client.getFileSeparator());
            } else {
                subPath = pkg + client.getFileSeparator();
            }
            String path = getSelectedPath();
            String projectPath = path.substring(0,path.indexOf(subPath));
            System.err.println("Project Path: " + projectPath);
            System.err.println("Package   : " + pkg);
            OutputWindow output = new OutputWindow(client,app.getName());
            output.setVisible(true);
            client.setServerDebug(false);
            client.build(projectPath,pkg);
            while (!client.doneBuilding()) { Platform.sleep(1000); }
            output.setVisible(false);
            app.refreshLast();
        } else if (e.getSource() == find) {
/*
            } else if (e.getSource() == newFile) {
            GetString getter = new GetString(app);
            while (getter.isVisible()) {
                Platform.sleep(125);
            }
            int invalid = isValidFileNameChar(getter.getText());
            if (invalid != -1) {
                Platform.message(app, "Invalid character in file name: " + invalid);
            } else {
                String path = StringTool.getDoubleQuoted(getSelectedPath() + getter.getText() + client.getFileSeparator());
                TextFile textFile = new TextFile(path);
                textFile.write();
                getEntries();
            }
*/
        } else if (e.getSource() == newFolder) {
            GetString getter = new GetString(app,"Enter a folder name...");
            getter.setModal(true);
            getter.setVisible(true);
            while (getter.isVisible()) {
                Platform.sleep(125);
            }
            int invalid = File.isValidFileNameChars(client.getFileSeparator(),getter.getText());
            if (invalid != -1) {
                Platform.message(app, "Invalid character in folder name: " + invalid);
            } else {
                String folderName = getter.getText();
                String path = StringTool.getDoubleQuoted(getSelectedPath() + folderName + client.getFileSeparator());
                if (!client.exists(path)) {
                    client.mkdirs(path);
                    getEntries();
                } else {
                    Platform.message(app,"Folder exists: " + folderName);
                }
            }
        } else if (e.getSource() == rename) {
            String oldName = entry.getName();
            File oldFile = new File(oldName);
            GetString getter = new GetString(app, "Rename");
            getter.setText(oldFile.getName());
            getter.setModal(true);
            getter.setVisible(true);
            while (getter.isVisible()) {
                Platform.sleep(125);
            }
            int invalid = File.isValidFileNameChars(client.getFileSeparator(),getter.getText());
            if (invalid != -1) {
                Platform.message(app, "Invalid character in path: " + invalid + " at position: " + getter.getText().indexOf(invalid));
            } else {
                String unwrapped = oldFile.getDeepestDirectory().getParent().getUnwrapped();
                if (client.isDirectory(unwrapped)) {
                    unwrapped += getter.getText() + client.getFileSeparator();
                } else {
                    unwrapped = oldFile.getDeepestDirectory().getUnwrapped() + getter.getText();
                }
                String wrapped = StringTool.getDoubleQuoted(unwrapped);
                if (!unwrapped.equals("")) {
                    if (!client.exists(wrapped)) {
                        client.rename(oldName, wrapped);
                        entry.setName(wrapped);
                        getEntries();
                    } else {
                        if (unwrapped.endsWith("/") | unwrapped.endsWith("\\")) {
                            Platform.message(app,"Folder Exists: " + getter.getText());
                        } else {
                            Platform.message(app,"File Exists: " + getter.getText());
                        }
                    }
                }
            }
        } else if (e.getSource() == delete) {
            List<String> selection = model.getSelection();
            String sel = "";
            for (int i = 0; i < selection.size() - 1; i++) {
                sel += selection.get(i);
                if (selection.size() > 1) sel += ", \n";
            }
            sel += selection.get(selection.size() - 1) + "\n";
            YesNoDialog dialog = Platform.confirm(app, "Delete: " + sel + " : Y/N?");
            dialog.setTitle("Confirm deletion...");
            while (dialog.isVisible()) {
                Platform.sleep(125);
            }
            if (dialog.isYes()) {
                for (int i = 0; i < selection.size(); i++) {
                    delete(selection.get(i));
                }
                getEntries();
            }
        }
    }

    public void addButtons() {
        buttons.add(upDir);
        buttons.add(refresh);
        buttons.add(screenshot);
    }

    public void addButtons_Env() {
        buttons.add(env);
    }
    
    public void addListeners() {
        servers.addActionListener(this);
        roots.addActionListener(this);
        roots.addMouseListener(this);
        path.addActionListener(this);
        table.addMouseListener(this);
        table.addMouseMotionListener(this);
        upDir.addMouseListener(this);
        refresh.addMouseListener(this);
//        screenshot.addMouseListener(this);
        env.addMouseListener(this);
        find.addActionListener(this);
//        buildHere.addActionListener(this);
//        buildFromHere.addActionListener(this);
//        cleanHere.addActionListener(this);
//        cleanFromHere.addActionListener(this);
//        runJava.addActionListener(this);
        newFile.addActionListener(this);
        newFolder.addActionListener(this);
        rename.addActionListener(this);
        delete.addActionListener(this);
        clean.addActionListener(this);
        compile.addActionListener(this);
    }
    
    @Override
    public void dataRetrieved(DataRetrievalEvent e) {
        List<String> rows = e.getResult();
        List<FileEntry> entries = new ArrayList<>();
        boolean hasDirs = false;

        //System.err.println("EntriesPanel.dataRetrieved: Rows: " + rows);
        if (rows != null && rows.size() >= 1 && !rows.get(0).equals(TecData.TEC_NULL)) {
            FileEntry entry;
            List<String> parts;
            String s;
            for (int i = 0; i < rows.size(); i++) {
                s = rows.get(i);
                String[] detail = getNameAndRemainder(s);
                parts = StringTool.explode(detail[1], ',');
                if (debugProcessing) System.out.println("Name: " + detail[0] + " Parts: " + parts.size() + " : " + parts);
                if (parts.size() == 4) { 
                    int size = parts.size();
                    entry = new FileEntry(client,detail[0], parts.get(0), parts.get(1), parts.get(2), parts.get(3));
                } else {
                    entry = new FileEntry(
                            client,
                            detail[0], 
                            parts.get(0), 
                            parts.get(1), 
                            parts.get(2), 
                            parts.get(3) + "." + parts.get(4) + "." + parts.get(5)
                    );
                }
                if (entry.isDirectory()) {
                    hasDirs = true;
                }
                entries.add(entry);
            }
        } else {
            System.err.println("Received TEC_NULL: Side: " + id);
        }
        
        // set the model and update GUI
        boolean isNix = false;
        if (!((String)roots.getSelectedItem()).contains(":")) {
            model = new FileEntriesTableModelPOSIX(this,table);
            isNix = true;
        } else {
            model = new FileEntriesTableModelDOS(this,table);
        }
        model.setSide(id);
        table.setModel(model);

        model.setRowCount(0,false);
        for (int i = 0; i < entries.size(); i++) {
            model.addRow(entries.get(i),false);
        }
        
        int[] widths;
        //if (entries.size() > 0) {
        //    widths = getColumnWidths();
        //} else {
            if (isNix) {
                widths = new int[] { 160,100,100,160,100,100,200 };
            } else {
                widths = new int[] { 160,100,60,220,100 };
            }
        //} 
        
        //ineffectual
        //for(int i = 0; i < widths.length;i++) {
        //    TableColumn tableColumn = table.getColumnModel().getColumn(i);
        //    Object value = tableColumn.getHeaderValue();
        //    TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        //    if (renderer == null) {
        //        renderer = table.getTableHeader().getDefaultRenderer();
        //    }
        //    Component c = renderer.getTableCellRendererComponent(table, value, false, false, -1, i);
        //    widths[i] = Math.max(widths[i],c.getPreferredSize().width);
        //}
        table.setColumnWidths(widths);
        
        // compute scrollable area size
        int w = 0;
        for(int i = 0; i < widths.length;i++) {
            w += widths[i];
        }
        int h = Math.max(entries.size() * table.getRowHeight(),scroller.getVerticalScrollBar().getSize().height);
        h += table.getTableHeader().getSize().height;
        h += table.getRowHeight(); // workaround to prevent cutting off of last row
        w = Math.max(w,scroller.getHorizontalScrollBar().getSize().width);
        h = Math.max(h,scroller.getVerticalScrollBar().getSize().height);
        holder.setSize(w,h);
        holder.validate();
        scroller.setViewportView(holder);
        
        //model.fireTableStructureChanged();
        table.getSelectionModel().setSelectionInterval(0, 0); 
        
        // set the entries for the table and model
        model.setEntries(entries);
        
        // scroll to first entry
        table.scrollRectToVisible(new Rectangle(table.getCellRect(0, 0, true)));
        
        // only run the code to get sizes if the entries contains directories
        if (hasDirs) {
            sizeGetter = new SizeGetterLauncher(this,table, client);
            sizeGetter.start();
        }
        
        // when QUIET_START is done, turn on debugging info
        if (firstRun) {
            oldEnv = client.getEnvironment();
            client.setEnvironment(oldEnv);
            firstRun = false;
        }
        
        // finally, we're done here, so signal to any active code blcoks
        changing = false;
    }

    public void delete(String absPath) {
        int count;
        List<String> selected = model.getSelection();
        for (int i = selected.size() - 1; i >= 0; i--) {
            String target = selected.get(i);
            count = 0;
            System.out.println("Deleting: " + target);
            client.delete(target);
            selected.remove(i);
            model.deselect(target);
            while (client.exists(target)) {
                Platform.sleep(125);
                count += 125;
                if (count == 3000) {
                    Platform.message(app, "3 seconds have elapsed for deletion. You may have an open file.");
                }
            }
        }
    }

    public void deselectAll() {
        List<FileEntry> entries = model.getEntries();
        for (int i = 0; i < entries.size(); i++) {
            entries.get(i).deselect();
        }
    }

    public void entryUpdated(FileEntry entry) {
        int row = model.indexOfName(entry.getName());
        client.process(ServerOps.LIST_ITEM + " " + entry.getName());
        List<String> list = client.getLast(ServerOps.LIST_ITEM);
        String data = client.getItemData(entry.getName());
        String[] detail = getNameAndRemainder(data);
        List<String> parts = StringTool.explode(detail[1], ',');
        if (parts.size() == 6) {
            int size = parts.size();
            String posix = parts.get(size - 3) + "," + parts.get(size - 2) + "," + parts.get(size - 1); // Consolidate POSIX permissions
            entry = new FileEntry(client,detail[0], parts.get(0), parts.get(1), parts.get(2), posix);
        } else {
            entry = new FileEntry(client,detail[0], parts.get(0), parts.get(1), parts.get(2), parts.get(3)); // DOS Permissions are easier, no consolidation
        } 
        if (parts.get(0).equals("GET")) {
            SizeGetter_Dir getter = new SizeGetter_Dir(this,row, entry, client);
            while (!getter.isDone()) {
                Platform.sleep(125);
            }
            entry.setSizeLong(getter.getSize());
        }
        model.setEntry(row, entry);
        model.fireTableDataChanged();
    }

    public List<EntriesPanel> getAllById(String id) {
        List<EntriesPanel> result = new ArrayList<>();
        for(int i = 0; i < panels.size();i++) {
            if (panels.get(i).getId().equals(id)) {
                result.add(panels.get(i));
            }
        }
        return result;
    }
    
    public EntriesPanel getById(String id) {
        for(int i = 0; i < panels.size();i++) {
            if (panels.get(i).getId().equals(id)) {
                return panels.get(i);
            }
        }
        return null;
    }
    
    public TLSClient_TVS12 getClient() {
        return client;
    }

    public int getColumnWidth(int colIndex) {
        return table.getColumnWidth(colIndex);
    }
    
    public int[] getColumnWidths() {
        SystemTokenPainter painter;
        Font font = new JLabel().getFont();
        TextPoints textPoints = TextPoints.getInstance(font);
        List<FileEntry> entries = model.getEntries();
        int[] widths;
        if (entries.get(0).isNix()) {
            widths = new int[7];
        } else {
            widths = new int[5];
        }
        for (int i = 0; i < entries.size(); i++) {
            FileEntry entry = entries.get(i);
            for(int j = 0; j < widths.length;j++) {
                painter = new SystemTokenPainter(textPoints,new TextToken(entry.getPart(j)));
                widths[j] = Math.max(widths[j],painter.getTextWidth(1));
            }
        }
        // add in padding
        widths[0] += 20; // name
        widths[3] += 20; // modified
        return widths;
    }
    
//    public static void main(String[] args) {
//        FileTool.launch();
//    }
    
    public final void getEntries() {
        if (client != null && client.getStatus().toLowerCase().equals("up")) {
            boolean oldServerDebug = client.getServerDebug();
            //System.out.println("EntriesPanel.getEntries: getSelectedPath: " + getSelectedPath());
            String wrappedPath = StringTool.getDoubleQuoted(getSelectedPath());
            client.setServerDebug(false);
            if (!client.exists(wrappedPath)) {
                path.setText(""); // in this case, it doesn't matter whether this 
                                    // blocks, or not. We use the same value.
                setSubPath( "");
                // path doesn't exist -- check if root exists
                if (!client.exists(getRoot())) {
                    setRootsQuiet();
                    storeRoot(((String) roots.getSelectedItem()).charAt(0));
                }
            }
            DataGetterThread getter = new DataGetterThread(client, wrappedPath, table, this);
            getter.debug = true;
            getter.start();
            client.setServerDebug(oldServerDebug);
        }
    }

    public FileEntry getEntry(String name) {
        return model.getEntryByDisplayName(name);
    }
    
    public String getId() {
        return id;
    }

    public FileEntriesTableModel getModel() {
        return (FileEntriesTableModel) table.getModel();
    }

    public static String[] getNameAndRemainder(String s) {
        String name = "";
        String remainder = "";
        if (s.trim().startsWith("\"")) {
            name = s.substring(0, s.indexOf("\"", 1) + 1); // in our case, we are making a FileEntry, so it will take the quotes
            // which is important because the name search relies upon the fact
            // that the names aren't processed from the PKIServer results
            remainder = s.substring(name.length() + 1);
            //System.out.println("Name: " + name);
            //System.out.println("Remainder: " + remainder);
        } else {
            name = s.substring(0, s.indexOf(","));
            remainder = s.substring(name.length() + 1);
        }
        return new String[]{name, remainder};
    }

    public String getPackageFor(String path) {
        System.out.println("EntriesPanel.getPackageFor: path: " + path);
        if (client.hasJava(path)) {
            List<String> all = client.getAll(path);
            Pair sorted = new Pair(all);
            List<File> dirs = sorted.getDirs();
            List<File> files = sorted.getFiles();
            for(int i = 0; i < files.size();i++) {
                FileEntry entry = new FileEntry(client,files.get(i).getAbsolutePath());
                if (entry.isJava()) {
                    System.out.println("Java: entry: " + entry.getAbsolutePath() + " package: " + entry.getPackage());
                    return entry.getPackage();
                }
            }
            for(int i = 0; i < dirs.size();i++) {
                FileEntry entry = new FileEntry(client,dirs.get(i).getAbsolutePath());
                if (entry.isDirectory()) {
                    String subPath = getSubPathToJavaFile(entry.getAbsPath());
                    if (!subPath.equals("")) {
                        String pkgPlusDot = StringTool.replaceAll(subPath,File.separator,".");
                        String pkg = pkgPlusDot.substring(0,pkgPlusDot.length() - 1);
                        return StringTool.replaceAll(subPath,File.separator,".").substring(0,subPath.length() - 1);
                    }
                } 
            }
        }
        return "";
    }

    public String getPackageForCurrentDir() {
        return getPackageFor(getSelectedPath());
    }
  
    public String getPackageForCurrentDir_Recursive(File file) {
        List<String> all = client.getAll(file.getAbsolutePath());
        for(int i = 0; i < all.size();i++) {
            String detail = all.get(i);
            FileEntry entry = new FileEntry(client,detail.substring(0,detail.indexOf(",")));
            if (entry.isDirectory()) {
                String pkg = getPackageForCurrentDir_Recursive(entry.getFile());
                if (!pkg.equals("")) {
                    return pkg;
                }
            } else {
                if (entry.isJava()) {
                    return entry.getPackage();
                }
            }
        }
        return "";
    }

    
    public Container getParentComponent() {
        return getParent();
    }

    public String getPath() {
        return path.getText();
    }

    public static String getPropertiesFilenameForClient(String id) {
        return ProjectPath.getTecPropsPath() + 
                          "NetworkConfig" + File.separator + 
                          id + "_client.properties";
    }
 
    public String getRoot() {
        String root = (String) roots.getSelectedItem();
        if (root == null) {
            setRootsQuiet();
        }
        return (String) roots.getSelectedItem();
    }

    /**
     * @return the first character of the selected root 
     * ('/' | 'A' to 'Z' depending on configuration)
     */
    public Character getRootChar() {
        String root = getRoot();
        if (root != null) {
            return root.charAt(0);
        } else {
            if (client.getFileSeparator().equals("/")) {
                return '/';
            } else {
                List<String> roots = client.getRoots();
                return roots.get(0).charAt(0);
            }
        }
    }

    public List<String> getSelection() {
        return model.getSelection();
    }

    public String getSelectedPath() {
        String result = getRoot() + path.getText();
        // note mac/linux will return double slash
        if (result.equals("//")) {
            return "/";
        }
        return result;
    }
    
    public List<String> getSelectedPaths() {
        return model.getSelectedPaths();
    }

    public String getServer() {
        return (String) servers.getSelectedItem();
    }

    public Character getStoredRoot() {
        String storedRoot;
        if (id.equals("LEFT")) {
            storedRoot = app.getProperties().get(getServer() + ".l.root");
        } else if (id.equals("RIGHT")) {
            storedRoot = app.getProperties().get(getServer() + ".r.root");
        } else {
            storedRoot = app.getProperties().get(getServer() + "." + id + ".root");
        }
        //System.err.println("GetStoredRoot: " + stored);
        if (storedRoot == null) {
            char root = client.getRoots().get(0).charAt(0);
            // no data
            setRootsQuiet();
            storeRoot(root);
            return root;
        } else {
            return storedRoot.charAt(0);
        }
    }

    public String getStoredServer() {
        String storedServer = TecData.UNSET_S;
        if (id.equals("LEFT")) {
            storedServer = app.getProperties().get("l.host");
        } else if (id.equals("RIGHT")) {
            storedServer = app.getProperties().get("r.host");
        } else {
            storedServer = app.getProperties().get(id + ".host");
        }
        if (storedServer == null) {
            storedServer = "localhost";
        }
        return storedServer;
    }
    
    public String getSubPath() {
        String stored = "getStoredPath: " + TecData.UNSET_S;
        EntriesPanel panel = null;
        if (id.equals("LEFT")) {
            panel = getById("LEFT");
            Character rootChar = panel.getRootChar();
            if (rootChar != null) {
                stored = app.getProperties().get(getServer() + ".l." + rootChar + ".path");
            }
        } else if (id.equals("RIGHT")) {
            panel = getById("RIGHT");
            Character rootChar = panel.getRootChar();
            if (rootChar != null) {
                stored = app.getProperties().get(panel.getServer() + ".r." + rootChar + ".path");
            }
        } else {
            panel = getById(id);
            Character rootChar = panel.getRootChar();
            if (rootChar != null) {
                stored = app.getProperties().get(panel.getServer() + "." + id + "." + rootChar + ".path");
            }
        }
        if (stored == null) {
            System.out.println("EntriesPanel.getStoredPath: StoredPath == null: " + id);
            stored = "";
            setSubPath(stored);
        } else if (debug) {
            System.out.println("EntriesPanel.getStoredPath: ==: " + stored);
        }
        return stored;
    }

    public String getSubPathToJavaFile(String path) {
        String subPath = "";
        File[] entries = new File(path).listFiles();
        FileEntry entry;
        for(int i = 0;i < entries.length;i++) {
            entry = new FileEntry(client,entries[i].getAbsolutePath());
            if (entry.isJava()) {
                return subPath;
            }
        }
        for(int i = 0;i < entries.length;i++) {
            entry = new FileEntry(client,entries[i].getAbsolutePath());
            if (entries[i].isDirectory()) {
                String subPath2 = getSubPathToJavaFile(entries[i].getAbsolutePath());
                if (!subPath2.equals("")) {
                    if (!subPath2.endsWith(client.getFileSeparator())) {
                        subPath2 += client.getFileSeparator();
                    }
                    subPath += subPath2;
                    return subPath;
                }
            }
        }
        return subPath;
    }
    
    public FileEntriesTable getTable() {
        return table;
    }

    public TLSClient_TVS12 getTLSClient() {
        return client;
    }

    public boolean hasRoot(char ch) {
        String root = ch + "";
        if (ch != '/') root += ":\\";
        for (int i = 0; i < roots.getItemCount(); i++) {
            if (roots.getItemAt(i).equals(root)) {
                return true;
            }
        }
        return false;
    }
    
    public static void main(String[] args) {
        FileTool.launch();
    }

    public void mouseClicked(MouseEvent e) {
        row = table.rowAtPoint(e.getPoint());
        col = table.columnAtPoint(e.getPoint());
        FileEntriesTableModel model = table.getBaseTableModel();
        if (e.getSource() == upDir) {
            if (!changing) {
                stopSizeGetter();
                upOne();
                setSubPath(getPath());
                getEntries();
                app.repaint();
            }
        } else if (e.getSource() == refresh) {
            stopSizeGetter();
            getEntries(); 
        } else if (e.getSource() == env) {
            if (env.getTag().equals("PROD")) {
                client.setEnvironment(EnvData.PROD);
            } else {
                client.setEnvironment(EnvData.DEV);
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getSource() == table && e.getClickCount() == 2) {
                FileEntry entry = model.getEntry(table.convertRowIndexToModel(row));
                if (col == 0 && entry.isDirectory()) {
                    // navigate to directory
                    stopSizeGetter();
                    String sub = getStoredSubPath();
                    System.out.println("StoredSubPath: " + sub);
                    System.err.println("EntriesPanel.mc: Display: " + entry.getDisplayName());
                    String newPath = sub + entry.getDisplayName() + entry.getFileSeparator();
                    if (newPath.startsWith("/")) {
                        newPath = newPath.substring(1);
                    }
                    setSubPath(newPath);  // <-: that should run after the previous line's execution is complete.
                    path.setText(newPath);
                    // and this should be correct at all times...
                    System.out.println("GetStoredPath: " + getStoredSubPath());
                    getEntries();
                } else {
                // double clicked on file, default action?
                   System.err.println("Recorded as file... : " + entry.getAbsPath());
                }
            } else if (e.getSource() == table && e.isControlDown()) {
                FileEntry entry = model.getEntry(row);
                if (model instanceof FileEntriesTableModelDOS && col == 4) {
                    // edit DOS attributes
                    JDialog dialog = new DialogSetDOSAttributes(this, entry);
                    dialog.setLocationRelativeTo(app);
                    dialog.setVisible(true);
                } else {
                    if (model instanceof FileEntriesTableModelPOSIX) {
                        if (col == 4) {
                            // edit POSIX owner
                            JDialog dialog = new DialogSetPOSIXOwner(this, entry);
                            dialog.setLocationRelativeTo(app);
                            dialog.setVisible(true);
                        } else if (col == 5) {
                            // eidt POSIX group;
                            JDialog dialog = new DialogSetPOSIXGroup(this, entry);
                            dialog.setLocationRelativeTo(app);
                            dialog.setVisible(true);
                        } else if (col == 6) {
                            // edit POSIX File permissions
                            JDialog dialog = new DialogSetPOSIXFilePermissions(this, entry);
                            dialog.setLocationRelativeTo(app);
                            dialog.setVisible(true);
                        }
                    }
                }
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            if (e.getSource() == table) {
                // select if necessary
                if (!controlDown && !shiftDown) {
                    if (row >= 0) {
                        model.clearSelection();
                        model.select(row);
                    }
                }
                // get the entry 
                if (row >= 0) {
                    entry = model.getEntry(row);
                }
                // show menu for single item
                if (model.getSelection().size() == 1) {
                    if (row >= 0 && col == 0) {
                        if (entry != null) {
                            if (entry.isDirectory()) {
                                popupReset();
                                if (entry.hasJava()) {
                                    popupAddDevTools();
                                    popupAddSeparator();
                                }
                                popupAddFind();
                                popupAddSeparator();
                                popupAddDelete();
                                popupAddRename();
                                popupAddSeparator();
                                popupAddNews();
                                popupAddSeparator();
                                popupAddBackupOptions();
                                popupFinished(e);
                            } else if (entry.isJava() || entry.isClassFile()) {
                                popupReset();
                                popupAddView();
                                popupAddDevTools();
                                popupAddSeparator();
                                popupAddFind();
                                popupAddReplace();
                                popupAddSeparator();
                                popupAddDelete();
                                popupAddRename();
                                popupAddNews();
                                popupAddSeparator();
                                popupAddBackupOptions();
                                popupFinished(e);
                            } else if (entry.isText()) {
                                popupReset();
                                popupAddView();
                                popupAddSeparator();
                                popupAddFind();
                                popupAddReplace();
                                popupAddSeparator();
                                popupAddDelete();
                                popupAddRename();
                                popupAddNews();
                                popupAddSeparator();
                                popupAddBackupOptions();
                                popupFinished(e);
                            }
                        } else {
                        // actually, this probably shouldn't happen, unless I'm 
                        // wrong, so we want this in System.err, but that may 
                        // not show highlighted as we want, nevertheless, at least
                        // do a System.err.println so we can search
                            System.err.println("EntriesPanel.mc -- Unexpected");
                        }
                    } else {
                    // for when we activate somewhere that is just the table
                        popupReset();
                        popupAddFind();
                        popupAddSeparator();
                        popupAddNews();
                        popupAddSeparator();
                        popupAddBackupOptions();
                        popupFinished(e);
                    }
                } else if (row >= 0 && 
                           model.getEntry(row).isSelected() &&
                           getSelection().size() > 1) 
                {
                    popupReset();
                    entry = new FileEntry(client,getSelectedPath());
                    if (entry.hasJava()) {
                        popupAddDevTools();
                    }
                    popupAddFind();
                    popupAddDelete();
                    popupFinished(e);
                } else { // user clicked in bottom of table, only add new file/folder
                    popupReset();
                    FileEntry entry = new FileEntry(client,getSelectedPath());
                    if (entry.hasJava()) {
                        popupAddDevTools();
                        popupAddSeparator();
                    }
                    popupAddFind();
                    popupAddNews();
                    popupFinished(e);
                }
            } else {
                popupReset();
                popupAddFind();
                popupAddNews();
                popupFinished(e);        
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        app.dragSrc = this;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int row = table.rowAtPoint(e.getPoint());
        controlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        if (firstIndex == -1) {
            firstIndex = row;
        }
    }

    public void mouseReleased(MouseEvent e) {
        int row = table.rowAtPoint(e.getPoint());
        controlDown = e.isControlDown();
        shiftDown = e.isShiftDown();
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (row == -1 && !controlDown && !shiftDown) {
                if (model != null) model.clearSelection();
            } else if (firstIndex == -1) {
                if (row >= 0) {
                    firstIndex = row;
                    lastIndex = -1;
                    model.select(row);
                    lastSet = row;
                }
            } else if (controlDown && shiftDown) {
                if (row >= 0) {
                    model.deselect(lastSet);
                    int min = Math.min(lastSet, row);
                    int max = Math.max(lastSet, row);
                    for (int i = min; i <= max; i++) {
                        model.toggleSelected(i);
                    }
                    firstIndex = -1;
                    lastIndex = -1;
                    lastSet = row;
                }
            } else if (controlDown && !shiftDown) {
                if (row >= 0) {
                    model.toggleSelected(row);
                    if (!model.isSelected(row)) {
                        firstIndex = -1;
                    }
                    lastSet = row;
                }
            } else if (shiftDown) {
                if (row >= 0 && firstIndex >= 0) {
                    int min = Math.min(firstIndex, row);
                    int max = Math.max(firstIndex, row);
                    for (int i = min; i <= max; i++) {
                        model.select(i);
                    }
                }
            } else {
                if (row >= 0) {
                    model.clearSelection();
                    model.select(row);
                    firstIndex = row;
                    lastIndex = -1;
                    lastSet = row;
                }
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            if (row >= 0) {
                System.out.println("entry: " + model.getEntry(row).toString());
            }
        }
        System.out.println("LastSet: " + lastSet + " Row: " + row + " First: " + 
                           firstIndex + " Last: " + lastIndex + " shift: " + shiftDown + 
                           " ctrl: " + controlDown);
        if (model != null) model.fireTableDataChanged();
    }

    public void operateRoots() {
        stopSizeGetter();
        String root = (String) roots.getSelectedItem();
        storeRoot(root.charAt(0));
        String storedPath = getStoredSubPath();
        if (storedPath == null) storedPath = "";
        if (storedPath.startsWith("/")) {
            storedPath = storedPath.substring(1);
        }
        path.setText(storedPath);
        setSubPath(path.getText());
        validatePath();
        getEntries();
    }

    public void operateServers() {
        stopSizeGetter();
        String server = (String) servers.getSelectedItem();
        setServer(server);
        storeServer(server);
        setRootsQuiet();
        getStoredRoot();
        getSubPath();
        validatePath();
        getEntries();
    }

    public void popupReset() {
        popup = new JPopupMenu();
    }

    public void popupAddBackupOptions() {
        popup.add(add);
        popup.add(remove);
        popup.add(targets);
    }
    
    public void popupAddDevTools() {
        popup.add(clean);
        popup.add(compile);
    }
        
    public void popupAddDelete() {
        popup.add(delete);
    }

    public void popupAddFind() {
        popup.add(find);
    }

    public void popupAddNews() {
        popup.add(newFolder);
        popup.add(newFile);
    }

    public void popupAddRename() {
        popup.add(rename);
    }
    
    public void popupAddReplace() {
        popup.add(replace);
    }
    
    public void popupAddSeparator() {
        popup.addSeparator();
    }
    
    public void popupAddView() {
        popup.add(view);
    }
    
    public void popupFinished(MouseEvent e) {
        popup.show(table, e.getX(), e.getY());
    }

    public void printSelection() {
        List<String> selection = getSelection();
        System.out.println("Selection: " + selection.size());
        for (int i = 0; i < selection.size(); i++) {
            System.out.println(i + ": " + selection.get(i));
        }
    }

    public void resizeColumn(int colIndex, int diff) {
        holder.setSize(holder.getSize().width + diff,holder.getSize().height);
        scroller.setViewportView(holder);
        //validate();
        table.setColumnWidth(colIndex,table.getColumnWidth(colIndex) + diff);
    }
    
    public void setDOSFileAttributes(FileEntry entry, String attributes) {
        client.setDOSFileAttributes(entry.getName(), attributes);
    }

    public void setDOSModel() {
        model = new FileEntriesTableModelDOS(this,table);
    }
    
    public void setEnvironment(String env) {
        if (env.equals(EnvData.PROD)) {
            this.env.setTag("P");
            this.client.setEnvironment(env);
        } else {
            this.env.setTag("D");
            this.client.setEnvironment(env);
        }
    }
    
    public void setId(String id) {
        this.id = id;
    }

    public void setPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path.setText(path);
        // don't attempt to chain in app.storePath -- see FilesTool usages
    }

    public void setPOSIXFilePermissions(FileEntry entry, String permissions) {
        client.setPOSIXFilePermissions(entry.getName(), permissions);
    }

    public void setPOSIXGroup(FileEntry entry, String group) {
        client.setPOSIXGroup(entry.getName(), group);
    }

    public void setPOSIXModel() {
        model = new FileEntriesTableModelPOSIX(this,table);
    }
    
    public void setPOSIXOwner(FileEntry entry, String owner) {
        client.setPOSIXOwner(entry.getName(), owner);
    }

    public void setRoot(char root) {
        if (root == '/') {
            roots.setSelectedItem("/");
        } else {
            roots.setSelectedItem(root + ":\\");
        }
    }

    public void setRootsQuiet() {
        quiet = true;
        List<String> roots = client.getRoots();
        if (this.roots.getItemCount() > 0) {
            this.roots.removeAllItems();
        }
        for (int i = 0; i < roots.size(); i++) {
            this.roots.addItem(StringTool.getUnwrapped(roots.get(i)));
        }
        this.roots.setSelectedItem(0);
        quiet = false;
    }

    public void setServer(String label) {
        //System.out.println("EntriesPanel: setServer: " + label);
        boolean found = false;
        if (Internet.isIP(label)) {
            label = NameService.getInstance().getByIP(label);
        }
        for (int i = 0; i < servers.getItemCount(); i++) {
            if (servers.getItemAt(i).equals(label)) {
                found = true;
                servers.setSelectedItem(label);
            }
        }
        if (!found) {
            servers.addItem(label);
            servers.setSelectedItem(label);
        }
        
        // attempt to get it's ip address through Java
        String clientId = null;

        // we should have a local server running
        if (label.equals("localhost") | label.equals("127.0.0.1")) {
            clientId = "localhost";
        } else {
            try { // attempt to get the ip address for the client label, here the label may be some DNS hostname
                InetAddress[] addresses = InetAddress.getAllByName(label);
                if (addresses != null && addresses.length == 1) { // only one host should match
                    clientId = label;
                }
            } catch (UnknownHostException e) { // no ip? so label must be in NameService or we can't process
                String ip = NameService.instance.getByName(label);
                if (!ip.equals("")) {
                    clientId = ip; // got an ip, so set the client id to the ip
                }
            }
        }
        if (clientId != null) {
            stopSizeGetter();
            Properties props = new Properties(getPropertiesFilenameForClient(clientId));
            System.out.println("EntriesPanel: " + id + ": using properties for client: " + props.getPropertiesFilename());
            try {
                client = new TLSClient_TVS12(props,
                    Platform.requestPassword(app,"Enter the keystore password for: " + clientId),
                    debug
                );
            } catch (NoTLSConnectionException ntlsce) {
                System.err.println("No TLS Connection: " + ntlsce.getPropertiesFilename());
            }
            Boolean isUp = client.getStatus().toLowerCase().equals("up");
            if (isUp != null && isUp) {
                storeServer(clientId);
            }
            System.out.println("setServer: isUp: (" + props.get(PKIData.REMOTE_HOST) + "): " + isUp);
        } else {
            System.out.println("Unable to resolve to connection parameters: " + label);
        }

        // re-format the table for the server type
        if (client.getFileSeparator().equals("/")) {
            setPOSIXModel();
        } else {
            setDOSModel();
        }
        model.fireTableStructureChanged();
        // attempt to load last root and last path
        getStoredRoot();
        getStoredSubPath();
    }

    public final void setServerLabels(List<String> names) {
        servers.removeAllItems();
        for (int i = 0; i < names.size(); i++) {
            servers.addItem(StringTool.getUnwrapped(names.get(i)));
        }
    }

    public void setupDND() {
        ds.createDefaultDragGestureRecognizer(table, DnDConstants.ACTION_COPY_OR_MOVE, new DragGestureListener() {
            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                try {
                    if (model.getSelection().size() > 0) {
                        ds.startDrag(dge, null, new FileListTransferable(getSelection()), new DragSourceListener() {

                            @Override
                            public void dragEnter(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dragOver(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dropActionChanged(DragSourceDragEvent dsde) {
                            }

                            @Override
                            public void dragExit(DragSourceEvent dse) {
                            }

                            @Override
                            public void dragDropEnd(DragSourceDropEvent dsde) {
                                setCursor(Cursor.getDefaultCursor());
                            }

                        });
                    }
                } catch (InvalidDnDOperationException idndoe) {
                    System.out.println(">>> Invalid drag state: already started. Ignoring.");
                }
            }
        });
    }

    public void setupGUI() {
        JPanel settingsHolder = new JPanel(new GridLayout(3, 1));
        settingsHolder.add(servers);
        settingsHolder.add(roots);
        pathLine.add(path, BorderLayout.CENTER);
        addButtons();
        if (debug) addButtons_Env();
        pathLine.add(buttons, BorderLayout.EAST);
        settingsHolder.add(pathLine);

        JPanel contentHolder = new JPanel(new BorderLayout(0, 0));
        setLayout(new BorderLayout(0, 0));
        add(settingsHolder, BorderLayout.NORTH);
        add(contentHolder, BorderLayout.CENTER);
        validate();

        table.setFillsViewportHeight(true);
        table.setRowHeight(24);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        table.getTableHeader().setResizingAllowed(true);
                
        holder = new SizedPanel(1,1);
        holder.setLayout(new BorderLayout());
        holder.add(table.getTableHeader(),BorderLayout.NORTH);
        holder.add(table,BorderLayout.CENTER);
        scroller = new JScrollPane(holder, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scroller.getVerticalScrollBar().setUnitIncrement(16);
        contentHolder.add(scroller, BorderLayout.CENTER);
        revalidate();
    }

    public void stopSizeGetter() {
        if (sizeGetter != null) {
            sizeGetter.stopRunning();
        }
    }

    public final void printSelectedPath() {
        System.out.println("EntriesPanel.getEntries: selectedPath: " + getSelectedPath());
    }

    public String getStoredSubPath() {
        Properties props = app.getProperties();
        String storedSub = props.get(getServer() + "." + id + "." + getRootChar() + ".path");
        if (id.equals("LEFT")) {
            storedSub = props.get(getServer() + ".l." + getRootChar() + ".path");
        } else if (id.equals("RIGHT")) {
            
            storedSub = props.get(getServer() + ".r." + getRootChar() + ".path");
        }
        return storedSub;
    }

    // not here.
    public void setSubPath(String path) {
        if (path.startsWith("/")) path = path.substring(1);
        if (id.equals("LEFT")) {
            app.getProperties().set(getServer() + ".l." + getRootChar() + ".path", path);
        } else if (id.equals("RIGHT")) {
            app.getProperties().set(getServer() + ".r." + getRootChar() + ".path", path);
        } else {
            app.getProperties().set(getServer() + "." + id + "." + getRootChar() + ".path",path);
        }
    }

    // Stop. Paste between single line comments for 'Block'.
    
    
    public void storeRoot(char root) {
        if (id.equals("LEFT")) {
            app.getProperties().set(getServer() + ".l.root", root);
        } else if (id.equals("RIGHT")) {
            app.getProperties().set(getServer() + ".r.root", root);
        } else {
            app.getProperties().set(getServer() + "." + id + ".root",root);
        }
    }

    public void storeServer(String host) {
        if (id.equals("LEFT")) {
            app.getProperties().set("l.host", host);
        } else if (id.equals("RIGHT")) {
            app.getProperties().set("r.host", host);
        } else {
            app.getProperties().set(id + ".host", host);
        }
    }

    public void upOne() {
        String text = path.getText();
        if (text.startsWith("/")) {
            text = text.substring(1);
            path.setText(text);
        }
        if (text.length() > 0) {
            String separator = StringTool.getLastCharacter(text); // path separator will be last char
            text = StringTool.rtrim(text, 1);
            if (text.contains(separator)) {
                path.setText(text.substring(0, text.lastIndexOf(separator) + 1));
            } else {
                // no separator, so in the last directory
                path.setText("");
            }
        }
        setSubPath(path.getText());
    }

    public void updateEntry(FileEntry entry) {
        int row = model.indexOfName(entry.getName());
        model.setEntry(row, entry);
        model.fireTableRowsUpdated(row, row);
    }

    public void validatePath() {
        if (!client.exists(getSelectedPath())) {
            path.setText("");
            setSubPath("");
        }
    }
}
