package ca.tecreations.apps._gui;

import ca.tecreations.FileEntry;
import ca.tecreations.Sort;
import ca.tecreations.net.TLSClient_TVS12;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.*;
import java.util.List;

import javax.swing.*;
 
/**
 *
 * @author tim
 */
public class DialogSetPOSIXOwner extends JDialog implements ActionListener {
    TLSClient_TVS12 client;
    EntriesPanel panel;
    FileEntry entry;
    JScrollPane scroller;
    JList<String> list = new JList<>();
    JPanel buttons = new JPanel(new GridLayout(1,2));
    JButton cancel = new JButton("Cancel");
    JButton ok = new JButton("OK");
    
    public DialogSetPOSIXOwner(EntriesPanel panel, FileEntry entry) {
        this.client = panel.getTLSClient();
        this.panel = panel;
        this.entry = entry;
        setLayout(new BorderLayout(0,0));
        setTitle("Set Unix Owner : " + entry.getDisplayName());
        scroller = new JScrollPane(list,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        add(scroller,BorderLayout.CENTER);
        buttons.add(cancel);
        buttons.add(ok);
        add(buttons,BorderLayout.SOUTH);
        cancel.addActionListener(this);
        ok.addActionListener(this);
        List<String> usersList = client.getPOSIXUsers();
        usersList = Sort.sort(usersList);
        String[] users = new String[usersList.size()];
        for(int i = 0; i < usersList.size();i++) users[i] = usersList.get(i);
        list.setListData(users);
        list.setSelectedValue(client.getPOSIXOwner(entry.getName()), true);
        setSize(240,360);
        setVisible(true);
    }
    public void actionPerformed(ActionEvent e) {
        setVisible(false);
        if (e.getSource() == cancel) {
        } else if (e.getSource() == ok) {
            if (list.getSelectedIndex() > 0) {
                client.setPOSIXOwner(entry.getName(),list.getSelectedValue());
            }
            panel.entryUpdated(entry);
        }
    }
}
