package ca.tecreations.apps._data;

import ca.tecreations.FileEntry;
import ca.tecreations.TecData;
import ca.tecreations.apps._gui.*;
import ca.tecreations.net.NoTLSConnectionException;
import ca.tecreations.net.TLSClient_TVS12;

/**
 *
 * @author tim
 */
public class SizeGetter_Dir extends Thread {
    EntriesPanel entriesPanel;
    int index;
    String absPath;
    TLSClient_TVS12 client;
    long size;
    boolean done = false;
    
    public SizeGetter_Dir(EntriesPanel entriesPanel, int index, FileEntry entry, TLSClient_TVS12 client) {
        this.entriesPanel = entriesPanel;
        this.index = index;
        this.absPath = entry.getAbsolutePath();
        this.client = client;
        start();
    } 
 
    public String getAbsolutePath() { return absPath; }
    
    public int getIndex() { return index; }
    
    public long getSize() { return size; }
    
    public boolean isDone() { return done; }
    
    public void run() {
//        String oldEnv = client.getEnvironment();
//        client.setEnvironment(EnvData.DEV);
        TLSClient_TVS12 sizeClient = null;
        try {
            sizeClient = new TLSClient_TVS12(client.getProperties(),
                                             client.getPassword(),
                                             client.getDebug()
            );
        } catch (NoTLSConnectionException ntlsce) {
            System.err.println("No TLS Connection: " + ntlsce.getPropertiesFilename());
        }
        String result = sizeClient.getDirSize(absPath);
        if (entriesPanel.debugGetSizes) System.out.println("SizeGetter_Dir.run: result: " + result);
        if (result != null && !result.equals(TecData.FILE_NOT_FOUND)) {
            size = Long.parseLong(result);
        } 
        done = true;
    }
 
}