package ca.tecreations.apps._data;

import ca.tecreations.FileEntry;
import ca.tecreations.apps._gui.*;
import ca.tecreations.net.TLSClient_TVS12;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class SizeGetterLauncher extends Thread {
    EntriesPanel entriesPanel;
    TLSClient_TVS12 client;
    FileEntriesTable table;
    FileEntriesTableModel model;
    boolean running = false; 
    
    public SizeGetterLauncher(EntriesPanel entriesPanel,FileEntriesTable table, TLSClient_TVS12 client) {
        this.entriesPanel = entriesPanel;
        this.client = client;
        this.table = table;
        this.model = table.getBaseTableModel(); 
    }

    public void run() {
        List<SizeGetter_Dir> getters = new ArrayList<>();
        List<FileEntry> entries = model.getEntries();
        String separator = client.getFileSeparator();
        FileEntry entry;
        for(int i = 0; i < entries.size();i++) {
            entry = entries.get(i);
            if (entry.isDirectory()) {
                SizeGetter_Dir getter = new SizeGetter_Dir(entriesPanel,i,entry,client);
                getters.add(getter);
            }
        }
        //System.out.println("Processed: " + entries.size() + " entries. Getters: " + getters.size());
        SizeGetter_Dir getter;
        while (getters.size() > 0 && running) {
            for(int i = getters.size() - 1; i >= 0;i--) {
                getter = getters.get(i);
                if (getter.isDone() && running) {
                    int index = table.convertRowIndexToModel(getter.getIndex());
                    String absPath = getter.getAbsolutePath();
                    entry = model.getEntryByAbsPath(absPath);
                    if (entry != null) {
                        entry.setSizeLong(getter.getSize());
                        model.setEntrySize(index, getter.getSize());
                    } 
                    getters.remove(getter);
                }
            }
        }
    }
    
    public void start() {
        running = true;
        super.start();
    }
    
    public void stopRunning() {
        running = false;
    }
}
