package ca.tecreations.apps;

import ca.tecreations.File;
import ca.tecreations.JarReader;
import ca.tecreations.TecData;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.lang.java.AllJarsEqualSize;
import ca.tecreations.lang.java.AllJarsExist;
/**
 *
 * @author tim
 */
public class UnpackIfDifferent {
    
    public UnpackIfDifferent(String jarsJarPath, String outDir, ProgressListener pl,boolean debug) {
        boolean unpack = false;
        // does the jars path for the jar exist?
        File jarFile = new File(jarsJarPath);
        JarReader reader = new JarReader(jarsJarPath);
        if (!new File(reader.getTecreationsUnpackPath()).exists()) {
            // no? unpack.
            pl.addItem("UnpackIfDifferent: Non-existent path: " + reader.getTecreationsUnpackPath());
            pl.addItem("UnpackIfDifferent: Attempting to create.");
            new File(reader.getTecreationsUnpackPath()).mkdirs();
            unpack = true;

        } 
        AllJarsExist.debug = debug;
        if (!unpack && !new AllJarsExist(jarFile,outDir).isTrue()) {
            doLogAction(pl,"UnpackIfDifferent: AllJarsExist(): somethings missing.");
            unpack = true;
        }
        if (!unpack && !new AllJarsEqualSize(jarFile,outDir).isTrue()) {
            doLogAction(pl,"UnpackIfDifferent: AllJarsEqualSize(): somethings changed size.");
            unpack = true;
        }
       if (unpack) reader.unpackJarsForTecreations(pl);
        else {
            doLogAction(pl,"UnpackIfDifferent: equal.");
        }
        // the TecreationsUnpackDir should always be synced using this class.
    }

    public void doLogAction(ProgressListener pl, String s) {
        if (pl != null) pl.addItem(s);
        else System.out.println(s);
    }
    
}
