package ca.tecreations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
/**
 * 
 * @author Tim
 */
public class TypeToType {
  
    public static String charArrayToString(char[] c) {
        String s = "";
        for(int i = 0; i < c.length;i++) s += c[i];
        return s;
    }
    
    public static List<Point> CSVsToListPoint(List<String> strings) {
        String s;
        String xS;
        String yS;
        
        List<Point> result = new ArrayList<>();
        for(int i = 0; i < strings.size();i++) {
            s = strings.get(i);
            if (s.contains(",")) {
                xS = s.substring(0,s.indexOf(","));
                yS = s.substring(s.indexOf(",") + 1);
                result.add(new Point(Integer.parseInt(xS),Integer.parseInt(yS)));
            }
        }
        return result;
    }
    
    public static String getDelimited(List<String> lines, String delimiter) {
        String result = "";
        for(int i = 0; i < lines.size() - 1; i++) {
            result += lines.get(i) + delimiter;
        }
        if (lines.size() >= 1) {
            result += lines.get(lines.size() - 1);
        }
        return result;
    }
    
    public static List<String> listFileToListString(List<File> list) {
        List<String> strings = new ArrayList<>();
        for(int i = 0;i < list.size();i++) {
            strings.add(list.get(i).getAbsolutePath());
        }
        return strings;
    }
    
    public static List<File> listStringToListFile(List<String> strings) {
        List<File> fileOBJS = new ArrayList<>();
        for(int i = 0; i < strings.size();i++) {
            fileOBJS.add(new File(strings.get(i)));
        }
        return fileOBJS; // please God, Jesus for me too! and all that don't or sin
        // for Carol, and Cathy, and David. Even Pierre Poilievre and Mark Carney
        // and Donald Trump. For Emmanuel Macron, Validimir Zelensky, Vladmir Putin
        // and Ursula Von Der Layden?
    }
    
    public static void main(String[] args) {
        List<String> strings = new ArrayList<>();
        strings.add("2,3");
        strings.add("3,5");
        strings.add("3,6");
        String csvs = "";
        
        for(int i = 0; i < strings.size();i++) {
            if (i < strings.size() - 1) {
                csvs += strings.get(i) + ";";
            } else {
                csvs += strings.get(i);
            }
        }
        System.out.println("csvs: " + csvs);
        
        StringTool.explode(csvs,';');
        List<Point> points = CSVsToListPoint(strings);
        for(int i = 0; i < points.size();i++) {
            System.out.println("Point " + strings.get(i) + ": " + points.get(i));
        }
    }
    
    
    public String[] fromCSVString(String s) {
        int partsCount = StringTool.getCount(',',s) + 1;
        String[] array = new String[partsCount];
        List<String> inReverse = new ArrayList<>();
        int index = 0;
        String reversing = s;
        for(int i = partsCount - 1;i >= 0;i--) {
            inReverse.add(reversing.substring(reversing.lastIndexOf(',') + 1));
            reversing = reversing.substring(0,reversing.lastIndexOf(','));
            array[index] = inReverse.get(index);
            index++;
        }
        return array; 
    }
    
    public static List<Point> fromSemiSeparated(String s) {
        List<String> parts = StringTool.explode(s,';');
        List<Point> points = new ArrayList<>();
        String tempS;
        for(int i = 0; i < parts.size();i++) {
            tempS = parts.get(i);
            int x = Integer.parseInt(tempS.substring(0,tempS.indexOf(",")));
            int y = Integer.parseInt(tempS.substring(tempS.indexOf(",") + 1));
            points.add(new Point(x,y));
        }
        return points;
    }
    
    public static String[] toArray(List<String> list) {
        String[] copy = new String[list.size()];
        for(int i = 0; i < list.size();i++) {
            copy[i] = list.get(i);
        }
        return copy;
    }
    
    public static byte[] toByteArray(String s) {
        byte[] carrier = new byte[s.length()];
        for(int i = 0; i < s.length();i++) {
            carrier[i] = (byte)s.charAt(i);
        }
        return carrier;
    }
    
    public static char[] toCharArray(String s) {
        char[] array = null;
        array = s.toCharArray();
        return array;
    }
    
    public static String toCSVString(List<Integer> list) {
        String result = "";
        for(int i = 0; i < list.size() - 1;i++) {
            result += list.get(i) + ",";
        }
        if (list.size() > 0) {
            result += list.get(list.size() - 1);
        }
        return result;
    }
        
    public static String toCSVString(String[] array) {
        String result = "";
        for(int i = 0; i < array.length - 1;i++) {
            result += array[i] + ",";
        }
        if (array.length > 0) {
            result += array[array.length - 1];
        }
        return result;
    }
    
    public static File[] toFileArray(List<File> list) {
        File[] files = new File[list.size()];
        for(int i = 0; i < list.size();i++) files[i] = list.get(i);
        return files;
    }
    
    public static List<String> toListString(JList<String> src) {
        List<String> dst = new ArrayList<>();
        DefaultListModel<String> model = (DefaultListModel<String>)src.getModel();
        for(int i = 0; i < model.getSize();i++) {
            dst.add(model.elementAt(i));
        }
        return dst;
    }
    
    public static List<String> toList(String[] array) {
        List<String> list = new ArrayList<>();
        for(int i = 0; i < array.length;i++) {
            list.add(array[i]);
        }
        return list;
    }
    
    public static String toSemiSeparatedString(List<Point> points) {
        String s = "";
        if (points.size() >= 1) s += points.get(0).getAsCSV();
        for(int i = 1; i < points.size();i++) {
            s += ";" + points.get(i);
        }
        return s;
    }
    
    public static String toSpacedString(List<String> list) {
        String s = "";
        for(int i = 0; i < list.size() - 1;i++) {
            s += list.get(i) + " ";
        }
        if (list.size() > 0) s += list.get(list.size() - 1);
        return s;
    }
    
    public static String toString(String[] array) {
        String s = "";
        for(int i = 0; i < array.length - 1;i++) {
            s += array[i] + " ";
        }
        s += array[array.length - 1];
        return s;
    }
    
    public static String toString_AbsPaths(List<File> list) {
        String s = "";
        for(int i = 0;i < list.size() - 1;i++) {
            s += list.get(i).getAbsolutePath() + ",";
        }
        if (list.size() >= 1) s += list.get(list.size() - 1).getAbsolutePath();
        return s;
    }
    
    public static String toString(List<String> list) {
        String s = "";
        if (list.size() >= 1) s += list.get(0);
        for(int i = 1; i < list.size();i++) {
            s += "," + list.get(i);
        }
        return s;
    }
    
    public static String toString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for(int i = 0; i < b.length;i++) {
            buf.append((char)b[i]);
        }
        return buf.toString();
    }
     
    public static String toString(char[] c) {
        StringBuffer buf = new StringBuffer();
        for(int i = 0; i < c.length;i++) {
            buf.append((char)c[i]);
        }
        return buf.toString();
    }
   
    public static StringBuffer toStringBuffer(char[] c) {
        StringBuffer buf = new StringBuffer();
        for(int i = 0; i < c.length;i++) {
            buf.append((char)c[i]);
        }
        return buf;
    }
   
    public static String[] toStringArray(List<String> list) {
        String[] array = new String[list.size()];
        for(int i = 0; i < list.size();i++) {
            array[i] = list.get(i);
        }
        return array;
    }

}
