package ca.tecreations;
import java.util.ArrayList;
import java.util.List; 
/**
 * 
 * @author Tim de Vries
 */
public class TextFile {
    String path;
    List<String> lines;
    
    public TextFile(File file,boolean empty) {
        this(file.getAbsolutePath(),empty);
    }

    public TextFile(File file) {
        this(file.getAbsolutePath());
    }
      
    public TextFile(String path) {
        this.path = path;
        File tecFile = new File(path);
        tecFile.getDeepestDirectory().mkdirs();
        if (new File(path).exists()) {
            read(); 
        } else {
            Platform.writeLines(path,new ArrayList<>());
            lines = new ArrayList<>();
        }
    } 
    
    public TextFile(String path,boolean empty) {
        this.path = path;
        lines = new ArrayList<>();
        File tecFile = new File(path);
        tecFile.getDeepestDirectory().mkdirs();
        Platform.writeLines(path,lines);
    }
    
    public TextFile(String path, List<String> lines) {
        this.path = path;
        this.lines = lines;
        File tecFile = new File(path);
        tecFile.getDeepestDirectory().mkdirs();
        Platform.writeLines(path,lines);
    }
    
    public void add(String s) {
        lines.add(s);
        write();
    }
    
    public void clear() {
        lines = new ArrayList<>();
    }
    
    public void close() {
        
    }
    
    public void delete() {
        new File(path).delete();
        empty();
    }
    
    public void empty() {
        lines = new ArrayList<>();
    }
    
    public String getAbsolutePath() { return path; }
    
    public int getIndexStartsWith(String lineStart) {
        lineStart = lineStart.toLowerCase();
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).trim().toLowerCase().startsWith(lineStart)) return i;
        }
        return -1;
    }
    
    public int getIndexStartsWith(String lineStart, int fromIndex) {
        lineStart = lineStart.toLowerCase();
        for(int i = fromIndex; i < lines.size();i++) {
            if (lines.get(i).trim().toLowerCase().startsWith(lineStart)) return i;
        }
        return -1;
    }
    
    public String getLine(int index) {
        return lines.get(index);
    }
    
    public List<String> getLines() { return lines; }
     
    public String getLineStartsWith(String lineStart) {
        lineStart = lineStart.toLowerCase();
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).trim().toLowerCase().startsWith(lineStart)) return lines.get(i);
        }
        return null;
    }
    
    public boolean hasLine(String line) {
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).trim().startsWith(line)) return true;
        }
        return false;
    }
    
    public boolean hasMain() {
        String main = "public static void main(";
        boolean inComment = false;
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).contains("/*")) {
                inComment = true;
            } else if (lines.get(i).contains("*/")) {
                inComment = false;
            } else if (!inComment && lines.get(i).contains(main)) return true;
        }
        return false;
    }
    
    public void print() {
        for(int i = 0; i < lines.size();i++) {
            System.out.println(lines.get(i));
        }
    }
    
    public void read() {
        lines = Platform.getFileLines(StringTool.getDoubleQuoted(path)); // unwrap for everyone
    }
    
    public void replace(int index, String line) {
        lines.set(index,line);
    }
    
    public void replaceAllStartsWith(String lineStart,String replacement) {
        lineStart = lineStart.toLowerCase();
        for(int i = 0; i < lines.size();i++) {
            if (lines.get(i).trim().toLowerCase().startsWith(lineStart)) set(i,replacement);
        }
    }
    
    public void set(int lineNum, String s) {
        lines.set(lineNum, s);
        write();
    }
    
    public void setLines(List<String> lines) {
        this.lines = lines;
        write();
    }
    
    public void setText(String text) {
        List<String> lines;
        if (text.contains("\r\n")) {
            lines = StringTool.explode(text,"\r\n");
        } else {
            lines = StringTool.explode(text,"\n");
        }
        setLines(lines);
    }
    
    public void write() {
        Platform.writeLines(path,lines);
    }
    
    public static void main(String[] args) {
        TextFile file = new TextFile("c:\\temp\\TextFile.txt");
        file.print();
        //file.delete();
        file.write();
    }
    
    
}
