package ca.tecreations;

import ca.tecreations.text.TextPoints;
import ca.tecreations.net.*;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;

/**
 * This class mostly embodies much of the data I really want access to.
 * 
 * @author Tim
 */
public class TecData {
    public static final String BACKTICK = "`";
    public static final String COLON = ":";
    public static final String SPACE = " ";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SINGLE_QUOTE = "'";
    public static final String BACKSLASH = "\\";
    public static final String FORESLASH = "/";
    public static final String SEMICOLON = ";";

    public static final String JETHRO = "jethro";
    public static final String TIMSTEN = "TIMSTEN";
    public static final String StusTwelve = "StusTwelve";
    public static List<String> lastProject = new ArrayList<>();
    static {
        lastProject.add(JETHRO);
        lastProject.add(TIMSTEN);
        lastProject.add(StusTwelve);
    }
    
    public static Color DEFAULT_COLOR = Color.TEC_SELECTED;
    
    List<String> exclude = new ArrayList<>();
    List<String> include = new ArrayList<>();

    public static int SYS_OUT = 0;
    public static int SYS_ERR = 1;

    public static String TEC_SEP = "_$TEC$_";

    
    public static String TEC_VERSION = StusTwelve;
    public static String LAST_TEC_VERSION = TIMSTEN;
    
    // must be inserted after TEC_VERSION or TEC_VERSION will be null
    public static final BufferedImage TEC_BRAND = getTecBrandImage();
    public static BufferedImage getTecBrandImage() {
        String imagesPath = ProjectPath.getTecreationsPath() + "images" + File.separator;
        if (!new File(imagesPath).exists()) {
            System.out.print("Creating tecreations/images directory...");
            new File(imagesPath).mkdirs();
            if (new File(imagesPath).exists()) System.out.println("OK");
            else System.err.println("FAILED");
        }
        String jarPath = TecData.getLastProjectName();
        
        String tecBrandImagePath = imagesPath + "tec_brand.png";
        if (new File(jarPath).exists()) {
            if (!new File(tecBrandImagePath).exists()) {
                //System.out.println("Brand image does not exist. Attempting unpack()");
                JarEntry brandImg = new JarEntry("tec_brand.png");
                //System.out.println("BrandImg: JarEnty: " + brandImg);
                //System.out.println("Out: " + tecBrandImagePath);
                new JarReader(jarPath).unpack(brandImg, tecBrandImagePath,null,true,true);
            }
        } else {
            if (!ProjectPath.isJar()) {
                tecBrandImagePath = ProjectPath.getProjectPath() + "tec_brand.png";
            }
        }
        BufferedImage tecBrand = null;
        if (ProjectPath.isJar()) {
            tecBrand = ImageTool.getImageFromJar(ProjectPath.getRuntimePath(TecData.class.getProtectionDomain()),"/tec_brand.png");
        }
        if (new File(tecBrandImagePath).exists()) {
            tecBrand = ImageTool.getImage(tecBrandImagePath);
        }
        return tecBrand; 
    }

    public static final int UNSET = -999;
    public static final String UNSET_S = "" + UNSET;

    public static final String FILE_NOT_FOUND = "FILE_NOT_FOUND";

    public static final String WIN_10_STARTUP_PATH = "C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\StartUp\\";

    public static final String WINDOW_X = "window.x";
    public static final String WINDOW_Y = "window.y";
    public static final String WINDOW_WIDTH = "window.width";
    public static final String WINDOW_HEIGHT = "window.height";

    public static final TextPoints ARIAL_P_12 = TextPoints.getInstance("Arial", Font.PLAIN, 12);
    public static final TextPoints ARIAL_B_12 = TextPoints.getInstance("Arial", Font.BOLD, 12);
    public static final TextPoints CODE_POINTS = TextPoints.getCodeBoldPoints14();
    public static final TextPoints ARIAL_P_16 = TextPoints.getInstance("Arial", Font.PLAIN, 16);
    public static final TextPoints ARIAL_B_16 = TextPoints.getInstance("Arial", Font.BOLD, 16);
    public static final TextPoints LG_CODE_POINTS = TextPoints.getCodeBoldPoints18();

    public static int TAB_SIZE = 4;

    public static String TEC_NULL = "TEC_NULL";

    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";

    
    public static TLS_TSPC tspc = null;
    public static TLS_TSPS tsps = null;
    
    public static TecStreamPrinterServer TSPS = null; 
    public static TecStreamPrinterClient TSPC = null; 
    
    public static String getProjectsHome() {
        return ProjectPath.getProjectsHome();
    }

    public static String getTecJarPath() {
        return ProjectPath.getDownloadsPath() + TEC_VERSION + ".jar";
    }

    public static String getLastProjectName() {
        return lastProject.get(lastProject.size() - 1);
    }
    
    public static boolean isDir(String path) {
        path = StringTool.getUnwrapped(path);
        return path.endsWith("/") | path.endsWith("\\");

    }

    public static boolean isJar(String tag) {
        return new File(tag).isJar();

    }

    public static String selectProjectDir() {
        String prj = Platform.requestDirectory(null, new File(ProjectPath.getProjectsHome() + TecData.TEC_VERSION + File.separator), "Select a project...");
        if (prj != null) {
            return new File(prj).getDeepestDirectoryName();
        }
        return null;
    }


}
