package ca.tecreations;
// Netbeans doesn't seem to honor the ANSI codes for 24 bit and 256 color codes
// Also it looks like Netbeans has their own color scheme, which isn't surprising since they changed colors between versions also

// Really, a guy needs to make his own DataStore for version colors and such, and as things change, so will the DataStore
// it's just keeping track of all that and how things work, I guess
import java.util.List;
/**
 *
 * @author Tim
 */
public class SystemToken extends TextToken {
    public int stream;
    public static final int ESC = Integer.parseInt("1b", 16);

    public static int bg = 47;
    
    public static int errBG = bg;
    public static int outBG = bg; 
            
    public static int errFG = 31;
    public static int outFG = 0;
    
    public SystemToken(char ch, int STREAM_TYPE) {
        super(ch);
        this.stream = STREAM_TYPE;
    }
    
    public SystemToken(String text, int STREAM_TYPE) {
        super(text);
        this.stream = STREAM_TYPE;
    }
    
    public String getRaw() {
        return text;
    }
    
    public String getRawWithType() {
        if (stream == TecData.SYS_OUT) return "OUT>" + text;
        else return "ERR>" + text;
    }
    
    public int getStreamType() {
        return stream;
    }
    
    public int getType() {
        return stream;
    }
    
    public boolean isSystemOut() { 
        return stream == TecData.SYS_OUT;
    }
    
    public boolean isSystemErr() { 
        return stream == TecData.SYS_ERR;
    }
    
    public static void main(String[] args) {
        SystemToken out = new SystemToken("Black",TecData.SYS_OUT);
        SystemToken err = new SystemToken("Red",TecData.SYS_ERR);
        out.tPrintln();
        err.tPrintln();
        System.out.println((char)033 + "" + (char)7 + "");
        System.out.println((char)27 + "[1;37;45mTest2");
        int esc = Integer.parseInt("1b",16);
        
        System.out.println((char)esc + "[1;37;45mTest3");
        System.out.println('\u001b' + "[1;37;45mTest4");
        System.out.println('\033' + (char)7 + "");
        System.out.println(out.getTCode(out) + "TCode");
        System.out.println(out.getTCode(out) + "TCode");
        System.err.println(err.getTCode(err) + "TCode");
        System.err.println(err.getTCode(err) + "TCode");
    }
    
    public void print() {
        if (stream == TecData.SYS_OUT) System.out.print(text);
        else System.err.print(text);
    }
    
    public void println() {
        if (stream == TecData.SYS_OUT) System.out.println(text);
        else System.err.println(text);
    }
    
    public void printWithType() {
        if (stream == TecData.SYS_OUT) System.out.println("OUT> '" + text + "'");
        else System.err.println("ERR> '" + text + "'");
    }
    
    public String getTCode(SystemToken token) {
        if (token.getType() == TecData.SYS_ERR) return (char)ESC + "[" + errFG + ";" + errBG + "m";
        else return (char)ESC + "[" + outFG + ";" + outBG + "m";
    }
    
    public void tPrintln() {
        if (stream == TecData.SYS_ERR) System.err.println(getTCode(this) + text);
        else System.out.println(getTCode(this) + text);
    }
    
    public void tPrintln(int index) {
        if (stream == TecData.SYS_ERR) { 
            System.err.println(index + ": " + getTCode(this) + text); 
            System.err.flush(); 
        } else { 
            System.out.println(index + ": " + getTCode(this) + text); 
            System.out.flush(); 
        }
    }
    
    public void tPrintSubst(List<SystemToken> tokens,boolean printIndex) {
        for(int i = 0;i < tokens.size();i++) {
            SystemToken token = tokens.get(i);
            if (printIndex) System.out.println(i + ": " + getTCode(token) + token.getText());
            else System.out.println(getTCode(token) + token.getText());
        }
    }
    
}
