package ca.tecreations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

import javax.swing.DefaultListModel;
 
public class Sort {

    public static List<String> getSorted(List<String> list) {
        return getSorted_ListString(list, true);
    }

    public static List<String> getSorted(String[] array) {
        return getSorted(array, true);
    }

    public static List<String> getSorted(String[] array, boolean ascending) {
        array = sortStringBubble(array);
        List<String> sorted = new ArrayList<>();
        if (ascending) {
            for (int i = 0; i < array.length; i++) {
                sorted.add(array[i]);
            }
        } else {
            for (int i = array.length - 1; i >= 0; i--) {
                sorted.add(array[i]);
            }
        }
        return sorted;
    }

    public static List<String> getSortedByName(File[] list) {
        List<String> sorted = new ArrayList<>();
        int j;
        boolean flag = true;
        File temp;
        while (flag) {
            flag = false;
            for( j = 0; j < list.length - 1; j++) {
                File item = list[j];
                File item2 = list[j+1];
                if (item.getName().compareToIgnoreCase(item2.getName()) > 0) {
                    temp = list[j];
                    list[j] = list[j+1];
                    list[j+1] = temp;
                    flag = true;
                }
            }
        }
        for(int i = 0; i < list.length;i++) {
            sorted.add(list[i].getAbsolutePath());
        }
        return sorted;
    }
    
    public static List<Integer> getSorted_ListInteger(List<Integer> list, boolean ascending) {
        int j;
        boolean flag = true;
        Integer temp;

        while (flag) {
            flag = false;
            if (ascending) {
                for (j = 0; j < list.size() - 1; j++) {
                    if (list.get(j) > list.get(j + 1)) {
                        temp = list.get(j);
                        list.set(j, list.get(j + 1));     // swapping
                        list.set(j + 1, temp);
                        flag = true;
                    }
                }
            } else {
                for (j = list.size() - 1; j > 0; j--) {
                    if (list.get(j - 1) < list.get(j)) {
                        temp = list.get(j);
                        list.set(j, list.get(j - 1));     // swapping
                        list.set(j - 1, temp);
                        flag = true;
                    }
                }
            }
        }
    return list ;
}

public static List<String> getSorted_ListString(List<String> list, boolean ascending) {
        int j;
        boolean flag = true;
        String temp;
        // copy to array
        String[] x = new String[list.size()];
        for(int i = 0; i < list.size();i++) {
            x[i] = list.get(i);
        }
        while (flag) {
            flag = false;
            for(j = 0; j < x.length - 1; j++) {
                if (x[j].compareToIgnoreCase(x[j+1]) > 0) {
                    temp = x[j];
                    x[j] = x[j+1];
                    x[j+1] = temp;
                    flag = true;
               }
           }
        }
        List<String> sorted = new ArrayList<>();
        if (ascending) {
            for(int i = 0; i < x.length;i++) {
                sorted.add(x[i]);
            }
        } else {
            for(int i = x.length - 1;i >= 0;i--) {
                sorted.add(x[i]);
            }
        }
        return sorted;
    }
    
    ///* sort integers...
    public static void main(String[] args) {
        List<String> list = new ArrayList<>();
        list.add("F:\\projects\\tec8\\DirDiff.java");
        list.add("F:\\projects\\tec8\\DeployLocal.class");
        list.add("F:\\projects\\tec8\\ca\\tecreations\\TextFile.java");
        list.add("F:\\projects\\tec8\\ca\\tecreations\\systemtray\\tec.png");
        list.add("F:\\projects\\tec8\\ca\\tecreations\\Sort.class");
        list.add("F:\\projects\\tec8\\BuildAllProjects.java");
        list.add("F:\\projects\\tec8\\ca\\tecreations\\LockFile.java");
        list.add("F:\\projects\\tec8\\Build.java");
        list = sort(list);

        //for(int i = 0;i < list.size();i++) {
        //    System.out.println(i + ": " + list.get(i));
        //}
        
        System.out.println("getDirs: c:\\temp\\: ");
        List<File> dirs = File.getDirs("c:\\temp\\");
        for(int i = 0; i < dirs.size();i++) {
            System.out.println(i + ": " + dirs.get(i).getAbsolutePath());
        }
    }
    //*/
    /* sort strings...
    public static void main(String[] args) {
        List<File> list = new ArrayList<>();
        File[] files = new File("F:\\projects\\tec7\\ca\\tecreations\\apps\\").listFiles();
        for(int i = 0; i < files.length;i++) {
            if (files[i].isDirectory()) {
                list.add(files[i]);
            }
        }
        files = sortByName(list);
        for(int i = 0; i < files.length;i++) {
            System.out.println("File: " + files[i]);
        }
    }
    */
    
    public static void sort(DefaultListModel<String> model) {
        Enumeration<String> v = model.elements();
        java.util.List<String> list = Collections.list(v);
        Collections.sort(list);
        model.removeAllElements();
        for(int i = 0; i < list.size();i++) {
            model.addElement(list.get(i));
        }
    }
    
    public static List<String> sort(String[] values) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        String temp;
        while (flag) {
            flag = false;
            for( j = 0; j < values.length - 1; j++) {
                if (values[j].compareToIgnoreCase(values[j+1]) > 0) {                                             // ascending sort
                    temp = values[j];
                    values[j] = values[j+1];     // swapping
                    values[j+1] = temp; 
                    flag = true;  
                } 
            }
        } 
        List<String> list = new ArrayList<>();
        for(int i = 0; i < values.length;i++) list.add(values[i]);
        return list;
    }
 
    public static List<File> sortListOfFile(List<File> files) {
        return sortByName_getListFile(files);
    }
    
    public static List<File> sortByName_getListFile(List<File> files) {
        File[] array = sortByName(files);
        List<File> theList = new ArrayList<>();
        for(int i = 0; i < array.length;i++) {
            theList.add(array[i]);
        }
        return theList;
    }
    
    public static List<String> sort(List<String> values) {
        String[] vals = new String[values.size()];
        for(int i = 0; i < values.size();i++) vals[i] = values.get(i);
        return sort(vals);
    }
    
    public static File[] sortByName(List<File> list) {
        File[] files = new File[list.size()];
        for(int i = 0; i < list.size();i++) {
            files[i] = list.get(i);
        }
        int j;
        boolean flag = true;  // will determine when the sort is finished
        File temp;

        while (flag) {
            flag = false;
            for( j = 0; j < files.length - 1; j++) {
                //if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 )
                if (files[j].getName().compareToIgnoreCase(files[j+1].getName()) > 0) {
                    temp = files[j];
                    files[j] = files[j+1];
                    files[j + 1] = temp;
                    flag = true;  
                } 
            }
        } 
        return files;
    }
    
    public static List<File> sortToListFile(List<File> entries) {
        File[] temp = sortByName(entries);
        List<File> result = new ArrayList<>();
        for(int i = 0; i < temp.length;i++) result.add(temp[i]);
        return result;
    }
    
    public static void sortStringBubbleKVByKey(String[] keys, String[] values) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        String tempName, tempValue;

        while (flag) {
            flag = false;
            //for ( j = 0;  j < x.length - 1;  j++ )
            for( j = 0; j < keys.length - 1; j++) {
                //if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 )
                if (keys[j].compareToIgnoreCase(keys[j+1]) > 0) {                                             // ascending sort
                    tempName = keys[j];
                    tempValue = values[j];
                    keys[j] = keys[j+1];
                    values[j] = values[j+1];     // swapping
                    keys[j+1] = tempName;
                    values[j+1] = tempValue; 
                    flag = true;  
                } 
            }
        } 
    }
        
    public static void sortStringBubbleKVByValue(String[] keys, String[] values) {
        int j;
        boolean flag = true;  // will determine when the sort is finished
        String tempName, tempValue;
        while (flag) {
            flag = false;
            for( j = 0; j < keys.length - 1; j++) {
                if (values[j].compareToIgnoreCase(values[j+1]) > 0) {                                             // ascending sort
                    tempName = keys[j];
                    tempValue = values[j];
                    keys[j] = keys[j+1];
                    values[j] = values[j+1];     // swapping
                    keys[j+1] = tempName;
                    values[j+1] = tempValue; 
                    flag = true;  
                } 
            }
        } 
    }
    
    public static String[] sortStringBubble(String[]  x) {
        int j;
        boolean flag = true; 
        String temp;

        while (flag) {
            flag = false;
            for ( j = 0;  j < x.length - 1;  j++ ) {
                if ( x [ j ].compareToIgnoreCase( x [ j+1 ] ) > 0 ) {
                    temp = x [ j ];
                    x [ j ] = x [ j+1];     // swapping
                    x [ j+1] = temp; 
                    flag = true;
                } 
            } 
        } 
        return x;
    }  
       
}







// yeah I want to do something totally different, I'd say a 'part', delimited by 'somechar'
// ok, [int(original, sorted)]


// conform your data soon, please. Thank you. Tim.
