package ca.tecreations;

import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author tim
 */
public class ProjectPath {

    public static final ProtectionDomain pd = ProjectPath.class.getProtectionDomain();
    public static Properties properties = new Properties(getTecPropsPath() + "ProjectPath.properties");
    public static String PROJECTS_HOME = properties.get("PROJECTS_HOME");

    public static final ProjectPath instance = new ProjectPath();

    public static String PROJECT_DIR;
    public static boolean debug = false;

    public ProjectPath() {
        this("ProjectPath", ProjectPath.class.getProtectionDomain());
    }

    public ProjectPath(String caller, Class<?> _class) {
        this(caller, _class.getProtectionDomain());
    }

    public ProjectPath(String caller, ProtectionDomain pd) {
        this(caller, ProjectPath.getRuntimePath(pd));
    }

    public ProjectPath(String caller, String absPath) {
        System.out.println(caller + " : Calling ProjectPath(" + absPath + ")");
        File target = new File(absPath);
        String unwrapped = target.getUnwrapped();
        String prjsHome = properties.get("PROJECTS_HOME");
        if (prjsHome != null && !prjsHome.equals("") &&
            unwrapped.startsWith(properties.get("PROJECTS_HOME"))) 
        {
            PROJECTS_HOME = properties.get("PROJECTS_HOME");
            PROJECT_DIR = unwrapped.substring(PROJECTS_HOME.length(), unwrapped.indexOf(File.separator, PROJECTS_HOME.length() + 1));

        } else if (target.exists() && target.isDirectory()) {
            File deepestDir = target.getDeepestDirectory();
            File home = deepestDir.getParent();
            PROJECTS_HOME = home.getUnwrapped();
            PROJECT_DIR = deepestDir.getName();
            String targetUnwrapped = target.getUnwrapped();
            String newTargetPath = targetUnwrapped;
            if (targetUnwrapped.contains("NetBeansProjects")) {
                if (targetUnwrapped.startsWith("/") && File.separator.equals("\\")) {
                    newTargetPath = StringTool.replaceAll(targetUnwrapped, '/', File.separatorChar);
                } else {
                    //            System.err.println("ProjectPath(41): targetUnwrapped: " + targetUnwrapped + " : newTargetPath: " + newTargetPath);
                }
                //        System.out.println("absPath: " + new File(absPath).getAbsolutePath());

                int nbIndex = targetUnwrapped.indexOf("NetBeansProjects");
                int sepIndex = targetUnwrapped.indexOf(File.separatorChar, nbIndex + 1);
                if (properties.get("PROJECTS_HOME") != null) {
                    PROJECTS_HOME = properties.get("PROJECTS_HOME");
                } else {
                    // configure PROJECTS_HOME
                    List<String> labels = new ArrayList<>();
                    labels.add("ProjectPath.PROJECTS_HOME needs to be configured.");
                    labels.add("This is where we keep our projects.");
                    labels.add(" ");
                    labels.add("The data is accessed via ProjectPath.getProjectsHome().");
                    labels.add("The data is stored in: " + ProjectPath.getTecPropsPath() + "ProjectPath.properties");
                    Platform.multiLineMessage(null, labels);
                    PROJECTS_HOME = Platform.requestDirectory(null, Platform.getRoot(), "Select a Directory for PROJECTS_HOME...");
                    while (PROJECTS_HOME == null || PROJECTS_HOME.equals("")) {
                        PROJECTS_HOME = Platform.requestDirectory(null, Platform.getRoot(), "Select a Directory for PROJECTS_HOME...");
                    }
                    if (!new File(PROJECTS_HOME).exists()) {
                        new File(PROJECTS_HOME).mkdirs();
                    }
                    properties.set("PROJECTS_HOME", PROJECTS_HOME);
                }
                PROJECT_DIR = targetUnwrapped.substring(sepIndex + 1, targetUnwrapped.indexOf(File.separatorChar, sepIndex + 1));
            } else if (targetUnwrapped.contains(":") && (targetUnwrapped.endsWith("/") | absPath.endsWith("\\"))) {
                File file = new File(targetUnwrapped);
                File prjDir = file.getDeepestDirectory();
                File prjHome = prjDir.getParent();
                PROJECTS_HOME = prjHome.getUnwrapped();
                PROJECT_DIR = file.getDeepestDirectoryName();
                if (target.getExtension().equals("jar")) {
                    System.err.println("The concepts of a ProjectPath are not applicable to jars.: " + absPath);
                    System.err.println("Perhaps you want a \"Project\"?");
                }
            } else {
                File deepest = target.getDeepestDirectory();
                File parent = deepest.getParent();
                PROJECTS_HOME = parent.getUnwrapped();
                PROJECT_DIR = deepest.getDeepestDirectoryName();
            }
            if (!PROJECTS_HOME.endsWith(File.separator)) {
                PROJECTS_HOME += File.separator;
            }
        }
        if (absPath.endsWith(".jar")) {
            PROJECT_DIR = new File(absPath).getFilenameOnly();
        }
        System.out.println("ProjectPath(): PROJECTS_HOME: " + PROJECTS_HOME + " PROJECT_DIR: " + PROJECT_DIR);
    }

//    public static ProjectPath newInstance() {
//        return new ProjectPath("ProjectPath.newInstance()",ProjectPath.class.getProtectionDomain());
//    }
    public static String getDistPath() {
        return getProjectPath() + "dist" + File.separator;
    }

    public static String getDocumentsPath() {
        return getUserHome() + "Documents" + File.separator;
    }

    public static String getDownloadsPath() {
        return getUserHome() + "Downloads" + File.separator;
    }

    public static String getFontsPath() {
        return getTecreationsPath() + "fonts" + File.separator;
    }

    public static String getJarForProject() {
        return instance.getDownloadsPath() + instance.getProjectDir() + ".jar";
    }

    public static String getJarsPath() {
        return getProjectPath() + "jars" + File.separator;
    }

    public static String getLogsPath() {
        return getProjectPath() + "logs" + File.separator;
    }
    
    public static String getNetConfigPath() {
        return getTecPropsPath() + "NetworkConfig" + File.separator;
    }
    
    public String getPathForProject(String prjLabel) {
        String path = PROJECTS_HOME + prjLabel + File.separator;
        return path;
    }

    public static String getPlatformTempDir() {
        if (Platform.isWin()) {
            return "C:\\temp\\";
        } else {
            return "/tmp/";
        }
    }
    
    public String getProjectDir() {
        return PROJECT_DIR;
    }

    public static String getProjectDir(String projectPath) {
        File f = new File(projectPath);
        String projectDir = f.getDeepestDirectoryName();
        return projectDir;
    }

    public String getProjectDirName(String path) {
        // sanity check
        if (path.contains("\\") && path.contains("/")) {
            throw new IllegalArgumentException("ProjectPath.getProjectDirName: path contains both File.separators: " + path);
        }

        // is it a NetBeansProjects path? 
        String dirName = "";
        if (path.contains("NetBeansProjects")) { // try to specify exactly where
            return getProjectDirFromNetBeansPath(path);
        }

        // process for your IDE here
        return getProjectDirFromProjectsPath(getProjectsHome(), path);
    }

    public static String getProjectDirFromNetBeansPath(String path) {
        int start = 0;
        int end = 0;
        start = path.indexOf(File.separator, path.indexOf("NetBeansProjects") + 1); // the separator after NetBeans
        end = path.indexOf(File.separator, start);
        return path.substring(start, end);
    }

    public static String getProjectDirFromProjectsPath(String prjHome, String path) {
        String prjhome = StringTool.getUnwrapped(prjHome); // ensure we know what we have 
        // ensure prjHome endsWith(File.separator)
        if (prjhome.contains("\\") && prjhome.contains("/")) {
            throw new IllegalArgumentException("getProjectDirFromProjectsPath: cannot contain both File.separator characters: " + prjHome);
        }
        if (path.contains("\\") && path.contains("/")) {
            throw new IllegalArgumentException("getProjectDirFromProjectsPath: cannot contain both File.separator characters: " + path);
        }
        if (!prjhome.endsWith("\\") && !prjhome.endsWith("/")) {
            throw new IllegalArgumentException("getProjectDirFromProjectsPath: prjHome must be a directory: " + prjHome);
        }
        int start = 0;
        start = prjhome.length(); // we already know it ends with a File.separator

        int end = 0;
        if (path.contains("NetBeansProjects")) {
            return getProjectDirFromNetBeansPath(path);
        } else {
            if (path.contains("/")) {
                end = path.indexOf("/", start + 1); // start search after prjHome separator
            } else { // windows
                end = path.indexOf("\\", start + 1);
            }
        }
        return path.substring(start, end);
    }

    public static String getProjectPath() {
        if (PROJECTS_HOME != null) {
            if (!PROJECTS_HOME.endsWith(File.separator)) {
                PROJECTS_HOME += File.separator;
            }
        }
        /**
         * This may contain 'null', if running from a jar.
         */
        return PROJECTS_HOME + PROJECT_DIR + File.separator;
    }

    public static String getProjectPathFromNetbeans(String target) {
        System.out.println("Target: " + target);
        String projectDir = "";
        int index = target.indexOf("NetBeansProjects");
        //System.out.println("Index: " + index);
        index += "NetBeansProjects".length() + 1;
        //System.out.println("Index: " + index);
        while (index < target.length() && target.charAt(index) != '\\' && target.charAt(index) != '/') {
            projectDir += target.charAt(index);
            //System.out.println(index + ": " + projectDir + " : " + target.charAt(index));
            index++;
        }
        return getProjectsHome() + projectDir + File.separator;
    }

    public static String getProjectsHome() {
        return PROJECTS_HOME;
    }

    public static String getPropertiesPath() {
        return instance.getProjectPath() + "properties" + File.separator;
    }

    public static String getPropertiesPath(String projectPath) {
        if (!projectPath.endsWith(File.separator)) {
            projectPath += File.separator;
        }
        return projectPath + "properties" + File.separator;
    }

    public static String getRuntimeJar() {
        //System.out.println("Jar: " + getRuntimePath(ProjectPath.class.getProtectionDomain()));
        String jarPath = getRuntimePath(ProjectPath.class.getProtectionDomain());
        PROJECT_DIR = new File(jarPath).getFilenameOnly();
        return jarPath;
    }
    
    public static String getRuntimePath(ProtectionDomain domain) {
        URL url = domain.getCodeSource().getLocation();
        String path = new File(url.getPath()).getUnwrapped();
        if (File.separator.equals("\\")) {
            if (path.charAt(0) == '/'
                    && (path.charAt(1) >= 'A' && path.charAt(1) <= 'Z')
                    && (path.charAt(2) == ':' && path.charAt(3) == '/')) {
                path = path.substring(1);
                path = StringTool.replaceAll(path, "/", "\\");
            } else {
                System.out.println("ProjectPath.getRuntimePath(): unexpected: " + path);
            }
        }
        if (path.endsWith(File.separator + File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String getSecurityPath() {
        return getProjectPath() + "security" + File.separator;
    }

    public static String getSecurityPath(String projectPath) {
        return projectPath + "security" + File.separator;
    }

    public static String getSourceJarPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + ".jar";
    }

    /**
     * getSubPath(String inFormOfSlashEndingWithSlash)
     *
     * Example: getSubPath("path/to/element/")
     *
     * @param s the target subPath we want conformed to the Platform.separator
     * @return the subpath, conformed to the current platforms File.separator,
     * Example: linux/mac/solaris : getSubPath("path/to/element/"); -- returns
     * Java String: same contents Windows : getSubPath("path/to/element/"); --
     * returns Java String: "path\\to\\element\\"
     *
     */
    public static String getSubPath(String s) {
        return File.getSubPath(s);
    }

    public static String getTecJarPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + ".jar";
    }

    public static String getTecJarJarsPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + "_jars.jar";
    }

    public static String getTecJarsPath(String project) {
        return getTecreationsPath()
                + "jars" + File.separator
                + project + File.separator
                + "jars" + File.separator;
    }

    public static String getTecPropsPath() {
        return getTecreationsPath() + "properties" + File.separator;
    }

    public static String getTecSourceJarPath() {
        return getDownloadsPath() + TecData.TEC_VERSION + ".jar";
    }

    public static String getTecreationsPath() {
        return getDocumentsPath() + "tecreations" + File.separator;
    }

    public static String getTecreationsSourcePathFromFS() {
        String pathToSource = "";
        if (new File(getDocumentsPath() + TecData.TEC_VERSION).exists()) {
            pathToSource = new File(getDocumentsPath() + TecData.TEC_VERSION) + File.separator;
        } else if (new File(getDownloadsPath() + TecData.TEC_VERSION + ".jar").exists()) {
            pathToSource = getDownloadsPath() + TecData.TEC_VERSION + ".jar" + File.separator;
        } else {
            pathToSource = getRuntimePath(ProjectPath.class.getProtectionDomain());
        }
        return pathToSource;
    }

    public static String getUserHome() {
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith(File.separator)) {
            userHome += File.separator;
        }
        return userHome;
    }
    
    public static String getUserTempDir() {
        return getDocumentsPath() + "tec_tmp" + File.separator;
    }
    
    public static boolean isJar() {
        return getRuntimePath(pd).toLowerCase().endsWith(".jar");
    }

    public void print() {
        System.out.println("PP: " + this + " : ProjectPath: " + getProjectPath());
    }

    public static void setProjectDir(String dir) {
        PROJECT_DIR = dir;
    }

    public static void selectProjectsHome(String startPath) {
        String prjsHome = Platform.requestDirectory(null, new File(startPath), "Select PROJECTS_HOME Directory...");
        boolean isWin = Platform.isWin();
        PROJECTS_HOME = prjsHome;
    }

    public static void setProjectsHome(String dir) {
        PROJECTS_HOME = StringTool.getUnwrapped(dir);
        if (!PROJECTS_HOME.endsWith(File.separator)) {
            PROJECTS_HOME += File.separator;
        }
    }
}
