package ca.tecreations;

import ca.tecreations.components.GetPassword;
import ca.tecreations.components.MessageDialog;
import ca.tecreations.components.MultiLineMessageDialog;
import ca.tecreations.components.TFrame;
import ca.tecreations.components.YesNoDialog;
import ca.tecreations.components.event.ProgressListener;
import ca.tecreations.net.ExceptionHandler;
import ca.tecreations.net.TecStreamPrinterClient;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;

import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

/**
 *
 * @author Tim
 */
public class Platform {
    public static Toolkit toolkit = Toolkit.getDefaultToolkit();
    public static Robot robot;
    public static Dimension BEST_CURSOR_SIZE;
    static {
        try {
            robot = new Robot();
        } catch (AWTException awt) {
            System.err.println("Unable to create robot in Platform...()");
        }
        try {
            BEST_CURSOR_SIZE = toolkit.getBestCursorSize(16,16);
        } catch (HeadlessException he) {
            System.err.println("Unable to determine cursor size: Headless.");
        }
    }
    public static String separator = File.separator;
    public static final Platform instance = new Platform();

    public static boolean debug = false;
    public static String RUNTIME_PATH = getRuntimePath();
    public static String CLASS_PATH = System.getProperty("java.class.path");

    public Random random = new Random();
    
    public static BufferedImage captureDesktop() {
        BufferedImage image = null;
        try {
            Rectangle desktopSize = getDesktopSize();
            image = new Robot().createScreenCapture(desktopSize);
        } catch (AWTException awte) {
            System.out.println("No capture: " + awte.toString());
        }
        return image;
    } 
    
    public static YesNoDialog confirm(TFrame tframe,String what) {
        YesNoDialog dialog = new YesNoDialog(tframe,what);
        return dialog;
    }
    
    public static void copyDir(String src, String dst, boolean recursive, boolean debug) {
        System.out.println("Src: " + src + " , Dst: " + dst);
        if (!src.endsWith(File.separator)) src += File.separator;
        if (!dst.endsWith(File.separator)) dst += File.separator;
        if (recursive) {
            copyDir_Recursive(src,src,dst,debug);
        } else {
            File[] files = new File(src).listFiles();
            for(int i = 0;i < files.length;i++) {
                if (files[i].isFile()) {
                    String name = files[i].getName();
                    copyFile(files[i].getAbsolutePath(),dst + name,debug);
                }
            }
        }
    }
    
    public static void copyDir_Recursive(String root, String src, String dst, boolean debug) {
        if (!root.endsWith(File.separator)) root += File.separator;
//        if (!src.endsWith(File.separator)) src += File.separator;
        if (!dst.endsWith(File.separator)) dst += File.separator;
        File[] entries = new File(src).listFiles();
        for(int i = 0; i < entries.length;i++) {
            if (entries[i].isDirectory()) {
                String subPath = File.getSubPath(entries[i].getAbsolutePath(), root);
                String outPath = dst + subPath;
                if (!new File(outPath).exists()) new File(outPath).mkdirs();
                copyDir_Recursive(root,entries[i].getAbsolutePath(), dst, debug);
            } else {
                String parentDir = new File(root).getParent().getName();
                String outPath = dst + parentDir;
                copyFile(entries[i].getAbsolutePath(),outPath + entries[i].getName(),debug);
            }
        }
    }
    
    public static void copyFile(String src, String dst, boolean debug) {
        // show me
        System.out.println("Platform.copyFile: Copying: " + src + " To: " + dst);
        DataInputStream dis = null;
        DataOutputStream dos = null;
        long maxLength = new File(src).length();
        byte[] block = new byte[1024];
        int offset = 0;
        int count = 0;
        boolean errored = false;
        try {
            dis = new DataInputStream(new FileInputStream(src));
        } catch (FileNotFoundException fnfe) {
            System.out.println("Platform.copyFile: Source file not found.");
            errored = true;
        }
        try {
            dos = new DataOutputStream(new FileOutputStream(dst));
        } catch (FileNotFoundException fnfe) {
            System.out.println("Platform.copyFile: Unable to create destination file.");
            errored = true;
        }
        if (dis != null && dos != null) {
            if (debug) {
                System.out.println("Platform.copyFile: Accessing Files: OK");
            }
            while (!errored) {
                try {
                    //System.out.println("Count(1): " + count);
                    count = dis.read(block, 0, 1024);
                } catch (IOException ioe) {
                    System.err.println("Platform.copyFile: Unable to read: " + ioe);
                    errored = true;
                }
                //System.out.println("Count(2): " + count);
                if (count > 0) {
                    if (offset + count <= maxLength) {
                        try {
                            dos.write(block, 0, count);
                            dos.flush();
                            if (debug) {
                                System.out.print("\rWrote: " + (offset + count) + " Of " + maxLength);
                            }
                            offset += count;
                        } catch (IOException ioe) {
                            errored = true;
                            System.err.println("Platform.copyFile: Unable to write: " + ioe);
                        }
                    }
                } else if (count == -1) {
                    if (debug) {
                        System.out.println();
                    }
                    errored = true;
                }
            }
            if (debug) {
                System.out.println("Platform.coyFile: Copied: " + src + " to " + dst);
            }
            try {
                if (dis != null) {
                    dis.close();
                }
                if (dos != null) {
                    dos.close();
                }
            } catch (IOException ioe) {
                System.out.println("Platform.copyFile: IO Exception: closing streams: " + ioe); // do this so we know we are closing objs
            }
        }
    }

    public static void doLogAction(String msg, ProgressListener pl) {
        if (pl != null) pl.addItem(msg);
        System.out.println(msg);
    }
    
    public static void empty(String path) {
        File target = new File(path);
        File[] list = target.listFiles();
        if (list != null && list.length > 0) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isFile()) {
                    list[i].delete();
                }
            }
        }
    }

    public static String getCursorString(Component component) {
        int type = component.getCursor().getType();
        if (type == java.awt.Cursor.CROSSHAIR_CURSOR) return "CROSSHAIR";
        if (type == java.awt.Cursor.DEFAULT_CURSOR) return "DEFAULT";
        if (type == java.awt.Cursor.E_RESIZE_CURSOR) return "E_RESIZE";
        if (type == java.awt.Cursor.HAND_CURSOR) return "HAND";
        if (type == java.awt.Cursor.MOVE_CURSOR) return "MOVE";
        if (type == java.awt.Cursor.NE_RESIZE_CURSOR) return "NE_RESIZE";
        if (type == java.awt.Cursor.NW_RESIZE_CURSOR) return "NW_RESIZE";
        if (type == java.awt.Cursor.N_RESIZE_CURSOR) return "N_RESIZE";
        if (type == java.awt.Cursor.SE_RESIZE_CURSOR) return "SE_RESIZE";
        if (type == java.awt.Cursor.SW_RESIZE_CURSOR) return "SW_RESIZE";
        if (type == java.awt.Cursor.S_RESIZE_CURSOR) return "S_RESIZE";
        if (type == java.awt.Cursor.TEXT_CURSOR) return "TEXT";
        if (type == java.awt.Cursor.WAIT_CURSOR) return "WAIT";
        if (type == java.awt.Cursor.W_RESIZE_CURSOR) return "W_RESIZE";
        return "CUSTOM";
    }
    
    public static Rectangle getDesktopSize() {
        Rectangle desktopSize = new Rectangle(0, 0);
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            desktopSize = desktopSize.union(gd.getDefaultConfiguration().getBounds());
        }
        return desktopSize;
    }

    public static String getDirName() {
        return "NULL + TimSaisSo";
    }
    
    public static String getDirectory(String path) {
        String dir = path.substring(0, path.lastIndexOf(File.separator));
        return dir;
    }

    public static List<File> getDirectories(String path) {
        List<File> list = new ArrayList<>();
        File[] entries = new File(path).listFiles();
        for (int i = 0; i < entries.length; i++) {
            if (entries[i].isDirectory()) {
                list.add(entries[i]);
            }
        }
        return list;
    }

    /**
     * Gets a list of actual directories or folders that start with the given
     * pattern.
     *
     * @param path the parent path of the directory/folder source
     * @param startsWith the starting string, ie "R%iD%i-", where %i means an
     * integer string.
     * @return the list of matching directory paths
     */
    public static List<String> getDirectoryList(String path, String startsWith) {
        List<String> paths = new ArrayList<>();
        if (!path.endsWith(File.separator)) {
            path += File.separator;
        }
        File[] list = new File(path).listFiles();
        for (int i = 0; i < list.length; i++) {
            if (list[i].getAbsolutePath().startsWith(path + startsWith)) {
                paths.add(list[i].getAbsolutePath());
            }
        }
        return paths;
    }

    public static List<String> getDirs(String path) {
        List<String> paths = new ArrayList<>();
        File[] list = new File(path).listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isDirectory()) {
                    paths.add(list[i].getAbsolutePath());
                }
            }
        }
        return paths;
    }

    public static String getFilename() {
        JFileChooser chooser=new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        chooser.showSaveDialog(null);

        String path = chooser.getSelectedFile().getAbsolutePath();
        //String name = new File(path).getFilenameOnly();
        return path;
    }

    public static List<File> getFiles(String path) {
        List<File> list = new ArrayList<>();
        File[] entries = new File(path).listFiles();
        for (int i = 0; i < entries.length; i++) {
            if (entries[i].isFile()) {
                list.add(entries[i]);
            }
        }
        return list;
    }

    public static List<String> getFilesList(String path) {
        List<String> paths = new ArrayList<>();
        File[] list = new File(path).listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                if (list[i].isFile()) {
                    paths.add(list[i].getAbsolutePath());
                }
            }
        }
        return paths;
    }

    public static List<String> getFilesList(String path, String type) {
        type = type.toLowerCase();
        //System.out.println("Platform.getFilesList: type: " + type);
        List<String> paths = new ArrayList<>();
        File[] list = new File(path).listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; i++) {
                //System.out.println("Target: " + list[i].getAbsolutePath());
                if (list[i].isFile() && list[i].getAbsolutePath().toLowerCase().endsWith(type)) {
                    paths.add(list[i].getAbsolutePath());
                }
            }
        }
        return paths;
    }

    public static List<String> getFileLines(String path) {
        //System.err.println("Platform.getFileLines(): path: " + path);
        final Object lock = new Object();
        List<String> lines = new ArrayList<>();
        LineNumberReader reader = null;
        FileReader fileReader = null;
        String unwrappedPath = StringTool.getUnwrapped(path);
        try {
            synchronized (lock) {
                fileReader = new FileReader(unwrappedPath);
                reader = new LineNumberReader(fileReader);
                //System.out.println("Reading: " + absPath);
                try {
                    String line = reader.readLine();
                    if (line != null) {
                        lines.add(line);
                    }
                    if (debug) System.err.println("Line[" + (lines.size() - 1) + "]: '" + line + "'");
                    while (line != null) {
                        line = reader.readLine();
                        if (line != null) {
                            lines.add(line);
                        }
                        if (debug) {
                            System.out.println("Line[" + (lines.size() - 1) + "]: '" + line + "'");
                        }
                    } 
                    fileReader.close();
                    reader.close();
                } catch (IOException ioe) {
                    ExceptionHandler.handleIO("readFileLines","reading: " + path,ioe);
                }
            }
        } catch (FileNotFoundException fnfe) {
            ExceptionHandler.handleIO("readFileLines",path,fnfe);
        } finally {
            try {
                if (reader != null) reader.close();
            } catch (IOException ioe) {
                ExceptionHandler.handleIO("getFileLines","closing 'reader'", ioe);
            }
            try {
                if (fileReader != null) fileReader.close();
            } catch (IOException ioe) {
                ExceptionHandler.handleIO("getFileLines","closing 'fileReader'", ioe);
            }
        }
        return lines;
    }

    public static String getFQCNToPath(Class c) {
        String className = c.getName();
        //System.out.println("FQCN: " + className);
        String path = className.replace('.', File.separator.charAt(0));
        path += File.separator;
        return path;
    }

    public String getIfIsEqual(String s, String t) {
        if (s.equals(t)) {
            return t;
        }
        return null;
    }

    public static String getOwnerClassPathFull(String runtimePath, Class c) {
        String pkg = c.getPackage().toString();
        pkg = pkg.substring("package ".length());
        System.out.println("Runtime Path: " + runtimePath);
        String projDir = "";
        String prjPath = "";
        if (runtimePath.contains("NetBeansProjects")) {
            System.out.println("getOwnerClassPathFull: NetBeans");
            int index1 = runtimePath.indexOf("NetBeansProjects") + "NetBeansProjects".length() + 1;
            int index2 = runtimePath.indexOf(File.separator, index1);
            projDir = runtimePath.substring(index1, index2);
            prjPath = ProjectPath.getDocumentsPath() + projDir + File.separator;
            System.out.println("PrjPath: " + prjPath);
            System.out.println("ProjDir: " + projDir);
        } else if (new File(runtimePath).getExtension().equals("jar")) {
            // jar file, do it different?
        } else {
            // unknown project ? tecreations ? IntelliJ ? CodeBlocks ? 
            System.out.println("getOwnerClassPathFull(runtime: " + runtimePath + " : Class: " + c.toString());
            prjPath = runtimePath.substring(ProjectPath.getDocumentsPath().length());
            System.out.println("PrjPath: " + prjPath);
        }
        pkg = pkg.replace('.', File.separator.charAt(0)) + File.separator + c.getName().substring(c.getName().lastIndexOf('.') + 1);
        return pkg;
    }

    public static String getOwnerClassPathShort(String runtimePath, Class c) {
        String pkg = c.getPackage().toString();
        pkg = pkg.substring("package ".length());
        pkg = pkg.replace('.', File.separator.charAt(0)) + File.separator + c.getName().substring(c.getName().lastIndexOf('.') + 1);
        return pkg;
    }

    
/*    
    public static char[] getPassword() {
        char[] password = null;
        if (isHeadless()) {
            return requestPasswordVIAConsole();
        } else {
            return requestPasswordVIAGUI();
        }
    }
*/
    
    public static String getClientPlatform() {
        //equalsIgnoreCase || equalsLower
        //properties.get("/client.os.name.lower")
        if (isWin()) {
            return "Windows";
        }
        if (isMac()) {
            return "MacOS";
        }
        return "Linux?: '" + System.getProperty("os.name") + "'";
    }

    public static ImageIcon getImageIcon(URL imageURL, String description) {
        if (imageURL != null) {
            return new ImageIcon(imageURL, description);
        } else {
            System.err.println("Couldn't find file: " + imageURL.toString());
            return null;
        }
    }
    
    public static int getNextRandom(int elements) {
        return getRandom(elements);
    }
    
    public static Pixel getPixel(int x, int y) {
        BufferedImage image = captureDesktop();
        return Pixel.getFor(image,x,y);
    }
  
    
    public static int getRandom256() {
        return getRandom(256);
    }
    
    /**
     * @param numElements the number of elements to allow
     * @return 0 to numElements - 1
     */
    public static int getRandom(int numElements) {
        return (int) (Math.random() * numElements);
    } 
  
    /**
     * @return the URL of the resource
     */
    public static String getPath_Class(Class c) {
        URL localPackage = c.getClass().getResource("");
        URL urlLoader = c.getClass().getProtectionDomain().getCodeSource().getLocation();
        String localDir = localPackage.getPath();
        return localDir;
    }
    
    public static String getPath_Loader(Class c) {
        URL localPackage = c.getClass().getResource("");
        URL urlLoader = c.getClass().getProtectionDomain().getCodeSource().getLocation();
        String loaderDir = urlLoader.getPath();
        return loaderDir;
    }
    
    public static File getRoot() {
        return (File.separator.equals("/") ? new File("/") : new File("C:\\"));
    }
    
    public static String getRuntimePath() {
        URL url = Platform.class.getProtectionDomain().getCodeSource().getLocation();
        java.io.File f = null;
        try {
            f = new java.io.File(url.toURI());
        } catch (URISyntaxException urise) {
            System.out.println("Bad URI: " + urise);
        }
        return f.getPath();
    }
    
    public static BufferedImage getScreenCapture() {
        return Platform.captureDesktop();
    }
    
    public static Container getTopLevelContainer(Component c) {
        Container parent = c.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserName() {
        return Platform.getUserName();
    }

    public static void hideCursor(JFrame frame) {
        // Transparent 16 x 16 pixel cursor image.
        BufferedImage cursorImg = new BufferedImage(16, 16, BufferedImage.TYPE_INT_ARGB);
        // Create a new blank cursor.
        Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(
        cursorImg, new Point(0, 0), "blank cursor");

        // Set the blank cursor to the JFrame.
        frame.getContentPane().setCursor(blankCursor);    
    }
    
    public static boolean isDir(String tag) {
        tag = StringTool.getUnwrapped(tag);
        return tag.endsWith("/") || tag.endsWith("\\");

    }
    
    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static boolean isWin() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static boolean isWin7() {
        return System.getProperty("os.name").equals("Windows 7");
    }

    public static boolean isWin10() {
        return System.getProperty("os.name").equals("Windows 10");
    }

    public static boolean isNix() {
        return !isWin();
    }

    public static void killProcess(Long pid) {
        killProcess(pid,false);
    }
    
    public static void killProcess(Long pid,boolean debug) {
        if (pid > 0L) {
            String cmd;
            if (Platform.isNix()) {
                cmd = "sudo kill -9 " + pid;
            } else {
                cmd = "taskkill /F /PID " + pid;
            }
            new SystemTool().runAndGet(cmd,debug); 
        }  
    }
    
    public static void killProcess(long pid, TecStreamPrinterClient tspc) {
        if (pid > 0L) {
            String cmd;
            if (isNix()) {
                cmd = "sudo kill -9 " + pid;
            } else {
                cmd = "taskkill /F /PID " + pid;
            }
            tspc.out("Platform.killProcess: " + cmd);
            new SystemTool().spawn(cmd,false);
        }
    }
    
    public static void killProcess(String pid) {
        killProcess(Long.parseLong(pid),false);
    }
    
    public static void killProcess(String pid, boolean debug) {
        killProcess(Long.parseLong(pid),debug);
    }
    
    public static void killProcess(String pid, TecStreamPrinterClient tspc) {
        killProcess(Long.parseLong(pid),tspc);
    }
    public static void main(String[] args) {

        //char[] pass = requestPasswordVIAConsole();
        //System.out.println("Pass: " + TypeToType.charArrayToString(pass));
        //System.exit(0);
        //String src = "c:\\users\\tim\\documents\\code\\todo.txt";
        //String dst = "c:\\users\\tim\\documents\\code\\copied.file";
        //Platform.copyFile(src,dst);
        //new Diff(src,dst);
        //TFrame frame = new TFrame(ProjectPath.getPropertiesPath() + "Platform");
        //Platform os = new Platform();
        //String filename = os.requestFile(frame, new File("C:\\Users\\Tim de Vries\\Documents\\code\\ca\\tecreations\\"), "Select a file...");
        //System.out.println("Selected: " + filename);
        //System.out.println("Short: " + getOwnerClassPathShort(Platform.getRuntimePath(), Platform.class));
        //System.out.println("Full : " + getOwnerClassPathFull(Platform.getRuntimePath(), Platform.class));

        //System.out.println("FQCNToPath: " + getFQCNToPath(Platform.class));

//        prune("F:\\timtest\\test2\\anything");
        int i = 1;
        int random = getRandom(12);
        while (random != 12) {
            i++;
            System.out.println("Got[" + i + "]: " + random);
            random = getRandom(12);
        }
        System.exit(0);
        
    }

    public static void makeParentDirectory(String path) {
        String parentDir = path.substring(0, path.lastIndexOf(File.separator));
        new File(parentDir).mkdirs();
    }

    public static void message(JFrame app, String msg) {
        new MessageDialog(app, msg);
    }
    
    public static void multiLineMessage(JFrame app, List<String> labels) {
        new MultiLineMessageDialog(app,labels);
    }
    
    public static void prune(String path) {
        File file = new File(path);
        if (file.exists()) file.prune(path,true);
    }
    
    
    public static int nextRandom(int elements) { 
        return getNextRandom(elements);
    }
    
    public static void quickMessage(JFrame app, String msg) {
        MessageDialog dialog = new MessageDialog(app, msg);
        dialog.setCloseTimer(1000);
    }
    
    public static Color requestColor(Color c, String s) {
        JColorChooser chooser = new JColorChooser(c);
        return new Color(chooser.showDialog(null, s, c));
    }

    public static String requestDirectory(Frame f) {
        return requestDirectory(f, "Select A Directory...");
    }

    public static String requestDirectory(Frame f, String title) {
        File[] roots = File.listRoots();
        File path;
        if (File.separator.equals("\\")) {
            path = roots[0];
        } else {
            path = new File("/");
        }
        return requestDirectory(f, path, title);
    }

    public static String requestDirectory(Frame frame, String startPath, String title) {
        return requestDirectory(frame, new File(startPath),title);
    }
    
    public static String requestDirectory(Frame frame, File startPath, String title) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new java.io.File(startPath.getUnwrapped()));
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        String result = "";
        if (chooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
            result = chooser.getSelectedFile().toString() + File.separator;
        } else {
            result = null;
        }
        return result;
    }

    public static String requestFile(Frame f) {
        return requestFile(f, "Select A File...");
    }

    public static String requestFile(Frame f, String title) {
        File[] roots = File.listRoots();
        File path;
        if (File.separator.equals("\\")) {
            path = roots[0];
        } else {
            path = new File("/");
        }
        return requestFile(f, path, title);
    }

    public static String requestFile(Frame frame, File startPath, String title) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new java.io.File(startPath.getUnwrapped()));
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        //chooser.setAcceptAllFileFilterUsed(true);
        String result = "";
        if (chooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
            //System.out.println("getCurrentDirectory(): " +  chooser.getCurrentDirectory());
            //System.out.println("getSelectedFile() : " +  chooser.getSelectedFile());
            result = chooser.getSelectedFile().toString();
        } else {
            return null;
        }
        return result;
    }

    public static char[] requestPassword(TFrame app) {
        return requestPassword(app,"Enter a password...");
    }

    public static char[] requestPassword(TFrame app,String title) {
        GetPassword requestor = new GetPassword(app,title);
        requestor.setVisible(true);
        requestor.toFront();
        return requestor.getPassword();
    }
    
    public static char[] requestPasswordVIAConsole() {
        System.out.println("Enter the password:");
        Console console = System.console();
        char[] pass = console.readPassword();
        return pass;
    }

/*
    public static char[] requestPasswordVIAGUI() {
        GetPasswordDialog passwordDialog = new GetPasswordDialog(null);
        passwordDialog.setSize(320, 240);
        passwordDialog.setVisible(true);
        while (passwordDialog.isVisible()) {
            sleep(1000);
        }
        return passwordDialog.getPassword();
    }
*/

    public static String requestPath(Frame f, String title) {
        String root = (System.getProperty("os.name").toLowerCase().startsWith("win") ? "C:\\" : "/");
        return requestPath(f, new File(root), title);
    }

    public static String requestPath(Frame frame, File root, String title) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new java.io.File(root.getUnwrapped()));
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        //chooser.setAcceptAllFileFilterUsed(true);
        String result = "";
        if (chooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
            return chooser.getSelectedFile().toString();
        } else {
            return null;
        }
    }

    public static void saveScreenshot(String path) {
        BufferedImage screenshot = captureDesktop();
        System.err.println("Saving to: " + path);
        ImageTool.saveImage(screenshot, path);
    }

    public static void setCursor(Image image, Point hotspot,String name) {
        toolkit.createCustomCursor(image,hotspot,name);
    }
    
    public static void setDefaultCursor(Component component) {
        component.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));    
    }
    
    public static void setMoveCursor(Component component) {
        component.setCursor(new Cursor(Cursor.MOVE_CURSOR));    
    }
    
    public static void setTextCursor(Component component) {
        component.setCursor(new Cursor(Cursor.TEXT_CURSOR));    
    }
    
    public static void sleep(long millis) {
        try {
            new Thread().sleep(millis);
        } catch (InterruptedException ie) {
            System.out.println("Global.intterrupted nap: " + ie);
        }
    }

    public static Platform sleepHours(int hours) {
        sleepMinutes(hours * 60);
        return instance;
    }

    public static Platform sleepMinutes(int mins) {
        sleepSeconds(mins * 60);
        return instance;
    }

    public static Platform sleepSeconds(int seconds) {
        sleep(seconds * 1000);
        return instance;
    }

    public static void writeLines(String path, List<String> lines) {
        final Object lock = new Object();
        PrintWriter out = null;
        try {
            synchronized (lock) {
                out = new PrintWriter(StringTool.getUnwrapped(path));
                for (int i = 0; i < lines.size(); i++) {
                    out.println(lines.get(i));
                }
                out.flush();
                out.close();
            }
        } catch (FileNotFoundException fnfe) {
            ExceptionHandler.handleIO("writeLines","file not found: " + path, fnfe);
        }
    }
}
