package ca.tecreations;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
/**
 *
 * @author tim
 */
public class Pixel extends Point {
    public Color color;
    
    public Pixel(int color, int x, int y) {
        super(x,y);
        this.color = new Color(color);
    }
    
    public Pixel(Color color, int x, int y) {
        super(x,y);
        this.color = color;
    }
     
    public void draw(Graphics g) {
        java.awt.Color oldColor = g.getColor();
        g.setColor(color);
        g.drawLine(x,y,x,y);
        g.setColor(oldColor);
    }
    
    public void draw(Graphics g,List<Point> list) {
        java.awt.Color oldColor = g.getColor();
        g.setColor(color);
        Point p;
        for(int i = 0; i < list.size();i++) {
            p = list.get(i);
            g.drawLine(x,y,x,y);
        }
        g.setColor(oldColor);
    }
 
    public Color getColor() { return color; }
    
    public static Pixel getFor(BufferedImage image,int x, int y) {
        return new Pixel(image.getRGB(x,y),x,y);
    }
    
    public int getAlpha() {
        return (color.toIntARGB() & 0xff000000) >> 24;
    }

    public int getBlue() {
        return color.toIntARGB() & 0x000000ff;
    }

    public int getGreen() {
        return (color.toIntARGB() & 0x0000ff00) >> 8;
    }

    public int getRed() {
        return (color.toIntARGB() & 0x00ff0000) >> 16;
    }
    
    public void setColor(Color c) {
        color = c; 
    }
} 
