package ca.tecreations;

import ca.tecreations.net.TLSClient_TVS12;

import java.util.ArrayList;
import java.util.List; 

/**
 *
 * @author tim
 */
public final class FindInFiles_Network {
    TLSClient_TVS12 client;
    int item = 0;
    public List<String> output = new ArrayList<>();
    public static ProjectPath pp;
    
    String needle;
    
    public static boolean debug = false;
    public static boolean trace = true;
    
    // we conform to lowercase for needle and haystack
    
    public FindInFiles_Network(TLSClient_TVS12 client, String rootPath, String needle) {
        this.client = client;
        this.needle = needle.toLowerCase();
        System.out.println("Searching for: " + needle);
//        if (TecData.tspc != null) TecData.tspc.out("FindInFiles(): Searching for: " + needle);
        if (rootPath.toLowerCase().contains(needle)) {
            System.out.println("ProjectPath contains: " + needle + " : " + pp.getProjectPath());
        }
        process(rootPath);
        System.out.println("Done.");
    }
    
    public void check(String path) {
        List<String> lines = client.getText(path);
        String line;
        for(int i = 0; i < lines.size();i++) {
            line = lines.get(i);
            if (line.toLowerCase().indexOf(needle) != -1) {
                System.out.println(++item + ": " + path + " (" + (i+1) + ") : " + line);
            }
        }
    }
    
    public boolean include(String filePath) {
        String xt;
        boolean including;
        File aFile = new File(filePath);
        including = false;
        xt = aFile.getExtension();
        switch (xt) {
            case "c":
            case "cpp":
            case "html":
            case "java":
            case "php":
            case "pl":
            case "properties":
            case "py":
            case "sh":
            case "sql":
            case "txt":
                including = true;
                break;
            default:
                including = false;
                break;
        }
        if (debug) System.out.println(filePath + " : Incl.: " + including);
        return including;
    }

    public void process(String path) {
        List<File> files = client.getFilesList(path);
        List<File> dirs = client.getDirsList(path);
        for(int i = 0; i < files.size();i++) {
            String unwrapped = files.get(i).getUnwrapped();
            if (files.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + files.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            if (include(unwrapped)) check(unwrapped);
        }
        for(int i = 0; i < dirs.size();i++) {
            if (dirs.get(i).getUnwrapped().contains(needle)) {
                System.out.println(++item + ": " + dirs.get(i).getAbsolutePath() + " (" + (i+1) + ")");
            }
            process(dirs.get(i).getAbsolutePath());
        }
    }   
}
 