package ca.tecreations;
import ca.tecreations.components.TFrame;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.*;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import javax.swing.*;
import javax.swing.event.*;
/**
 *
 * @author Tim
 */
public class FindImports extends JPanel implements ActionListener, DocumentListener, FocusListener {
    static String propsFilename;
    static TFrame app;  
    static FindImports instance = new FindImports();
    static Properties properties;
    public static List<String> imports = new ArrayList<>();
    static JTextField projectDir = new JTextField(16);
    static JTextField className = new JTextField(16);
    static JButton find = new JButton("Find");
    String target;
    boolean showJars = true;
    
    public FindImports() {
        instance = this;
    }
    
    public void actionPerformed(ActionEvent e) {
        ProjectPath.instance.setProjectDir(projectDir.getText());
        target = className.getText();
        doOp();
        for(int i = 0; i < imports.size();i++) {
            System.out.println(imports.get(i));
        }
        setProperties();
    }
     
    public void changedUpdate(DocumentEvent e) {
        setProperties();
    }

    public void check(String jarFilename) {
        JarFile jar = null;
        try {
            jar = new JarFile(StringTool.getUnwrapped(jarFilename));
        } catch (IOException ioe) {
            if (ioe instanceof ZipException) {
                // Empty?: 
                if (ioe.getMessage().equals("zip file is empty")) {
                    System.out.println("FileImports.check(): Jar: " + jarFilename + " is empty. Deleting: " + new File(jarFilename).delete(true));
                } else {
                    System.out.println("FileImports.check(): Unable to open jar: " + ioe);
                }
            }
        } 
        if (jar != null) {
            //System.out.println("Processing: " + jarFilename);
            for (Enumeration entries = jar.entries(); entries.hasMoreElements();) {
                // Get the next entry.
                JarEntry entry = (JarEntry)entries.nextElement();
                String name = entry.getName();
                // If the entry is correct, add the import.
                //System.out.println("Entry: " + entry.getName());
                if (name.contains(".")) {
                    String extension = name.substring(name.indexOf(".")+1).toLowerCase();
                    if (extension.equals("class")) {
                        if (name.contains("/")) {
                            String importPart = name.substring(0,name.lastIndexOf("/") + 1);
                            String typeName = name.substring(name.lastIndexOf("/") + 1, name.indexOf("."));
                            String importPkg = importPart.replaceAll("/",".");
                            //System.out.println("ImportPart: " + importPart);
                            //System.out.println("TypeName  : " + typeName);
                            //System.out.println("Checking: " + typeName); 
                            if (typeName.equals(target)) {
                                String line = "import " + importPkg + typeName + ";";
                                if (showJars) line += " // " + jarFilename;
                                imports.add(line);
                            }
                        }
                    }
                }
            } 
        } 
    } 
    
    public static void createAndShowGUI(ProjectPath pp) {
        app = new TFrame(new Properties(pp.getPropertiesPath() + "FindImports.properties"),"FindImports");
        properties = app.getProperties();


        setupGui();
        instance.projectDir.addFocusListener(instance);
        instance.projectDir.getDocument().addDocumentListener(instance);

        className.addFocusListener(instance);
        className.getDocument().addDocumentListener(instance);

        //Make textField get the focus whenever frame is activated.
        app.addWindowFocusListener(new WindowAdapter() {
            public void windowGainedFocus(WindowEvent e) {
                className.requestFocusInWindow();
            }
        });
        app.setLocation(768,0);
        app.setTitle("Find Imports");
        app.getContentPane().add(instance);
        app.setVisible(true);
        app.pack();
        projectDir.setText(pp.getProjectDir());
    }
       
    public void doOp() {
        imports = new ArrayList<>();
        File[] entries = new File(ProjectPath.instance.getJarsPath()).listFiles();
        if (entries != null) {
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    process(entries[i]);
                } else {
                    if (entries[i].getExtension().equals("jar")) {
                        check(entries[i].getAbsolutePath());
                    }
                }
            }
        }
        setProperties();
    }
    
    public void focusGained(FocusEvent e) {
        if (e.getSource() == projectDir) {
            projectDir.selectAll();
            className.setSelectionEnd(0);
        } else {
            className.selectAll();
            projectDir.setSelectionEnd(0);
        }
    }
    
    public void focusLost(FocusEvent e) {}

    public List<String> getImports() { return imports; }
 
    public static FindImports getInstance() { return instance; }
    
    public String getProjectDirFromJarName(String name) {
        List<String> list = parseJarName(name);
        String dir = list.get(0);
        // add if !time && !date, && !tag && !version
        
        return dir;
    }
    
    public String getTag(String s, boolean hyphenBefore) {
        // this is nonsense
        // you could get BC1.69, but no. 
        
        // there was a hyphen before?
        if (hyphenBefore) {
            // okay, so it's now safe to use the string 's', yeah?
            String uAndS = "";
            // do stuff to s, or uAndS
            
            // get what?
            return uAndS;
        }
        return s; // U: tim, this is terrible, you haven't yet coded anything?, Tim: Yeah, just making that entryPointAvailableToU!
    }
    
    public String getVersion(String s) {
        List<String> parts = new ArrayList<>();
        StringBuffer sb = new StringBuffer();
        char ch;
        for(int i = 0; i < s.length();i++) {
            ch = s.charAt(i);
            if (ch == '.') { // next
                if (parts.size() == 0) parts.add(sb.toString());
                sb = new StringBuffer();
            } else if (ch >= '0' && ch <= '9') { // because code pages, ansi, ebcdic
                sb.append(ch);
            } else {
                System.err.println("getVersion: You could... message." + "Failure: target: '" + ch + "' Source: '" + s + "'");
            }
        }
        parts.add(sb.toString());
        if (parts.size() > 3) {
            throw new IllegalArgumentException("getVersion: target String cannot contain more than 3 parts, with up to 2 '.' separators, ie: #??#[.#??#][.#??#]");
        }
        String version = "";
        for(int i = 0; i < parts.size() - 1;i++) {
            version += parts.get(i) + ".";
        }
        version += parts.get(parts.size() - 1);
        return version;
    }
    
    public boolean isDate(String s) {// in yyyy.mm.dd numeric format
        int firstIndex = s.indexOf(".");
        int secondIndex = s.indexOf(".",firstIndex);
        if (firstIndex == -1 || secondIndex == -1) {
            throw new IllegalArgumentException("Received: '" + s + "' : Illegal value: must be in format: '????yyyy.mm.dd' : Numeric or dot only.");
        }
        String y = s.substring(0,firstIndex);
        String m = s.substring(firstIndex+1,secondIndex);
        String d = s.substring(secondIndex+1);
        System.out.println("Parsed as: '" + y + "." + m + "." + d);
        
        // do numeric validation... note that at this point, year month and day can all be out of range.
        // this only checks that the distinct parts are entirely consisting of numeric values.
        char ch;
        for(int i = 0; i < y.length();i++) {
            ch = y.charAt(i);
            if (!(ch >= '0' && ch <= '9')) return false;
        }
        for(int i = 0; i < m.length();i++) {
            ch = m.charAt(i);
            if (!(ch >= '0' && ch <= '9')) return false;
        }
        for(int i = 0; i < d.length();i++) {
            ch = d.charAt(i);
            if (!(ch >= '0' && ch <= '9')) return false;
        }
        
        // now do date validation, from today to future;
        if (Integer.parseInt(y) >= 1920) { // we could split hairs at 1 BC/1 AD, but we'll start from Jan 1, 1920, long before Java
            return monthAndDayInRange(m,d);
        }
        // year < 1920, you could subvert with 1921, but you'd still be in compliance with the code, so... I'll allow it.
        return false;
    }
    
    
    // obligate counting months and days from 1, since using a calendar, not an array.
    // month 1..12, days, 1..?, 28,29,30,31.
    // unless you want to do that 13 month calendar?, ??? , ???
    // Even so, New Years Day.
    public boolean isNewYearsDay(String month, String day) {
        return Integer.parseInt(month) == 1 && Integer.parseInt(day) == 1;
    }
    
    public void insertUpdate(DocumentEvent e) {
        setProperties();
    }

    public static void launch(ProjectPath pp) {
        javax.swing.SwingUtilities.invokeLater(() -> {
            createAndShowGUI(pp);
        });
    } 
    
    public static void main(String[] args) {
        launch(ProjectPath.instance);
    }

    public boolean monthAndDayInRange(String month, String day) {
        int m = Integer.parseInt(month);
        int d = Integer.parseInt(day);
        if (m == 1 && d >= 1 && d <= 31) return true;
        if (m == 2 && d >= 1 && d <= 29) return true; // it may be a leap year, we only care that the month and day are valid possible numbers
        if (m == 3 && d >= 1 && d <= 31) return true;
        if (m == 4 && d >= 1 && d <= 30) return true;
        if (m == 5 && d >= 1 && d <= 31) return true;
        if (m == 6 && d >= 1 && d <= 30) return true;
        if (m == 7 && d >= 1 && d <= 31) return true;
        if (m == 8 && d >= 1 && d <= 31) return true;
        if (m == 9 && d >= 1 && d <= 30) return true;
        if (m == 10 && d >= 1 && d <= 31) return true;
        if (m == 11 && d >= 1 && d <= 30) return true;
        if (m == 12 && d >= 1 && d <= 31) return true;
        return false;
    }
    
    public List<String> parseJarName(String name) {
        List<String> parts = new ArrayList<>();
        StringBuffer buf = new StringBuffer();
        char ch;
        for(int i = 0; i < name.length();i++) {
            ch = name.charAt(i);
            if (ch == '-') {
                parts.add(buf.toString()); // easy to identify, 
                // because size and we know if there are more than 3, 
                // they identify to place, otherwise, versions should be numeric 
                // or it should be a tag
            } else if (parts.size() > 0 && (ch == 'T' && isDate(buf.toString()))) {
                // store date, parse time -- easy because last is .jar
                // && we know time is there, because of the 'T'
            } else {
                buf.append(name.charAt(i));
            }
        }
        return parts;
    }
    
    public void process(File dir) {
        File[] entries = dir.listFiles();
        if (entries != null) {
            for(int i = 0; i < entries.length;i++) {
                if (entries[i].isDirectory()) {
                    process(entries[i]);
                } else {
                    if (entries[i].getExtension().equals("jar")) {
                        check(entries[i].getAbsolutePath());
                    }
                }
            }
        }
    }
    
    public void removeUpdate(DocumentEvent e) {
        setProperties();
    }
    
    public void setProperties() {
        properties.set("project.dir",projectDir.getText());
        properties.set("class.name",className.getText());
    }

    public FindImports setShowJars(boolean state) {
        showJars = state;
        return this;
    }

    public void setTarget(String target) {
        this.target = target;
    }
    
    public static void setupGui() {
        app.setLayout(new BorderLayout());
        JPanel fields = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        fields.add(new JLabel("Project Directory Name: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 6;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        fields.add(projectDir,gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = gbc.NONE;
        fields.add(new JLabel("Class (Type) Name: "),gbc);
        
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 6;
        gbc.gridheight = 1;
        gbc.fill = gbc.HORIZONTAL;
        fields.add(className,gbc);
        app.add(fields,BorderLayout.NORTH);
        className.addActionListener(instance);
        // no document, no item state changed, 
        // nothing
        //onChange(set)//????
        
        app.add(find,BorderLayout.SOUTH);
        find.addActionListener(instance);
    }

    public boolean startsNumeric(String s) {
        char char1 = s.charAt(0);
        return char1 >= '0' && char1 <= '9'; // because code pages
    }
}
