package ca.tecreations;

import ca.tecreations.net.SharedCode;

/**
 *
 * @author Tim
 */
public class Drag {
    Click start;
    Click stop;
    int dx;
    int dy;
    byte v; 
    byte h;
    public static final byte UP = 1;
    public static final byte DOWN = -1;

    public static final byte LEFT = -1;
    public static final byte RIGHT = 1;
    
    public static final byte CENTER = 0;
    
    
    
    public Drag(Click start, Click stop) {
        this.start = start;
        this.stop = stop;
        int startx = start.getLocX();
        int starty = start.getLocY();
        int stopx = stop.getLocX();
        int stopy = stop.getLocY();
        if (startx < stopx) {
            dx = stopx - startx;
            h = RIGHT;
        } else if (startx > stopx) {
            dx = startx - stopx;
            h = LEFT;
        } else {
            dx = 0;
            h = CENTER;
        }
        if (starty < stopy) {
            dy = stopy - starty;
            v = UP;
        } else if (starty < stopy) {
            dy = starty - stopy;
            v = DOWN;
        } else {
            dy = 0;
            v = CENTER;
        }
    }
    
    public static Drag getFromPackaged(String s) {
        if (StringTool.isBackticked(s)) {
            String remainder = StringTool.getUnwrapped(s);
            Click start = null;
            Click stop = null;
            String quotedStart = SharedCode.getFirstQuoted(remainder);
            if (StringTool.isDoubleQuoted(quotedStart)) {
                start = Click.fromString(StringTool.getUnwrapped(quotedStart));
            }
            remainder = SharedCode.getNextChunk(remainder,quotedStart.length());
            System.out.println("Remainder (1): " + remainder);
            remainder = remainder.trim();
            if (remainder.startsWith(",")) {
                remainder = remainder.substring(1).trim();
            }
            String quotedStop = remainder; // if properly coded
            stop = Click.fromString(StringTool.getUnwrapped(remainder));
            
            if (start != null && stop != null) {
                Drag drag = new Drag(start,stop);
                drag.setStart(start);
                drag.setStop(stop); 
                return drag;
            } else {
                System.err.println("Drag.getFromPackaged: Programming Error: '" + s + "'");
            }
            return null;
        } else {
            throw new IllegalArgumentException("Drag.getFromPackaged: Not Backticked: " + s);
        }
    }
    
    public String getPackaged() {
        String transportString = "";
        transportString = StringTool.getBackticked(toString());
        return transportString;
    }
 
    public Click getStart() { return start; }
    
    public int getStartButtonsMask() { return start.getButtonsMask(); }
    
    public int getStopButtonsMask() { return stop.getButtonsMask(); }
    
    public Click getStop() { return stop; }
    
    public void setStart(Click click) {
        start = click;
    }
    
    public void setStop(Click click) {
        stop = click;
    }

    public String toString() {
        return start.toDoubleQuoted() + "," + stop.toDoubleQuoted();
    }
    
}
